/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Objects;

final class CellReference {
    private static final String EMPTY = "";
    private static final int DEFAULT_ROW = 0;
    private static final String DEFAULT_COLUMN = "";
    private final String string;
    private int row;
    private String column;
    private boolean split;

    CellReference(int row, String column) {
        this(column + row, row, column);
    }

    CellReference(String string) {
        this(string, 0, "");
    }

    CellReference(String string, int row, String column) {
        this.string = string;
        this.row = row;
        this.column = column;
    }

    int row() {
        if (!this.split) {
            this.split();
        }
        return this.row;
    }

    String column() {
        if (!this.split) {
            this.split();
        }
        return this.column;
    }

    private void split() {
        if (!"".equals(this.string) && (0 == this.row || "".equals(this.column))) {
            for (int j = 1; j < this.string.length(); ++j) {
                char c = this.string.charAt(j);
                if (!Character.isDigit(c)) continue;
                this.column = this.string.substring(0, j);
                this.row = Integer.parseUnsignedInt(this.string.substring(j));
                break;
            }
        }
        this.split = false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CellReference that = (CellReference)o;
        return this.string.equals(that.string);
    }

    public int hashCode() {
        return Objects.hash(this.string);
    }

    public String toString() {
        return this.string;
    }
}

