/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiUnexpectedRevisionException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.filters.openxml.Cells;
import net.sf.okapi.filters.openxml.ContentCategoriesDetection;
import net.sf.okapi.filters.openxml.ContentFilter;
import net.sf.okapi.filters.openxml.DefaultPart;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.ExcelCommentPart;
import net.sf.okapi.filters.openxml.ExcelStyleDefinitions;
import net.sf.okapi.filters.openxml.ExcelStyleDefinitionsReader;
import net.sf.okapi.filters.openxml.IndexedColors;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupModifiablePart;
import net.sf.okapi.filters.openxml.Metadata;
import net.sf.okapi.filters.openxml.ModifiablePart;
import net.sf.okapi.filters.openxml.NonModifiablePart;
import net.sf.okapi.filters.openxml.NumberingDefinitions;
import net.sf.okapi.filters.openxml.ParseType;
import net.sf.okapi.filters.openxml.Part;
import net.sf.okapi.filters.openxml.PartPath;
import net.sf.okapi.filters.openxml.PivotCacheDefinition;
import net.sf.okapi.filters.openxml.PivotTable;
import net.sf.okapi.filters.openxml.PresetColorValues;
import net.sf.okapi.filters.openxml.Relationship;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.RelationshipsPart;
import net.sf.okapi.filters.openxml.RevisionHeaderFragments;
import net.sf.okapi.filters.openxml.RevisionHeadersFragments;
import net.sf.okapi.filters.openxml.RevisionLogFragments;
import net.sf.okapi.filters.openxml.SharedStringsFragments;
import net.sf.okapi.filters.openxml.SharedStringsPart;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleOptimisation;
import net.sf.okapi.filters.openxml.StyledTextPart;
import net.sf.okapi.filters.openxml.SystemColorValues;
import net.sf.okapi.filters.openxml.Table;
import net.sf.okapi.filters.openxml.WorkbookFragments;
import net.sf.okapi.filters.openxml.WorkbookPart;
import net.sf.okapi.filters.openxml.Worksheet;
import net.sf.okapi.filters.openxml.WorksheetFragments;
import net.sf.okapi.filters.openxml.ZipEntryComparator;

class ExcelDocument
implements Document {
    private static final String EMPTY = "";
    private static final String REVISION_HEADERS = "/revisionHeaders";
    private static final String USER_NAMES = "/usernames";
    private static final String STYLES = "/styles";
    private static final String TABLE = "/table";
    private static final String PIVOT_TABLE = "/pivotTable";
    private static final String PIVOT_CACHE_DEFINITION = "/pivotCacheDefinition";
    private static final String COMMENT = "/comments";
    private static final String DRAWING = "/drawing";
    private static final String CHART = "/chart";
    private static final String DIAGRAM_DATA = "/diagramData";
    private static final String SHARED_STRINGS = "/sharedStrings";
    private final Document.General generalDocument;
    private final EncoderManager encoderManager;
    private final IFilter subfilter;
    private Map<Metadata, Set<String>> dispersedTranslationRawSourcesByMetadata;
    private Map<ZipEntry, Markup> postponedParts;
    private Cells cells;
    private String revisionHeadersPartName;
    private String revisionUserNamesPartName;
    private String relationshipsPartNameForRevisionHeaders;
    private Set<String> revisionLogPartNames;
    private WorkbookFragments workbookFragments;
    private Enumeration<? extends ZipEntry> entries;
    private PresetColorValues highlightColorValues;
    private SystemColorValues.Default systemColorValues;
    private StyleDefinitions styleDefinitions;
    private SharedStringsFragments sharedStringsFragments;
    private Map<String, Set<String>> tablesByWorksheet;
    private Map<String, Set<String>> pivotTablesByWorksheet;
    private Map<String, Set<String>> pivotCacheDefinitionsByPivotTable;
    private Map<String, String> worksheetsByComment;
    private Map<String, String> worksheetsByDrawing;
    private Map<String, String> drawingsByChart;
    private Map<String, String> drawingsByDiagramData;

    ExcelDocument(Document.General generalDocument, EncoderManager encoderManager, IFilter subfilter) {
        this.generalDocument = generalDocument;
        this.encoderManager = encoderManager;
        this.subfilter = subfilter;
    }

    @Override
    public Event open() throws IOException, XMLStreamException {
        this.dispersedTranslationRawSourcesByMetadata = new HashMap<Metadata, Set<String>>();
        this.postponedParts = new LinkedHashMap<ZipEntry, Markup>();
        this.sharedStringsFragments = this.sharedStringsFragments();
        this.cells = new Cells.Default(this.generalDocument.conditionalParameters().getTranslateExcelCellsCopied(), this.generalDocument.eventFactory(), this.sharedStringsFragments);
        this.refineContentTypesAndMainPartRelationships();
        this.loadAndCheckRevisions();
        this.workbookFragments = this.workbookFragments();
        this.highlightColorValues = new PresetColorValues.Default(Collections.emptyList());
        this.systemColorValues = new SystemColorValues.Default();
        this.styleDefinitions = this.styleDefinitions();
        this.tablesByWorksheet = this.tablesByWorksheet();
        this.pivotTablesByWorksheet = this.pivotTablesByWorksheet();
        this.pivotCacheDefinitionsByPivotTable = this.pivotCacheDefinitionsByPivotTable();
        this.worksheetsByComment = this.worksheetsBy(COMMENT);
        this.worksheetsByDrawing = this.worksheetsBy(DRAWING);
        this.drawingsByChart = this.drawingsBy(CHART);
        this.drawingsByDiagramData = this.drawingsBy(DIAGRAM_DATA);
        this.entries = this.entries();
        return this.generalDocument.startDocumentEvent();
    }

    private SharedStringsFragments sharedStringsFragments() throws IOException, XMLStreamException {
        SharedStringsFragments.Default fragments = new SharedStringsFragments.Default();
        String partPath = this.generalDocument.targetFor(SHARED_STRINGS);
        if (!EMPTY.equals(partPath)) {
            try (Reader reader = this.generalDocument.getPartReader(partPath);){
                fragments.readWith(this.generalDocument.inputFactory().createXMLEventReader(reader));
            }
        }
        return fragments;
    }

    private void refineContentTypesAndMainPartRelationships() throws XMLStreamException {
        String sharedStringsPartPath = this.generalDocument.targetFor(SHARED_STRINGS);
        if (EMPTY.equals(sharedStringsPartPath)) {
            this.generalDocument.contentTypes().addFrom(new PartPath.Default("/", new String[0]).resolve(this.generalDocument.mainPartBasePath()).resolve("sharedStrings.xml").asString(), "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml");
            this.generalDocument.mainPartRelationships().addFrom(this.generalDocument.mainPartRelationshipsNamespace().uri().concat(SHARED_STRINGS), "sharedStrings.xml");
        }
    }

    private void loadAndCheckRevisions() throws XMLStreamException, IOException {
        this.revisionHeadersPartName = this.revisionHeadersPartName();
        this.revisionUserNamesPartName = this.revisionUserNamesPartName();
        this.revisionLogPartNames = new HashSet<String>();
        if (!this.revisionHeadersPartName.isEmpty()) {
            this.relationshipsPartNameForRevisionHeaders = this.generalDocument.relationshipsPartPathFor(this.revisionHeadersPartName).asString();
            String revisionHeadersNamespaceUri = this.generalDocument.mainPartRelationshipsNamespace().uri().concat(REVISION_HEADERS);
            Iterator<Relationship> revisionHeadersRelationshipsIterator = this.generalDocument.mainPartRelationships().of(revisionHeadersNamespaceUri).iterator();
            if (!revisionHeadersRelationshipsIterator.hasNext()) {
                throw new OkapiBadFilterInputException(String.format("%s: %s", "Unexpected number of relationships", revisionHeadersNamespaceUri));
            }
            Relationships revisionHeadersRelationships = this.generalDocument.relationshipsFor(this.revisionHeadersPartName);
            for (RevisionHeaderFragments revisionHeaderFragments : this.revisionHeadersFragments()) {
                Iterator<Relationship> ri = revisionHeadersRelationships.with(revisionHeaderFragments.revisionLogId()).iterator();
                if (!ri.hasNext()) {
                    throw new OkapiBadFilterInputException(String.format("%s: %s", "Unexpected number of relationships", revisionHeaderFragments.revisionLogId()));
                }
                String revisionLogPartName = ri.next().target();
                RevisionLogFragments revisionLogFragments = this.revisionLogFragmentsFor(revisionLogPartName);
                if (!this.generalDocument.conditionalParameters().getAutomaticallyAcceptRevisions() && !revisionHeaderFragments.reviewed(revisionLogFragments.revisionIds())) {
                    throw new OkapiUnexpectedRevisionException();
                }
                this.revisionLogPartNames.add(revisionLogPartName);
            }
        } else {
            this.relationshipsPartNameForRevisionHeaders = EMPTY;
        }
    }

    private String revisionHeadersPartName() {
        return this.generalDocument.targetFor(REVISION_HEADERS);
    }

    private String revisionUserNamesPartName() {
        return this.generalDocument.targetFor(USER_NAMES);
    }

    private RevisionHeadersFragments revisionHeadersFragments() throws IOException, XMLStreamException {
        RevisionHeadersFragments.Default rhf = new RevisionHeadersFragments.Default();
        try (Reader reader = this.generalDocument.getPartReader(this.revisionHeadersPartName);){
            rhf.readWith(this.generalDocument.inputFactory().createXMLEventReader(reader));
        }
        return rhf;
    }

    private RevisionLogFragments revisionLogFragmentsFor(String partName) throws IOException, XMLStreamException {
        RevisionLogFragments.Default rlf = new RevisionLogFragments.Default();
        try (Reader reader = this.generalDocument.getPartReader(partName);){
            rlf.readWith(this.generalDocument.inputFactory().createXMLEventReader(reader));
        }
        return rlf;
    }

    private WorkbookFragments workbookFragments() throws IOException, XMLStreamException {
        WorkbookFragments.Default wf = new WorkbookFragments.Default(this.generalDocument.conditionalParameters(), this.generalDocument.mainPartRelationships());
        try (Reader reader = this.generalDocument.getPartReader(this.generalDocument.mainPartPath());){
            wf.readWith(this.generalDocument.inputFactory().createXMLEventReader(reader));
        }
        return wf;
    }

    private Enumeration<? extends ZipEntry> entries() throws IOException, XMLStreamException {
        String sharedStringsPartPath = this.generalDocument.targetFor(SHARED_STRINGS);
        boolean sharedStringsPartAvailable = false;
        ArrayList<? extends ZipEntry> entryList = new ArrayList<ZipEntry>();
        entryList.addAll(Collections.list(this.generalDocument.entries()));
        ListIterator iterator = entryList.listIterator();
        while (iterator.hasNext()) {
            String name = ((ZipEntry)iterator.next()).getName();
            if (name.equals(this.revisionHeadersPartName) || name.equals(this.revisionUserNamesPartName) || name.equals(this.relationshipsPartNameForRevisionHeaders) || this.revisionLogPartNames.contains(name)) {
                iterator.remove();
            }
            if (!name.equals(sharedStringsPartPath)) continue;
            sharedStringsPartAvailable = true;
        }
        if (!sharedStringsPartAvailable) {
            entryList.add(new ZipEntry(sharedStringsPartPath));
        }
        entryList.sort(new ZipEntryComparator(this.reorderedPartPaths()));
        return Collections.enumeration(entryList);
    }

    private List<String> reorderedPartPaths() throws IOException, XMLStreamException {
        List names = Stream.of(this.tablesByWorksheet.values(), this.pivotTablesByWorksheet.values(), this.pivotCacheDefinitionsByPivotTable.values()).flatMap(Collection::stream).flatMap(Collection::stream).collect(Collectors.toCollection(ArrayList::new));
        names.addAll(this.workbookFragments.worksheetPartNames());
        String sharedStringsPartPath = this.generalDocument.targetFor(SHARED_STRINGS);
        if (!EMPTY.equals(sharedStringsPartPath)) {
            names.add(sharedStringsPartPath);
        }
        names.add(this.generalDocument.mainPartPath());
        String stylesPartPath = this.generalDocument.targetFor(STYLES);
        if (!EMPTY.equals(stylesPartPath)) {
            names.add(stylesPartPath);
        }
        return names;
    }

    private StyleDefinitions styleDefinitions() throws IOException, XMLStreamException {
        String partPath = this.generalDocument.targetFor(STYLES);
        if (null == partPath) {
            return new StyleDefinitions.Empty();
        }
        try (Reader reader = this.generalDocument.getPartReader(partPath);){
            ExcelStyleDefinitions styleDefinitions = new ExcelStyleDefinitions();
            styleDefinitions.readWith(new ExcelStyleDefinitionsReader(this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), this.generalDocument.presetColorValues(), this.highlightColorValues, this.systemColorValues, new IndexedColors.Default(this.systemColorValues), this.generalDocument.mainPartTheme(), this.generalDocument.inputFactory().createXMLEventReader(reader)));
            ExcelStyleDefinitions excelStyleDefinitions = styleDefinitions;
            return excelStyleDefinitions;
        }
    }

    private Map<String, Set<String>> tablesByWorksheet() throws IOException, XMLStreamException {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        String uri = this.generalDocument.mainPartRelationshipsNamespace().uri().concat(TABLE);
        for (String name : this.workbookFragments.worksheetPartNames()) {
            map.put(name, this.relatedPartsFor(name, uri));
        }
        return map;
    }

    private Map<String, Set<String>> pivotTablesByWorksheet() throws IOException, XMLStreamException {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        String uri = this.generalDocument.mainPartRelationshipsNamespace().uri().concat(PIVOT_TABLE);
        for (String name : this.workbookFragments.worksheetPartNames()) {
            map.put(name, this.relatedPartsFor(name, uri));
        }
        return map;
    }

    private Map<String, Set<String>> pivotCacheDefinitionsByPivotTable() throws IOException, XMLStreamException {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        String uri = this.generalDocument.mainPartRelationshipsNamespace().uri().concat(PIVOT_CACHE_DEFINITION);
        Iterator pivotTableNamesIterator = this.pivotTablesByWorksheet.values().stream().flatMap(Collection::stream).iterator();
        while (pivotTableNamesIterator.hasNext()) {
            String name = (String)pivotTableNamesIterator.next();
            map.put(name, this.relatedPartsFor(name, uri));
        }
        return map;
    }

    private Set<String> relatedPartsFor(String name, String uri) throws IOException, XMLStreamException {
        return new HashSet<String>(this.generalDocument.targetsOf(this.generalDocument.relationshipsFor(name).of(uri)));
    }

    private Map<String, String> worksheetsBy(String relatedPart) throws IOException, XMLStreamException {
        String namespaceUri = this.generalDocument.mainPartRelationshipsNamespace().uri();
        return this.generalDocument.partsByRelatedPart(this.workbookFragments.worksheetPartNames(), namespaceUri.concat(relatedPart));
    }

    private Map<String, String> drawingsBy(String relatedPart) throws IOException, XMLStreamException {
        String namespaceUri = this.generalDocument.mainPartRelationshipsNamespace().uri();
        return this.generalDocument.partsByRelatedPart(new ArrayList<String>(this.worksheetsByDrawing.keySet()), namespaceUri.concat(relatedPart));
    }

    @Override
    public PresetColorValues highlightColorValues() {
        return this.highlightColorValues;
    }

    @Override
    public SystemColorValues systemColorValues() {
        return this.systemColorValues;
    }

    @Override
    public IndexedColors indexedColors() {
        return this.styleDefinitions.indexedColors();
    }

    @Override
    public boolean hasNextPart() {
        return this.entries.hasMoreElements() || !this.postponedParts.isEmpty();
    }

    @Override
    public Part nextPart() throws IOException, XMLStreamException {
        String contentType;
        ZipEntry entry;
        block53: {
            block54: {
                if (!this.entries.hasMoreElements()) {
                    return this.nextPostponedPart();
                }
                entry = this.entries.nextElement();
                contentType = this.generalDocument.contentTypeFor(entry);
                if (this.isTranslatablePart(entry.getName(), contentType)) break block53;
                if (!this.isModifiablePart(entry.getName(), contentType)) break block54;
                if ("[Content_Types].xml".equals(entry.getName())) {
                    return new MarkupModifiablePart(this.generalDocument, entry, this.generalDocument.contentTypes().asMarkup());
                }
                switch (contentType) {
                    case "application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml": {
                        String worksheetPartName = this.tablesByWorksheet.entrySet().stream().filter(e -> ((Set)e.getValue()).contains(entry.getName())).map(e -> (String)e.getKey()).findFirst().orElseThrow(() -> new IllegalStateException("Unlinked table part found: ".concat(entry.getName())));
                        String worksheetName = this.workbookFragments.localisedWorksheetNameFor(worksheetPartName);
                        Table.Default table = new Table.Default(this.generalDocument.eventFactory(), worksheetName);
                        try (Reader reader = this.generalDocument.getPartReader(entry.getName());){
                            table.readWith(this.generalDocument.inputFactory().createXMLEventReader(reader));
                        }
                        if (!this.isTableHidden(entry.getName())) {
                            this.dispersedTranslationRawSourcesByMetadata.put(new Metadata(worksheetName, table.cellReferencesRange(), table.name()), table.columnNames());
                        }
                        this.postponedParts.put(entry, table.asMarkup());
                        break;
                    }
                    case "application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml": {
                        PivotTable.Default pivotTable = new PivotTable.Default(this.generalDocument.eventFactory());
                        try (Reader reader = this.generalDocument.getPartReader(entry.getName());){
                            pivotTable.readWith(this.generalDocument.inputFactory().createXMLEventReader(reader));
                        }
                        if (!this.isPivotTableHidden(entry.getName())) {
                            String worksheetPartName = this.pivotTablesByWorksheet.entrySet().stream().filter(e -> ((Set)e.getValue()).contains(entry.getName())).map(e -> (String)e.getKey()).findFirst().orElseThrow(() -> new IllegalStateException("Unlinked pivot table part found: ".concat(entry.getName())));
                            this.dispersedTranslationRawSourcesByMetadata.put(new Metadata(this.workbookFragments.localisedWorksheetNameFor(worksheetPartName), pivotTable.cellReferencesRange(), pivotTable.name()), pivotTable.dataFieldNames());
                        }
                        this.postponedParts.put(entry, pivotTable.asMarkup());
                        break;
                    }
                    case "application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheDefinition+xml": {
                        PivotCacheDefinition.Default pcd = new PivotCacheDefinition.Default(this.generalDocument.eventFactory());
                        try (Reader reader = this.generalDocument.getPartReader(entry.getName());){
                            pcd.readWith(this.generalDocument.inputFactory().createXMLEventReader(reader));
                        }
                        if (!(this.isPivotCacheDefinitionHidden(entry.getName()) || pcd.sheetNameSource().isEmpty() || pcd.cellReferencesRangeSource().toString().isEmpty())) {
                            this.dispersedTranslationRawSourcesByMetadata.put(new Metadata(pcd.sheetNameSource(), pcd.cellReferencesRangeSource(), pcd.sheetNameSource()), pcd.cacheFieldNames());
                        }
                        this.postponedParts.put(entry, pcd.asMarkup());
                        break;
                    }
                    case "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml": {
                        Worksheet.Default worksheet = new Worksheet.Default(this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), this.sharedStringsFragments, this.workbookFragments.date1904(), this.cells, this.styleDefinitions, this.workbookFragments.localisedWorksheetNameFor(entry.getName()), new WorksheetFragments.Default(this.generalDocument.conditionalParameters().getCleanupAggressively(), this.generalDocument.conditionalParameters().getTranslateExcelHidden(), this.isWorksheetHidden(entry.getName())));
                        try (Reader reader = this.generalDocument.getPartReader(entry.getName());){
                            worksheet.readWith(this.generalDocument.inputFactory().createXMLEventReader(reader));
                        }
                        this.postponedParts.put(entry, worksheet.asMarkup());
                        break;
                    }
                    case "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml": {
                        return new MarkupModifiablePart(this.generalDocument, entry, this.styleDefinitions.asMarkup());
                    }
                    case "application/vnd.openxmlformats-officedocument.theme+xml": {
                        return new ModifiablePart(this.generalDocument, entry, this.generalDocument.inputStreamFor(entry));
                    }
                    case "application/vnd.openxmlformats-package.relationships+xml": {
                        return new MarkupModifiablePart(this.generalDocument, entry, this.generalDocument.mainPartRelationships().asMarkup());
                    }
                    default: {
                        throw new IllegalStateException("Unsupported modifiable content type: ".concat(contentType));
                    }
                }
                return this.nextPart();
            }
            return new NonModifiablePart(this.generalDocument, entry);
        }
        if (this.isStyledTextPart(entry)) {
            StyleDefinitions styleDefinitions = this.styleDefinitionsFor(entry);
            StyleOptimisation.Bypass styleOptimisation = new StyleOptimisation.Bypass();
            NumberingDefinitions.Empty numberingDefinitions = new NumberingDefinitions.Empty();
            ContentCategoriesDetection.NonApplicable contentCategoriesDetection = new ContentCategoriesDetection.NonApplicable();
            if ("application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml".equals(contentType)) {
                return new SharedStringsPart(this.generalDocument, entry, styleDefinitions, styleOptimisation, numberingDefinitions, contentCategoriesDetection, this.encoderManager, this.subfilter, this.dispersedTranslationRawSourcesByMetadata, this.cells);
            }
            if ("application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml".equals(contentType)) {
                return new ExcelCommentPart(this.generalDocument, entry, this.highlightColorValues, styleDefinitions, styleOptimisation, numberingDefinitions, contentCategoriesDetection);
            }
            return new StyledTextPart(this.generalDocument, entry, styleDefinitions, styleOptimisation, numberingDefinitions, contentCategoriesDetection);
        }
        if ("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml".equals(contentType) || "application/vnd.ms-excel.sheet.macroEnabled.main+xml".equals(contentType)) {
            return new WorkbookPart(this.generalDocument, entry, this.workbookFragments);
        }
        if ("application/vnd.openxmlformats-package.relationships+xml".equals(contentType)) {
            Relationships relationships = entry.getName().equals(this.generalDocument.relationshipsPartPathFor(this.generalDocument.mainPartPath()).asString()) ? this.generalDocument.mainPartRelationships() : this.generalDocument.relationshipsFrom(entry.getName());
            return new RelationshipsPart(this.generalDocument, entry, relationships);
        }
        ParseType parseType = ParseType.MSEXCEL;
        if ("application/vnd.openxmlformats-package.core-properties+xml".equals(contentType)) {
            parseType = ParseType.MSWORDDOCPROPERTIES;
        }
        ContentFilter contentFilter = new ContentFilter(this.generalDocument.conditionalParameters(), entry.getName());
        contentFilter.setUpConfig(parseType);
        return new DefaultPart(this.generalDocument, entry, contentFilter);
    }

    private Part nextPostponedPart() {
        Iterator<Map.Entry<ZipEntry, Markup>> iterator = this.postponedParts.entrySet().iterator();
        Map.Entry<ZipEntry, Markup> mapEntry = iterator.next();
        iterator.remove();
        return new MarkupModifiablePart(this.generalDocument, mapEntry.getKey(), mapEntry.getValue());
    }

    @Override
    public StyleDefinitions styleDefinitionsFor(ZipEntry entry) {
        return new StyleDefinitions.Empty();
    }

    private boolean isTranslatablePart(String entryName, String contentType) throws XMLStreamException, IOException {
        if (!entryName.endsWith(".xml") && !entryName.endsWith(".rels")) {
            return false;
        }
        if (this.isHidden(entryName, contentType)) {
            return false;
        }
        switch (contentType) {
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml": 
            case "application/vnd.ms-excel.sheet.macroEnabled.main+xml": {
                return this.generalDocument.conditionalParameters().getTranslateExcelSheetNames();
            }
            case "application/vnd.openxmlformats-package.relationships+xml": {
                return this.generalDocument.conditionalParameters().getExtractExternalHyperlinks() && this.generalDocument.relationshipsFrom(entryName).availableWith("External");
            }
            case "application/vnd.openxmlformats-package.core-properties+xml": {
                return this.generalDocument.conditionalParameters().getTranslateDocProperties();
            }
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml": {
                return true;
            }
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml": {
                return this.generalDocument.conditionalParameters().getTranslateComments();
            }
            case "application/vnd.openxmlformats-officedocument.drawing+xml": {
                return this.generalDocument.conditionalParameters().getTranslateExcelDrawings();
            }
            case "application/vnd.openxmlformats-officedocument.drawingml.chart+xml": {
                return true;
            }
            case "application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml": {
                return this.generalDocument.conditionalParameters().getTranslateExcelDiagramData();
            }
        }
        return false;
    }

    private boolean isModifiablePart(String entryName, String contentType) {
        return "[Content_Types].xml".equals(entryName) || "application/vnd.openxmlformats-package.relationships+xml".equals(contentType) && entryName.equals(this.generalDocument.relationshipsPartPathFor(this.generalDocument.mainPartPath()).asString()) || "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml".equals(contentType) || "application/vnd.openxmlformats-officedocument.theme+xml".equals(contentType) || "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml".equals(contentType) || "application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml".equals(contentType) || "application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml".equals(contentType) || "application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheDefinition+xml".equals(contentType);
    }

    @Override
    public boolean isStyledTextPart(ZipEntry entry) {
        String type = this.generalDocument.contentTypeFor(entry);
        return "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml".equals(type) || "application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml".equals(type) || "application/vnd.openxmlformats-officedocument.drawing+xml".equals(type) || "application/vnd.openxmlformats-officedocument.drawingml.chart+xml".equals(type) || "application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml".equals(type);
    }

    private boolean isHidden(String entryName, String contentType) {
        switch (contentType) {
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml": {
                return this.isCommentHidden(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.drawing+xml": {
                return this.isDrawingHidden(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.drawingml.chart+xml": {
                return this.isChartHidden(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml": {
                return this.isDiagramDataHidden(entryName);
            }
        }
        return false;
    }

    private boolean isWorksheetHidden(String entryName) {
        return this.workbookFragments.worksheetPartNameHiddenFor(entryName);
    }

    private boolean isTableHidden(String entryName) {
        for (String worksheetName : this.tablesByWorksheet.keySet()) {
            if (!this.tablesByWorksheet.get(worksheetName).contains(entryName)) continue;
            return this.isWorksheetHidden(worksheetName);
        }
        return false;
    }

    private boolean isPivotTableHidden(String entryName) {
        for (String worksheetName : this.pivotTablesByWorksheet.keySet()) {
            if (!this.pivotTablesByWorksheet.get(worksheetName).contains(entryName)) continue;
            return this.isWorksheetHidden(worksheetName);
        }
        return false;
    }

    private boolean isPivotCacheDefinitionHidden(String entryName) {
        for (String pivotTableName : this.pivotCacheDefinitionsByPivotTable.keySet()) {
            if (!this.pivotCacheDefinitionsByPivotTable.get(pivotTableName).contains(entryName)) continue;
            return this.isPivotTableHidden(pivotTableName);
        }
        return false;
    }

    private boolean isCommentHidden(String entryName) {
        if (!this.worksheetsByComment.containsKey(entryName)) {
            return false;
        }
        return this.isWorksheetHidden(this.worksheetsByComment.get(entryName));
    }

    private boolean isDrawingHidden(String entryName) {
        if (!this.worksheetsByDrawing.containsKey(entryName)) {
            return false;
        }
        return this.isWorksheetHidden(this.worksheetsByDrawing.get(entryName));
    }

    private boolean isChartHidden(String entryName) {
        if (!this.drawingsByChart.containsKey(entryName)) {
            return false;
        }
        return this.isDrawingHidden(this.drawingsByChart.get(entryName));
    }

    private boolean isDiagramDataHidden(String entryName) {
        if (!this.drawingsByDiagramData.containsKey(entryName)) {
            return false;
        }
        return this.isDrawingHidden(this.drawingsByDiagramData.get(entryName));
    }

    @Override
    public void close() throws IOException {
    }
}

