/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum ExcelWorksheetTransUnitProperty {
    CELL_REFERENCE("cellReference"),
    SHEET_NAME("sheetName");

    private String keyName;
    private static final Pattern CELL_REFERENCE_PATTERN;

    private ExcelWorksheetTransUnitProperty(String cellReference) {
        this.keyName = cellReference;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public static String getColumnIndexFromCellRef(String cellReference) {
        Matcher matcher = CELL_REFERENCE_PATTERN.matcher(cellReference);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid Cell Reference: " + cellReference);
        }
        return matcher.group(1);
    }

    public static Integer getRowNumberFromCellRef(String cellReference) {
        Matcher matcher = CELL_REFERENCE_PATTERN.matcher(cellReference);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid Cell Reference: " + cellReference);
        }
        return Integer.parseInt(matcher.group(2));
    }

    public static int getColumnIndexFromColumnRef(String columnReference) {
        int retval = 0;
        char[] refs = columnReference.toUpperCase(Locale.ROOT).toCharArray();
        for (int k = 0; k < refs.length; ++k) {
            char thechar = refs[k];
            if (thechar == '$') {
                if (k == 0) continue;
                throw new IllegalArgumentException("Invalid Column Reference: " + columnReference);
            }
            retval = retval * 26 + (thechar - 65 + 1);
        }
        return retval - 1;
    }

    static {
        CELL_REFERENCE_PATTERN = Pattern.compile("([A-Z]+)([0-9]+)");
    }
}

