/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.openxml.Markup;

class MarkupZipSkeleton
extends ZipSkeleton {
    private final XMLOutputFactory outputFactory;
    private final Markup markup;

    MarkupZipSkeleton(ZipFile original, ZipEntry entry, XMLOutputFactory outputFactory, Markup markup) {
        super(original, entry);
        this.outputFactory = outputFactory;
        this.markup = markup;
    }

    Markup markup() {
        return this.markup;
    }

    void to(OutputStream outputStream) {
        try {
            XMLEventWriter writer = this.outputFactory.createXMLEventWriter(outputStream);
            for (XMLEvent event : this.markup.getEvents()) {
                writer.add(event);
            }
            writer.close();
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("Markup writing failed", e);
        }
    }
}

