/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.NumberingLevel;

interface NumberingDefinition {
    public String id();

    public List<XMLEvent> eventsBeforeNumberingLevels();

    public Iterator<NumberingLevel> numberingLevelsIterator();

    public List<XMLEvent> eventsAfterNumberingLevels();

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public void referencedWith(String var1);

    public boolean referenced();

    public List<XMLEvent> asEvents();

    public static final class Instance
    implements NumberingDefinition {
        static final String NAME = "num";
        private static final String NUM_ID = "numId";
        private static final String VAL = "val";
        private final StartElement startElement;
        private final Map<String, NumberingDefinition> abstractNumberingDefinitions;
        private final List<XMLEvent> abstractNumIdEvents;
        private final Map<String, NumberingLevel> numberingLevelOverrides;
        private EndElement endElement;
        private String id;
        private String abstractNumId;
        private boolean referenced;

        Instance(StartElement startElement, Map<String, NumberingDefinition> abstractNumberingDefinitions) {
            this(startElement, abstractNumberingDefinitions, new LinkedList<XMLEvent>(), new LinkedHashMap<String, NumberingLevel>());
        }

        Instance(StartElement startElement, Map<String, NumberingDefinition> abstractNumberingDefinitions, List<XMLEvent> abstractNumIdEvents, Map<String, NumberingLevel> numberingLevelOverrides) {
            this.startElement = startElement;
            this.abstractNumberingDefinitions = abstractNumberingDefinitions;
            this.abstractNumIdEvents = abstractNumIdEvents;
            this.numberingLevelOverrides = numberingLevelOverrides;
        }

        @Override
        public String id() {
            if (null == this.id) {
                this.id = this.startElement.getAttributeByName(new QName(this.startElement.getName().getNamespaceURI(), NUM_ID, this.startElement.getName().getPrefix())).getValue();
            }
            return this.id;
        }

        @Override
        public List<XMLEvent> eventsBeforeNumberingLevels() {
            LinkedList<XMLEvent> events = new LinkedList<XMLEvent>();
            events.add(this.startElement);
            events.addAll(this.abstractNumIdEvents);
            return events;
        }

        @Override
        public Iterator<NumberingLevel> numberingLevelsIterator() {
            return this.numberingLevelOverrides.values().iterator();
        }

        @Override
        public List<XMLEvent> eventsAfterNumberingLevels() {
            return Collections.singletonList(this.endElement);
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            int defaultIndex = 0;
            while (reader.hasNext()) {
                XMLEvent el;
                XMLEvent e = reader.nextEvent();
                if (e.isStartElement()) {
                    el = e.asStartElement();
                    if ("abstractNumId".equals(el.getName().getLocalPart())) {
                        this.abstractNumIdEvents.add(e);
                        this.abstractNumIdEvents.add(reader.nextTag());
                        this.abstractNumId = el.getAttributeByName(new QName(el.getName().getNamespaceURI(), VAL, el.getName().getPrefix())).getValue();
                        continue;
                    }
                    if (!"lvlOverride".equals(el.getName().getLocalPart())) continue;
                    NumberingLevel.Default nl = new NumberingLevel.Default((StartElement)el, defaultIndex);
                    nl.readWith(reader);
                    this.numberingLevelOverrides.put(nl.id(), nl);
                    ++defaultIndex;
                    continue;
                }
                if (!e.isEndElement()) continue;
                el = e.asEndElement();
                if (!this.startElement.getName().equals(el.getName())) continue;
                this.endElement = e.asEndElement();
                break;
            }
        }

        @Override
        public void referencedWith(String numberingLevelId) {
            if (this.numberingLevelOverrides.containsKey(numberingLevelId)) {
                this.referenced = true;
                NumberingLevel nl = this.numberingLevelOverrides.get(numberingLevelId);
                if (nl.numberingTextPresent()) {
                    nl.numberingText().markAsReferenced();
                } else {
                    NumberingDefinition and = this.abstractNumberingDefinitions.get(this.abstractNumId);
                    and.referencedWith(numberingLevelId);
                }
            } else {
                NumberingDefinition and = this.abstractNumberingDefinitions.get(this.abstractNumId);
                and.referencedWith(numberingLevelId);
            }
        }

        @Override
        public boolean referenced() {
            return this.referenced;
        }

        @Override
        public List<XMLEvent> asEvents() {
            LinkedList<XMLEvent> l = new LinkedList<XMLEvent>();
            l.add(this.startElement);
            l.addAll(this.abstractNumIdEvents);
            Iterator<NumberingLevel> nli = this.numberingLevelsIterator();
            while (nli.hasNext()) {
                l.addAll(nli.next().asEvents());
            }
            l.add(this.endElement);
            return l;
        }
    }

    public static final class Abstract
    implements NumberingDefinition {
        static final String NAME = "abstractNum";
        private static final String ABSTRACT_NUM_ID = "abstractNumId";
        private final StartElement startElement;
        private final List<XMLEvent> eventsBeforeNumberingLevels;
        private final Map<String, NumberingLevel> numberingLevels;
        private final List<XMLEvent> eventsAfterNumberingLevels;
        private String id;
        private boolean referenced;

        Abstract(StartElement startElement) {
            this(startElement, new LinkedList<XMLEvent>(), new LinkedHashMap<String, NumberingLevel>(), new LinkedList<XMLEvent>());
        }

        Abstract(StartElement startElement, List<XMLEvent> eventsBeforeNumberingLevels, Map<String, NumberingLevel> numberingLevels, List<XMLEvent> eventsAfterNumberingLevels) {
            this.startElement = startElement;
            this.eventsBeforeNumberingLevels = eventsBeforeNumberingLevels;
            this.numberingLevels = numberingLevels;
            this.eventsAfterNumberingLevels = eventsAfterNumberingLevels;
        }

        @Override
        public String id() {
            if (null == this.id) {
                this.id = this.startElement.getAttributeByName(new QName(this.startElement.getName().getNamespaceURI(), ABSTRACT_NUM_ID, this.startElement.getName().getPrefix())).getValue();
            }
            return this.id;
        }

        @Override
        public List<XMLEvent> eventsBeforeNumberingLevels() {
            return this.eventsBeforeNumberingLevels;
        }

        @Override
        public Iterator<NumberingLevel> numberingLevelsIterator() {
            return this.numberingLevels.values().iterator();
        }

        @Override
        public List<XMLEvent> eventsAfterNumberingLevels() {
            return this.eventsAfterNumberingLevels;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            boolean beforeNumberingLevels = true;
            this.eventsBeforeNumberingLevels.add(this.startElement);
            int defaultIndex = 0;
            while (reader.hasNext()) {
                XMLEvent el;
                XMLEvent e = reader.nextEvent();
                if (e.isStartElement()) {
                    el = e.asStartElement();
                    if ("lvl".equals(el.getName().getLocalPart())) {
                        NumberingLevel.Default nl = new NumberingLevel.Default((StartElement)el, defaultIndex);
                        nl.readWith(reader);
                        this.numberingLevels.put(nl.id(), nl);
                        ++defaultIndex;
                        beforeNumberingLevels = false;
                        continue;
                    }
                    if (beforeNumberingLevels) {
                        this.eventsBeforeNumberingLevels.add(e);
                        continue;
                    }
                    this.eventsAfterNumberingLevels.add(e);
                    continue;
                }
                if (!e.isEndElement()) continue;
                el = e.asEndElement();
                if (el.getName().equals(this.startElement.getName())) {
                    this.eventsAfterNumberingLevels.add(e);
                    break;
                }
                if (beforeNumberingLevels) {
                    this.eventsBeforeNumberingLevels.add(e);
                    continue;
                }
                this.eventsAfterNumberingLevels.add(e);
            }
        }

        @Override
        public void referencedWith(String numberingLevelId) {
            if (this.numberingLevels.containsKey(numberingLevelId)) {
                this.referenced = true;
                NumberingLevel nl = this.numberingLevels.get(numberingLevelId);
                if (nl.numberingTextPresent()) {
                    nl.numberingText().markAsReferenced();
                }
            }
        }

        @Override
        public boolean referenced() {
            return this.referenced;
        }

        @Override
        public List<XMLEvent> asEvents() {
            LinkedList<XMLEvent> events = new LinkedList<XMLEvent>();
            events.addAll(this.eventsBeforeNumberingLevels);
            Iterator<NumberingLevel> nli = this.numberingLevelsIterator();
            while (nli.hasNext()) {
                events.addAll(nli.next().asEvents());
            }
            events.addAll(this.eventsAfterNumberingLevels);
            return events;
        }
    }
}

