/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.NumberingDefinition;
import net.sf.okapi.filters.openxml.NumberingProperties;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

interface NumberingDefinitions {
    public static final String NAME = "numbering";

    public List<XMLEvent> startEvents();

    public Iterator<NumberingDefinition> abstractNumberingDefinitionsIterator();

    public Iterator<NumberingDefinition> numberingDefinitionsIterator();

    public List<XMLEvent> endEvents();

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public void markReferencedFrom(NumberingProperties var1);

    public static final class Default
    implements NumberingDefinitions {
        private static final String NUM_PIC_BULLET = "numPicBullet";
        private static final String NUM_ID_MAC_AT_CLEANUP = "numIdMacAtCleanup";
        private final List<XMLEvent> eventsBeforeNumberingDefinitions;
        private final Map<String, NumberingDefinition> abstractNumberingDefinitions;
        private final Map<String, NumberingDefinition> numberingDefinitions;
        private final List<XMLEvent> eventsAfterNumberingDefinitions;

        Default() {
            this(new LinkedList<XMLEvent>(), new LinkedHashMap<String, NumberingDefinition>(), new LinkedHashMap<String, NumberingDefinition>(), new LinkedList<XMLEvent>());
        }

        Default(List<XMLEvent> eventsBeforeNumberingDefinitions, Map<String, NumberingDefinition> abstractNumberingDefinitions, Map<String, NumberingDefinition> numberingDefinitions, List<XMLEvent> eventsAfterNumberingDefinitions) {
            this.eventsBeforeNumberingDefinitions = eventsBeforeNumberingDefinitions;
            this.abstractNumberingDefinitions = abstractNumberingDefinitions;
            this.numberingDefinitions = numberingDefinitions;
            this.eventsAfterNumberingDefinitions = eventsAfterNumberingDefinitions;
        }

        @Override
        public List<XMLEvent> startEvents() {
            return this.eventsBeforeNumberingDefinitions;
        }

        @Override
        public Iterator<NumberingDefinition> abstractNumberingDefinitionsIterator() {
            return this.abstractNumberingDefinitions.values().iterator();
        }

        @Override
        public Iterator<NumberingDefinition> numberingDefinitionsIterator() {
            return this.numberingDefinitions.values().iterator();
        }

        @Override
        public List<XMLEvent> endEvents() {
            return this.eventsAfterNumberingDefinitions;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent el;
                XMLEvent e = reader.nextEvent();
                if (e.isStartDocument()) {
                    this.eventsBeforeNumberingDefinitions.add(e);
                    continue;
                }
                if (e.isStartElement()) {
                    NumberingDefinition nd;
                    el = e.asStartElement();
                    if (NumberingDefinitions.NAME.equals(el.getName().getLocalPart())) {
                        this.eventsBeforeNumberingDefinitions.add(e);
                        continue;
                    }
                    if (NUM_PIC_BULLET.equals(el.getName().getLocalPart())) {
                        this.eventsBeforeNumberingDefinitions.addAll(XMLEventHelpers.eventsFor(e.asStartElement(), reader));
                        continue;
                    }
                    if ("abstractNum".equals(el.getName().getLocalPart())) {
                        nd = new NumberingDefinition.Abstract((StartElement)el);
                        nd.readWith(reader);
                        this.abstractNumberingDefinitions.put(nd.id(), nd);
                        continue;
                    }
                    if ("num".equals(el.getName().getLocalPart())) {
                        nd = new NumberingDefinition.Instance((StartElement)el, this.abstractNumberingDefinitions);
                        nd.readWith(reader);
                        this.numberingDefinitions.put(nd.id(), nd);
                        continue;
                    }
                    if (!NUM_ID_MAC_AT_CLEANUP.equals(el.getName().getLocalPart())) continue;
                    this.eventsAfterNumberingDefinitions.addAll(XMLEventHelpers.eventsFor(e.asStartElement(), reader));
                    continue;
                }
                if (e.isEndElement()) {
                    el = e.asEndElement();
                    if (!NumberingDefinitions.NAME.equals(el.getName().getLocalPart())) continue;
                    this.eventsAfterNumberingDefinitions.add(e);
                    continue;
                }
                if (!e.isEndDocument()) continue;
                this.eventsAfterNumberingDefinitions.add(e);
            }
        }

        @Override
        public void markReferencedFrom(NumberingProperties numberingProperties) {
            if (this.numberingDefinitions.containsKey(numberingProperties.numberingId())) {
                NumberingDefinition nd = this.numberingDefinitions.get(numberingProperties.numberingId());
                nd.referencedWith(numberingProperties.numberingLevelId());
            }
        }
    }

    public static final class Empty
    implements NumberingDefinitions {
        @Override
        public List<XMLEvent> startEvents() {
            return Collections.emptyList();
        }

        @Override
        public Iterator<NumberingDefinition> abstractNumberingDefinitionsIterator() {
            return Collections.emptyIterator();
        }

        @Override
        public Iterator<NumberingDefinition> numberingDefinitionsIterator() {
            return Collections.emptyIterator();
        }

        @Override
        public List<XMLEvent> endEvents() {
            return Collections.emptyList();
        }

        @Override
        public void readWith(XMLEventReader eventReader) throws XMLStreamException {
        }

        @Override
        public void markReferencedFrom(NumberingProperties numberingProperties) {
        }
    }
}

