/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.NumberingText;

interface NumberingLevel {
    public static final String LVL_NAME = "lvl";
    public static final String LVL_OVERRIDE_NAME = "lvlOverride";

    public String id();

    public List<XMLEvent> eventsBeforeText();

    public boolean numberingTextPresent();

    public NumberingText numberingText();

    public List<XMLEvent> eventsAfterText();

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public List<XMLEvent> asEvents();

    public static final class Default
    implements NumberingLevel {
        private static final String ILVL = "ilvl";
        private static final String LVL_TEXT = "lvlText";
        private final StartElement startElement;
        private final int defaultIndex;
        private final List<XMLEvent> eventsBeforeText;
        private final List<XMLEvent> eventsAfterText;
        private String id;
        private NumberingText numberingText;
        private boolean referenced;

        Default(StartElement startElement, int defaultIndex) {
            this(startElement, defaultIndex, new LinkedList<XMLEvent>(), new LinkedList<XMLEvent>());
        }

        Default(StartElement startElement, int defaultIndex, List<XMLEvent> eventsBeforeText, List<XMLEvent> eventsAfterText) {
            this.startElement = startElement;
            this.defaultIndex = defaultIndex;
            this.eventsBeforeText = eventsBeforeText;
            this.eventsAfterText = eventsAfterText;
        }

        @Override
        public String id() {
            if (null == this.id) {
                Attribute a = this.startElement.getAttributeByName(new QName(this.startElement.getName().getNamespaceURI(), ILVL, this.startElement.getName().getPrefix()));
                this.id = null == a ? String.valueOf(this.defaultIndex) : a.getValue();
            }
            return this.id;
        }

        @Override
        public List<XMLEvent> eventsBeforeText() {
            return this.eventsBeforeText;
        }

        @Override
        public boolean numberingTextPresent() {
            return null != this.numberingText;
        }

        @Override
        public NumberingText numberingText() {
            return this.numberingText;
        }

        @Override
        public List<XMLEvent> eventsAfterText() {
            return this.eventsAfterText;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            boolean beforeText = true;
            this.eventsBeforeText.add(this.startElement);
            while (reader.hasNext()) {
                XMLEvent el;
                XMLEvent e = reader.nextEvent();
                if (e.isStartElement()) {
                    el = e.asStartElement();
                    if (LVL_TEXT.equals(el.getName().getLocalPart())) {
                        this.numberingText = new NumberingText.Default((StartElement)el);
                        this.numberingText.readWith(reader);
                        beforeText = false;
                        continue;
                    }
                    if (beforeText) {
                        this.eventsBeforeText.add(e);
                        continue;
                    }
                    this.eventsAfterText.add(e);
                    continue;
                }
                if (!e.isEndElement()) continue;
                el = e.asEndElement();
                if (el.getName().equals(this.startElement.getName())) {
                    this.eventsAfterText.add(e);
                    break;
                }
                if (beforeText) {
                    this.eventsBeforeText.add(e);
                    continue;
                }
                this.eventsAfterText.add(e);
            }
        }

        @Override
        public List<XMLEvent> asEvents() {
            LinkedList<XMLEvent> events = new LinkedList<XMLEvent>();
            events.addAll(this.eventsBeforeText);
            if (this.numberingTextPresent()) {
                events.add(this.numberingText.startElement());
                events.add(this.numberingText.endElement());
            }
            events.addAll(this.eventsAfterText);
            return events;
        }
    }
}

