/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.QuoteMode;
import net.sf.okapi.common.encoder.XMLEncoder;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.NumberingDefinition;
import net.sf.okapi.filters.openxml.NumberingDefinitions;
import net.sf.okapi.filters.openxml.NumberingLevel;
import net.sf.okapi.filters.openxml.NumberingText;
import net.sf.okapi.filters.openxml.OpenXMLFilter;
import net.sf.okapi.filters.openxml.TranslatablePart;

final class NumberingPart
extends TranslatablePart {
    private static final Pattern levelNumberPattern = Pattern.compile("%\\d");
    private final NumberingDefinitions numberingDefinitions;
    private final IdGenerator textUnitIds;
    private final XMLEncoder attributeValueEncoder;
    private String subDocumentId;
    private Iterator<Event> filterEventsIterator;

    NumberingPart(Document.General generalDocument, ZipEntry entry, NumberingDefinitions numberingDefinitions) {
        super(generalDocument, entry);
        this.numberingDefinitions = numberingDefinitions;
        this.textUnitIds = new IdGenerator(entry.getName(), "tu");
        this.attributeValueEncoder = new XMLEncoder(OpenXMLFilter.ENCODING.name(), "\n", true, true, false, QuoteMode.ALL);
    }

    @Override
    public Event open() throws IOException, XMLStreamException {
        this.subDocumentId = this.generalDocument.nextSubDocumentId();
        this.formFilterEvents();
        this.filterEventsIterator = this.filterEvents.iterator();
        return this.createStartSubDocumentEvent(this.generalDocument.documentId(), this.subDocumentId);
    }

    private void formFilterEvents() {
        this.addToDocumentPartAndFlush(this.numberingDefinitions.startEvents());
        this.formFilterEventsFrom(this.numberingDefinitions.abstractNumberingDefinitionsIterator());
        this.formFilterEventsFrom(this.numberingDefinitions.numberingDefinitionsIterator());
        this.addToDocumentPartAndFlush(this.numberingDefinitions.endEvents());
        this.filterEvents.add(new Event(EventType.END_SUBDOCUMENT, new Ending(this.subDocumentId)));
    }

    private void formFilterEventsFrom(Iterator<NumberingDefinition> iterator) {
        while (iterator.hasNext()) {
            NumberingDefinition nd = iterator.next();
            if (nd.referenced()) {
                this.addToDocumentPartAndFlush(nd.eventsBeforeNumberingLevels());
                Iterator<NumberingLevel> nli = nd.numberingLevelsIterator();
                while (nli.hasNext()) {
                    NumberingLevel nl = nli.next();
                    if (nl.numberingTextPresent() && nl.numberingText().referenced()) {
                        this.addToDocumentPartAndFlush(nl.eventsBeforeText());
                        if (nl.numberingText().value().isEmpty()) {
                            this.addToDocumentPartAndFlush(nl.numberingText().asEvents());
                        } else {
                            ITextUnit textUnit = this.textUnitFor(nl.numberingText());
                            this.filterEvents.add(new Event(EventType.TEXT_UNIT, textUnit));
                        }
                        this.addToDocumentPartAndFlush(nl.eventsAfterText());
                        continue;
                    }
                    this.addToDocumentPartAndFlush(nl.asEvents());
                }
                this.addToDocumentPartAndFlush(nd.eventsAfterNumberingLevels());
                continue;
            }
            this.addToDocumentPartAndFlush(nd.asEvents());
        }
    }

    private void addToDocumentPartAndFlush(List<XMLEvent> events) {
        events.forEach(e -> this.addEventToDocumentPart((XMLEvent)e));
        this.flushDocumentPart();
    }

    private ITextUnit textUnitFor(NumberingText numberingText) {
        TextUnit textUnit = new TextUnit(this.textUnitIds.createId());
        textUnit.setSource(new TextContainer(this.textFragmentFor(numberingText)));
        textUnit.setMimeType("text/xml");
        GenericSkeleton skel = new GenericSkeleton();
        skel.append("<");
        skel.append(NumberingPart.stringFor(numberingText.startElement().getName()));
        Iterator<Attribute> iterator = numberingText.startElement().getAttributes();
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            skel.append(" ");
            skel.append(NumberingPart.stringFor(attribute.getName()));
            skel.append("=\"");
            if (attribute.getValue().equals(numberingText.value())) {
                skel.addContentPlaceholder(textUnit);
            } else {
                skel.append(this.stringFor(attribute.getValue()));
            }
            skel.append("\"");
        }
        skel.append("/>");
        textUnit.setSkeleton(skel);
        return textUnit;
    }

    private TextFragment textFragmentFor(NumberingText numberingText) {
        TextFragment tf = new TextFragment();
        Matcher m = levelNumberPattern.matcher(numberingText.value());
        int textStart = 0;
        while (m.find()) {
            tf.append(numberingText.value().substring(textStart, m.start()));
            tf.append(TextFragment.TagType.PLACEHOLDER, "x-level-number;", numberingText.value().substring(m.start(), m.end()));
            textStart = m.end();
        }
        if (textStart < numberingText.value().length()) {
            tf.append(numberingText.value().substring(textStart, numberingText.value().length()));
        }
        return tf;
    }

    private static String stringFor(QName name) {
        StringBuilder sb = new StringBuilder();
        if (null != name.getPrefix() && !"".equals(name.getPrefix())) {
            sb.append(name.getPrefix()).append(":");
        }
        sb.append(name.getLocalPart());
        return sb.toString();
    }

    private String stringFor(String attributeValue) {
        return this.attributeValueEncoder.encode(attributeValue, EncoderContext.INLINE);
    }

    @Override
    public boolean hasNextEvent() {
        return this.filterEventsIterator.hasNext();
    }

    @Override
    public Event nextEvent() {
        return this.filterEventsIterator.next();
    }

    @Override
    public void close() {
    }

    @Override
    public void logEvent(Event e) {
    }
}

