/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.filters.openxml.BlockProperties;
import net.sf.okapi.filters.openxml.BlockProperty;
import net.sf.okapi.filters.openxml.Color;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.CreationalParameters;
import net.sf.okapi.filters.openxml.IndexedColors;
import net.sf.okapi.filters.openxml.NumberingProperties;
import net.sf.okapi.filters.openxml.PresetColorValues;
import net.sf.okapi.filters.openxml.Property;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.SchemaDefinition;
import net.sf.okapi.filters.openxml.SkippableElement;
import net.sf.okapi.filters.openxml.StrippableAttributes;
import net.sf.okapi.filters.openxml.SystemColorValues;
import net.sf.okapi.filters.openxml.Theme;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import net.sf.okapi.filters.openxml.XMLEvents;

interface ParagraphBlockProperties
extends BlockProperties {
    public static final String PPR = "pPr";

    public boolean containsNumberingProperties();

    public NumberingProperties numberingProperties();

    public boolean containsRunPropertyDeletedParagraphMark();

    public String paragraphStyle();

    public Color.Value highlightColorValue();

    public Color.Value textColorValue();

    public void refine(QName var1, String var2, List<Property> var3) throws XMLStreamException;

    public ParagraphBlockProperties withoutParagraphStyle();

    public boolean mergeableWith(ParagraphBlockProperties var1);

    public ParagraphBlockProperties mergedWith(ParagraphBlockProperties var1);

    public static final class Word
    implements ParagraphBlockProperties {
        private static final String PARAGRAPH_STYLE = "pStyle";
        private static final String VAL = "val";
        private final BlockProperties.Default defaultBlockProperties;
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private final PresetColorValues presetColorValues;
        private final PresetColorValues highlightColorValues;
        private final SystemColorValues systemColorValues;
        private final IndexedColors indexedColors;
        private final Theme theme;
        private final StrippableAttributes strippableAttributes;

        Word(BlockProperties.Default defaultBlockProperties, ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, PresetColorValues presetColorValues, PresetColorValues highlightColorValues, SystemColorValues systemColorValues, IndexedColors indexedColors, Theme theme, StrippableAttributes strippableAttributes) {
            this.defaultBlockProperties = defaultBlockProperties;
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
            this.presetColorValues = presetColorValues;
            this.highlightColorValues = highlightColorValues;
            this.systemColorValues = systemColorValues;
            this.indexedColors = indexedColors;
            this.theme = theme;
            this.strippableAttributes = strippableAttributes;
        }

        @Override
        public List<XMLEvent> getEvents() {
            return this.defaultBlockProperties.getEvents();
        }

        @Override
        public QName getName() {
            return this.defaultBlockProperties.getName();
        }

        @Override
        public void apply(FontMappings fontMappings) {
            this.defaultBlockProperties.properties().forEach(p -> p.apply(fontMappings));
        }

        @Override
        public StartElement startElement() {
            return this.defaultBlockProperties.startElement();
        }

        @Override
        public List<Attribute> attributes() {
            return this.defaultBlockProperties.attributes();
        }

        @Override
        public List<Property> properties() {
            return this.defaultBlockProperties.properties();
        }

        @Override
        public EndElement endElement() {
            return this.defaultBlockProperties.endElement();
        }

        @Override
        public boolean isEmpty() {
            return this.defaultBlockProperties.isEmpty();
        }

        @Override
        public boolean containsNumberingProperties() {
            return this.defaultBlockProperties.properties().stream().anyMatch(p -> "numPr".equals(p.getName().getLocalPart()));
        }

        @Override
        public NumberingProperties numberingProperties() {
            return new NumberingProperties.Default(this.defaultBlockProperties.properties().stream().filter(p -> "numPr".equals(p.getName().getLocalPart())).findFirst().map(p -> p.getEvents()).orElse(Collections.emptyList()));
        }

        @Override
        public boolean containsRunPropertyDeletedParagraphMark() {
            return this.defaultBlockProperties.properties().stream().filter(bp -> "rPr".equals(bp.getName().getLocalPart())).map(rp -> rp.getEvents()).flatMap(events -> events.stream()).filter(e -> e.isStartElement()).map(e -> e.asStartElement().getName()).anyMatch(n -> SkippableElement.RevisionProperty.RUN_PROPERTY_DELETED_PARAGRAPH_MARK.toName().equals(n));
        }

        @Override
        public String paragraphStyle() {
            Property paragraphStyleProperty = this.paragraphStyleProperty();
            if (null != paragraphStyleProperty) {
                return XMLEventHelpers.getAttributeValue(paragraphStyleProperty.getEvents().get(0).asStartElement(), XMLEventHelpers.WPML_VAL);
            }
            return null;
        }

        private Property paragraphStyleProperty() {
            return this.blockProperty(PARAGRAPH_STYLE);
        }

        private Property blockProperty(String localPart) {
            QName name = new QName(this.defaultBlockProperties.getName().getNamespaceURI(), localPart);
            for (Property property : this.defaultBlockProperties.properties()) {
                if (!property.getName().equals(name)) continue;
                return property;
            }
            return null;
        }

        @Override
        public Color.Value highlightColorValue() {
            RunProperty.HighlightRunProperty highlightColorProperty = (RunProperty.HighlightRunProperty)this.blockProperty("highlight");
            if (null != highlightColorProperty) {
                return highlightColorProperty.asColorValue();
            }
            return null;
        }

        @Override
        public Color.Value textColorValue() {
            RunProperty.ColorRunProperty colorProperty = (RunProperty.ColorRunProperty)this.blockProperty("color");
            if (null != colorProperty) {
                return colorProperty.asColorValue();
            }
            return null;
        }

        @Override
        public void refine(QName innerBlockPropertyName, String styleId, List<Property> commonRunProperties) throws XMLStreamException {
            ListIterator<Property> propertiesIterator = this.defaultBlockProperties.properties().listIterator();
            while (propertiesIterator.hasNext()) {
                Property blockProperty = propertiesIterator.next();
                if (!PARAGRAPH_STYLE.equals(blockProperty.getName().getLocalPart())) continue;
                this.updateProperty(propertiesIterator, innerBlockPropertyName, styleId);
                return;
            }
            this.addProperty(propertiesIterator, innerBlockPropertyName, styleId);
        }

        private void updateProperty(ListIterator<Property> propertiesIterator, QName innerBlockPropertyName, String styleId) {
            propertiesIterator.set(this.blockProperty(innerBlockPropertyName, styleId));
        }

        private void addProperty(ListIterator<Property> propertiesIterator, QName innerBlockPropertyName, String styleId) {
            propertiesIterator.add(this.blockProperty(innerBlockPropertyName, styleId));
        }

        private BlockProperty blockProperty(QName innerBlockPropertyName, String styleId) {
            return new BlockProperty(PARAGRAPH_STYLE, Collections.singletonMap(VAL, styleId), new CreationalParameters(this.eventFactory, innerBlockPropertyName.getPrefix(), innerBlockPropertyName.getNamespaceURI()), this.conditionalParameters, this.presetColorValues, this.highlightColorValues, this.systemColorValues, this.indexedColors, this.theme, new StrippableAttributes.DrawingRunProperties(this.conditionalParameters, this.eventFactory));
        }

        @Override
        public ParagraphBlockProperties withoutParagraphStyle() {
            return new Word(new BlockProperties.Default(this.eventFactory, this.startElement(), this.endElement(), this.properties().stream().filter(p -> !PARAGRAPH_STYLE.equals(p.getName().getLocalPart())).collect(Collectors.toList())), this.conditionalParameters, this.eventFactory, this.presetColorValues, this.highlightColorValues, this.systemColorValues, this.indexedColors, this.theme, this.strippableAttributes);
        }

        @Override
        public boolean mergeableWith(ParagraphBlockProperties other) {
            HashSet<Property> otherProperties = new HashSet<Property>(other.properties());
            otherProperties.removeAll(this.properties());
            return otherProperties.isEmpty();
        }

        @Override
        public ParagraphBlockProperties mergedWith(ParagraphBlockProperties other) {
            List<Property> mergedProperties = this.properties().stream().filter(p -> !other.properties().contains(p)).collect(Collectors.toList());
            mergedProperties.addAll(other.properties());
            return new Word(new BlockProperties.Default(this.eventFactory, this.startElement(), this.endElement(), mergedProperties), this.conditionalParameters, this.eventFactory, this.presetColorValues, this.highlightColorValues, this.systemColorValues, this.indexedColors, this.theme, this.strippableAttributes);
        }
    }

    public static final class Drawing
    implements ParagraphBlockProperties {
        private static final String LOCAL_LEVEL = "lvl";
        private final BlockProperties.Default defaultBlockProperties;
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private final PresetColorValues presetColorValues;
        private final PresetColorValues highlightColorValues;
        private final SystemColorValues systemColorValues;
        private final IndexedColors indexedColors;
        private final Theme theme;
        private final StrippableAttributes strippableAttributes;
        private final SchemaDefinition.Component schemaDefinition;

        Drawing(BlockProperties.Default defaultBlockProperties, ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, PresetColorValues presetColorValues, PresetColorValues highlightColorValues, SystemColorValues systemColorValues, IndexedColors indexedColors, Theme theme, StrippableAttributes strippableAttributes, SchemaDefinition.Component schemaDefinition) {
            this.defaultBlockProperties = defaultBlockProperties;
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
            this.presetColorValues = presetColorValues;
            this.highlightColorValues = highlightColorValues;
            this.systemColorValues = systemColorValues;
            this.indexedColors = indexedColors;
            this.theme = theme;
            this.strippableAttributes = strippableAttributes;
            this.schemaDefinition = schemaDefinition;
        }

        @Override
        public List<XMLEvent> getEvents() {
            return this.defaultBlockProperties.getEvents();
        }

        @Override
        public QName getName() {
            return this.defaultBlockProperties.getName();
        }

        @Override
        public void apply(FontMappings fontMappings) {
            this.defaultBlockProperties.properties().forEach(p -> p.apply(fontMappings));
        }

        @Override
        public StartElement startElement() {
            return this.defaultBlockProperties.startElement();
        }

        @Override
        public List<Attribute> attributes() {
            return this.defaultBlockProperties.attributes();
        }

        @Override
        public List<Property> properties() {
            return this.defaultBlockProperties.properties();
        }

        @Override
        public EndElement endElement() {
            return this.defaultBlockProperties.endElement();
        }

        @Override
        public boolean isEmpty() {
            return this.defaultBlockProperties.isEmpty();
        }

        @Override
        public boolean containsNumberingProperties() {
            return false;
        }

        @Override
        public NumberingProperties numberingProperties() {
            return new NumberingProperties.Empty();
        }

        @Override
        public boolean containsRunPropertyDeletedParagraphMark() {
            return false;
        }

        @Override
        public String paragraphStyle() {
            Attribute paragraphLevelAttribute = this.paragraphLevelAttribute();
            if (null != paragraphLevelAttribute) {
                return paragraphLevelAttribute.getValue();
            }
            return null;
        }

        private Attribute paragraphLevelAttribute() {
            for (Attribute attribute : this.defaultBlockProperties.attributes()) {
                if (!LOCAL_LEVEL.equals(attribute.getName().getLocalPart())) continue;
                return attribute;
            }
            return null;
        }

        @Override
        public Color.Value highlightColorValue() {
            return null;
        }

        @Override
        public Color.Value textColorValue() {
            return null;
        }

        @Override
        public void refine(QName innerBlockPropertyName, String styleId, List<Property> commonRunProperties) throws XMLStreamException {
            ListIterator<Property> propertiesIterator = this.defaultBlockProperties.properties().listIterator();
            while (propertiesIterator.hasNext()) {
                Property blockProperty = propertiesIterator.next();
                if (!blockProperty.getName().equals(innerBlockPropertyName)) continue;
                this.updateProperty(propertiesIterator, blockProperty, commonRunProperties);
                return;
            }
            this.addProperty(propertiesIterator, innerBlockPropertyName, commonRunProperties);
        }

        private void updateProperty(ListIterator<Property> propertiesIterator, Property blockProperty, List<Property> commonRunProperties) throws XMLStreamException {
            RunProperties runProperties = blockProperty.asRunProperties();
            runProperties.refine(commonRunProperties);
            runProperties.alignWith(this.schemaDefinition);
            propertiesIterator.set(new BlockProperty(runProperties.getEvents(), this.conditionalParameters, this.eventFactory, this.presetColorValues, this.highlightColorValues, this.systemColorValues, this.indexedColors, this.theme, this.strippableAttributes));
        }

        private void addProperty(ListIterator<Property> propertiesIterator, QName innerBlockPropertyName, List<Property> commonRunProperties) {
            List<Attribute> attributes = this.asAttributes(commonRunProperties);
            List<Property> properties = this.asProperties(commonRunProperties);
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
            events.add(this.eventFactory.createStartElement(innerBlockPropertyName, attributes.iterator(), null));
            events.addAll(Drawing.asXMLEvents(properties));
            events.add(this.eventFactory.createEndElement(innerBlockPropertyName, null));
            this.rewindToSchemaDefinedPlace(propertiesIterator, innerBlockPropertyName).add(new BlockProperty(events, this.conditionalParameters, this.eventFactory, this.presetColorValues, this.highlightColorValues, this.systemColorValues, this.indexedColors, this.theme, this.strippableAttributes));
        }

        private List<Attribute> asAttributes(List<Property> commonRunProperties) {
            return commonRunProperties.stream().filter(runProperty -> runProperty instanceof RunProperty.AttributeRunProperty).map(runProperty -> this.eventFactory.createAttribute(runProperty.getName(), runProperty.value())).collect(Collectors.toList());
        }

        private List<Property> asProperties(List<Property> commonRunProperties) {
            return commonRunProperties.stream().filter(runProperty -> !(runProperty instanceof RunProperty.AttributeRunProperty)).collect(Collectors.toList());
        }

        private static List<XMLEvent> asXMLEvents(List<Property> commonRunProperties) {
            return commonRunProperties.stream().map(XMLEvents::getEvents).flatMap(Collection::stream).collect(Collectors.toList());
        }

        private ListIterator<Property> rewindToSchemaDefinedPlace(ListIterator<Property> propertiesIterator, QName innerBlockPropertyName) {
            if (!propertiesIterator.hasPrevious()) {
                return propertiesIterator;
            }
            ListIterator<SchemaDefinition.Component> iterator = this.schemaDefinition.listIteratorAfter(innerBlockPropertyName);
            if (!iterator.hasNext()) {
                return propertiesIterator;
            }
            while (iterator.hasNext()) {
                SchemaDefinition.Component component = (SchemaDefinition.Component)iterator.next();
                while (propertiesIterator.hasPrevious()) {
                    Property blockProperty = propertiesIterator.previous();
                    if (!blockProperty.getName().equals(component.name())) continue;
                    return propertiesIterator;
                }
                this.rewindToEndOfProperties(propertiesIterator);
            }
            return propertiesIterator;
        }

        private void rewindToEndOfProperties(ListIterator<Property> propertiesIterator) {
            while (propertiesIterator.hasNext()) {
                propertiesIterator.next();
            }
        }

        @Override
        public ParagraphBlockProperties withoutParagraphStyle() {
            return this;
        }

        @Override
        public boolean mergeableWith(ParagraphBlockProperties paragraphProperties) {
            HashSet<Property> otherProperties = new HashSet<Property>(paragraphProperties.properties());
            otherProperties.removeAll(this.properties());
            if (!otherProperties.isEmpty()) {
                return false;
            }
            HashSet<Attribute> otherAttributes = new HashSet<Attribute>(paragraphProperties.attributes());
            otherAttributes.removeAll(this.attributes());
            return otherAttributes.isEmpty();
        }

        @Override
        public ParagraphBlockProperties mergedWith(ParagraphBlockProperties paragraphProperties) {
            List<Property> mergedProperties = this.mergedPropertiesWith(paragraphProperties.properties());
            List<Attribute> mergedAttributes = this.mergedAttributesWith(paragraphProperties.attributes());
            return new Drawing(new BlockProperties.Default(this.eventFactory, this.eventFactory.createStartElement(this.startElement().getName(), mergedAttributes.iterator(), null), this.endElement(), mergedProperties), this.conditionalParameters, this.eventFactory, this.presetColorValues, this.highlightColorValues, this.systemColorValues, this.indexedColors, this.theme, this.strippableAttributes, this.schemaDefinition);
        }

        private List<Property> mergedPropertiesWith(List<Property> otherProperties) {
            List<Property> mergedProperties = this.properties().stream().filter(p -> otherProperties.stream().noneMatch(op -> op.getName().equals(p.getName()))).collect(Collectors.toList());
            mergedProperties.addAll(otherProperties.stream().filter(op -> this.properties().stream().noneMatch(p -> p.getName().equals(op.getName()))).collect(Collectors.toList()));
            mergedProperties.addAll(otherProperties.stream().filter(op -> this.properties().stream().anyMatch(p -> p.getName().equals(op.getName()))).collect(Collectors.toList()));
            return mergedProperties;
        }

        private List<Attribute> mergedAttributesWith(List<Attribute> otherAttributes) {
            List<Attribute> mergedAttributes = this.attributes().stream().filter(a -> otherAttributes.stream().noneMatch(oa -> oa.getName().equals(a.getName()))).collect(Collectors.toList());
            mergedAttributes.addAll(otherAttributes.stream().filter(oa -> this.attributes().stream().noneMatch(a -> a.getName().equals(oa.getName()))).collect(Collectors.toList()));
            mergedAttributes.addAll(otherAttributes.stream().filter(oa -> this.attributes().stream().anyMatch(a -> a.getName().equals(oa.getName()))).collect(Collectors.toList()));
            return mergedAttributes;
        }
    }

    public static final class Empty
    implements ParagraphBlockProperties {
        private static final String EMPTY = "";
        private final BlockProperties blockProperties;

        Empty() {
            this(new BlockProperties.Empty());
        }

        Empty(BlockProperties blockProperties) {
            this.blockProperties = blockProperties;
        }

        @Override
        public StartElement startElement() {
            return this.blockProperties.startElement();
        }

        @Override
        public List<Attribute> attributes() {
            return this.blockProperties.attributes();
        }

        @Override
        public List<Property> properties() {
            return this.blockProperties.properties();
        }

        @Override
        public EndElement endElement() {
            return this.blockProperties.endElement();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void apply(FontMappings fontMappings) {
        }

        @Override
        public QName getName() {
            return this.blockProperties.getName();
        }

        @Override
        public boolean containsNumberingProperties() {
            return false;
        }

        @Override
        public NumberingProperties numberingProperties() {
            return new NumberingProperties.Empty();
        }

        @Override
        public boolean containsRunPropertyDeletedParagraphMark() {
            return false;
        }

        @Override
        public String paragraphStyle() {
            return EMPTY;
        }

        @Override
        public Color.Value highlightColorValue() {
            return new Color.Value.Empty();
        }

        @Override
        public Color.Value textColorValue() {
            return new Color.Value.Empty();
        }

        @Override
        public void refine(QName innerBlockPropertyName, String styleId, List<Property> commonRunProperties) throws XMLStreamException {
        }

        @Override
        public ParagraphBlockProperties withoutParagraphStyle() {
            return this;
        }

        @Override
        public boolean mergeableWith(ParagraphBlockProperties other) {
            return true;
        }

        @Override
        public ParagraphBlockProperties mergedWith(ParagraphBlockProperties other) {
            return other;
        }

        @Override
        public List<XMLEvent> getEvents() {
            return this.blockProperties.getEvents();
        }
    }
}

