/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.ParametersString;
import net.sf.okapi.filters.openxml.ParametersStringWorksheetConfiguration;
import net.sf.okapi.filters.openxml.WorksheetConfiguration;
import net.sf.okapi.filters.openxml.WorksheetConfigurations;

final class ParametersStringWorksheetConfigurationsInput
implements WorksheetConfigurations.Input {
    static final String NAME = "worksheetConfigurations";
    static final String NUMBER = "number";
    private static final int DEFAULT_NUMBER_VALUE = 0;
    private static final String DEFAULT_STRING_VALUE = "";
    private final ParametersString parametersString;
    private List<WorksheetConfiguration> worksheetConfigurations;

    ParametersStringWorksheetConfigurationsInput(ParametersString parametersString) {
        this.parametersString = parametersString;
    }

    @Override
    public Iterator<WorksheetConfiguration> read() {
        if (null != this.worksheetConfigurations) {
            return Collections.emptyIterator();
        }
        this.worksheetConfigurations = new LinkedList<WorksheetConfiguration>();
        ParametersString ps = new ParametersString(this.parametersString.getGroup(NAME, DEFAULT_STRING_VALUE));
        int numberOfConfigurations = ps.getInteger(NUMBER, 0);
        for (int i = 0; i < numberOfConfigurations; ++i) {
            String configurationString = ps.getGroup(String.valueOf(i), DEFAULT_STRING_VALUE);
            if (DEFAULT_STRING_VALUE.equals(configurationString)) continue;
            this.worksheetConfigurations.add(new ParametersStringWorksheetConfiguration(new ParametersString(configurationString)));
        }
        return this.worksheetConfigurations.iterator();
    }
}

