/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.CellReferencesRange;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

interface PivotCacheDefinition {
    public static final String WORKSHEET_SOURCE = "worksheetSource";
    public static final String CACHE_FIELD = "cacheField";

    public String sheetNameSource();

    public CellReferencesRange cellReferencesRangeSource();

    public Set<String> cacheFieldNames();

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public Markup asMarkup();

    public static final class Default
    implements PivotCacheDefinition {
        private static final String EMPTY = "";
        private static final QName NAME = new QName("name");
        private static final QName SHEET = new QName("sheet");
        private static final QName REF = new QName("ref");
        private static final String CACHE_SOURCE = "cacheSource";
        private static final QName TYPE = new QName("type");
        private static final String WORKSHEET = "worksheet";
        private final XMLEventFactory eventFactory;
        private final Set<String> cacheFieldNames;
        private MarkupBuilder markupBuilder;
        private String cacheSourceType;
        private String namedSource;
        private String sheetNameSource;
        private CellReferencesRange cellReferencesRangeSource;

        Default(XMLEventFactory eventFactory) {
            this(eventFactory, new HashSet<String>());
        }

        Default(XMLEventFactory eventFactory, Set<String> cacheFieldNames) {
            this.eventFactory = eventFactory;
            this.cacheFieldNames = cacheFieldNames;
        }

        @Override
        public String sheetNameSource() {
            return this.sheetNameSource;
        }

        @Override
        public CellReferencesRange cellReferencesRangeSource() {
            return this.cellReferencesRangeSource;
        }

        @Override
        public Set<String> cacheFieldNames() {
            return this.cacheFieldNames;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            this.namedSource = EMPTY;
            this.sheetNameSource = EMPTY;
            this.cellReferencesRangeSource = new CellReferencesRange(EMPTY);
            boolean cacheSourceDefined = false;
            this.markupBuilder = new MarkupBuilder(new Markup.General(new ArrayList<MarkupComponent>()));
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (e.isStartElement()) {
                    StartElement se = e.asStartElement();
                    if (CACHE_SOURCE.equals(se.getName().getLocalPart())) {
                        this.cacheSourceType = XMLEventHelpers.getAttributeValue(se, TYPE);
                    } else if (WORKSHEET.equals(this.cacheSourceType) && PivotCacheDefinition.WORKSHEET_SOURCE.equals(se.getName().getLocalPart())) {
                        this.defineCacheSource(se);
                        cacheSourceDefined = true;
                        if (!this.sheetNameSource.isEmpty()) {
                            this.markupBuilder.add(new MarkupComponent.Start(this.eventFactory, se, new MarkupComponent.Context.Default(EMPTY)));
                            continue;
                        }
                    } else if (cacheSourceDefined && PivotCacheDefinition.CACHE_FIELD.equals(se.getName().getLocalPart())) {
                        this.cacheFieldNames.add(XMLEventHelpers.getAttributeValue(se, NAME));
                        this.markupBuilder.add(new MarkupComponent.Start(this.eventFactory, se, new MarkupComponent.Context.Default(this.cacheSource())));
                        continue;
                    }
                } else if (e.isEndElement()) {
                    EndElement ee = e.asEndElement();
                    if (!this.sheetNameSource.isEmpty() && PivotCacheDefinition.WORKSHEET_SOURCE.equals(ee.getName().getLocalPart())) {
                        this.markupBuilder.add(new MarkupComponent.End(ee));
                        continue;
                    }
                    if (cacheSourceDefined && PivotCacheDefinition.CACHE_FIELD.equals(ee.getName().getLocalPart())) {
                        this.markupBuilder.add(new MarkupComponent.End(ee));
                        continue;
                    }
                }
                this.markupBuilder.add(e);
            }
        }

        private void defineCacheSource(StartElement se) {
            this.namedSource = XMLEventHelpers.getAttributeValue(se, NAME, EMPTY);
            this.sheetNameSource = XMLEventHelpers.getAttributeValue(se, SHEET, EMPTY);
            this.cellReferencesRangeSource = new CellReferencesRange(XMLEventHelpers.getAttributeValue(se, REF, EMPTY));
        }

        private String cacheSource() {
            String name = !this.namedSource.isEmpty() ? this.namedSource : (!this.sheetNameSource.isEmpty() ? this.sheetNameSource : EMPTY);
            return name;
        }

        @Override
        public Markup asMarkup() {
            return this.markupBuilder.build();
        }
    }
}

