/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.filters.openxml.ContentCategoriesDetection;
import net.sf.okapi.filters.openxml.ContentFilter;
import net.sf.okapi.filters.openxml.DefaultPart;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.IndexedColors;
import net.sf.okapi.filters.openxml.ModifiablePart;
import net.sf.okapi.filters.openxml.Namespace;
import net.sf.okapi.filters.openxml.NonModifiablePart;
import net.sf.okapi.filters.openxml.NotesMasterFragments;
import net.sf.okapi.filters.openxml.NumberingDefinitions;
import net.sf.okapi.filters.openxml.ParseType;
import net.sf.okapi.filters.openxml.Part;
import net.sf.okapi.filters.openxml.PresentationFragments;
import net.sf.okapi.filters.openxml.PresetColorValues;
import net.sf.okapi.filters.openxml.Relationship;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.RelationshipsPart;
import net.sf.okapi.filters.openxml.SlidablePart;
import net.sf.okapi.filters.openxml.SlideFragments;
import net.sf.okapi.filters.openxml.SlideMasterFragments;
import net.sf.okapi.filters.openxml.SlideTemplateFragments;
import net.sf.okapi.filters.openxml.StringsComparator;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleOptimisation;
import net.sf.okapi.filters.openxml.StyledTextPart;
import net.sf.okapi.filters.openxml.SystemColorValues;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import net.sf.okapi.filters.openxml.ZipEntryComparator;

class PowerpointDocument
implements Document {
    private static final String METADATA = "/metadata";
    private static final String CORE_PROPERTIES = "/core-properties";
    private static final String SLIDE_MASTER = "/slideMaster";
    private static final String SLIDE_LAYOUT = "/slideLayout";
    private static final String COMMENTS = "/comments";
    private static final String NOTES_SLIDE = "/notesSlide";
    private static final String NOTES_MASTER = "/notesMaster";
    private static final String DIAGRAM_DATA = "/diagramData";
    private static final String CHART = "/chart";
    private static final String EMPTY = "";
    private static final String SLD = "sld";
    private static final QName SHOW = new QName("show");
    private final Document.General generalDocument;
    private PresetColorValues highlightColorValues;
    private SystemColorValues systemColorValues;
    private PresentationFragments presentationFragments;
    private Enumeration<? extends ZipEntry> entries;
    private Set<String> hiddenSlides;
    private Set<String> slideLayoutNames;
    private Set<String> notesSlideNames;
    private Map<String, SlideFragments> slideMasterFragmentsByName;
    private Map<String, SlideFragments> slideLayoutFragmentsByName;
    private Map<String, SlideFragments> slideFragmentsByName;
    private Map<String, SlideFragments> notesMasterFragmentsByName;
    private Map<String, SlideFragments> notesSlideFragmentsByName;
    private Map<String, Set<String>> slideLayoutsBySlide;
    private Map<String, Set<String>> slideMastersBySlideLayout;
    private Map<String, String> slidesByComment;
    private Map<String, String> slidesByNotesSlide;
    private Map<String, Set<String>> notesMastersByNotesSlide;
    private Map<String, String> slideMastersByDiagramData;
    private Map<String, String> slideLayoutsByDiagramData;
    private Map<String, String> slidesByDiagramData;
    private Map<String, String> slideMastersByChart;
    private Map<String, String> slideLayoutsByChart;
    private Map<String, String> slidesByChart;

    PowerpointDocument(Document.General generalDocument) {
        this.generalDocument = generalDocument;
    }

    @Override
    public Event open() throws IOException, XMLStreamException {
        this.highlightColorValues = new PresetColorValues.Default(Collections.emptyList());
        this.systemColorValues = new SystemColorValues.Default(Collections.emptyList());
        this.presentationFragments = this.presentationFragments();
        this.hiddenSlides = this.hiddenSlides();
        this.slideLayoutNames = this.slideRelatedPartNamesOf(SLIDE_LAYOUT);
        this.notesSlideNames = this.slideRelatedPartNamesOf(NOTES_SLIDE);
        this.slideMasterFragmentsByName = this.slideMasterFragments();
        this.slideLayoutFragmentsByName = this.slideLayoutFragments();
        this.slideFragmentsByName = this.slideFragments();
        this.notesMasterFragmentsByName = this.notesMasterFragments();
        this.notesSlideFragmentsByName = this.notesSlideFragments();
        this.slideLayoutsBySlide = this.slideLayoutsBySlide();
        this.slideMastersBySlideLayout = this.slideMastersBySlideLayout();
        this.slidesByComment = this.slidesBy(COMMENTS);
        this.slidesByNotesSlide = this.slidesBy(NOTES_SLIDE);
        this.notesMastersByNotesSlide = this.notesMastersByNotesSlide();
        this.slideMastersByDiagramData = this.slideMastersBy(DIAGRAM_DATA);
        this.slideLayoutsByDiagramData = this.slideLayoutsBy(DIAGRAM_DATA);
        this.slidesByDiagramData = this.slidesBy(DIAGRAM_DATA);
        this.slideMastersByChart = this.slideMastersBy(CHART);
        this.slideLayoutsByChart = this.slideLayoutsBy(CHART);
        this.slidesByChart = this.slidesBy(CHART);
        this.entries = this.entries();
        return this.generalDocument.startDocumentEvent();
    }

    private PresentationFragments presentationFragments() throws IOException, XMLStreamException {
        PresentationFragments.Default pf = new PresentationFragments.Default(this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), this.generalDocument.presetColorValues(), this.highlightColorValues, this.systemColorValues, new IndexedColors.Default(this.systemColorValues), this.generalDocument.mainPartTheme(), this.generalDocument.mainPartRelationships());
        try (Reader reader = this.generalDocument.getPartReader(this.generalDocument.mainPartPath());){
            pf.readWith(this.generalDocument.inputFactory().createXMLEventReader(reader));
        }
        return pf;
    }

    private Set<String> hiddenSlides() throws IOException, XMLStreamException {
        HashSet<String> hiddenSlides = new HashSet<String>(this.presentationFragments.slideNames().size());
        for (String name : this.presentationFragments.slideNames()) {
            Reader reader = this.generalDocument.getPartReader(name);
            try {
                XMLEventReader eventReader = this.generalDocument.inputFactory().createXMLEventReader(reader);
                XMLEvent e = eventReader.nextTag();
                if (!e.isStartElement() || !SLD.equals(e.asStartElement().getName().getLocalPart()) || XMLEventHelpers.getBooleanAttributeValue(e.asStartElement(), SHOW, XMLEventHelpers.DEFAULT_BOOLEAN_ATTRIBUTE_TRUE_VALUE)) continue;
                hiddenSlides.add(name);
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
        return hiddenSlides;
    }

    private Set<String> slideRelatedPartNamesOf(String type) throws IOException, XMLStreamException {
        HashSet<String> names = new HashSet<String>();
        String typeUri = this.generalDocument.mainPartRelationshipsNamespace().uri().concat(type);
        for (String slideName : this.presentationFragments.slideNames()) {
            names.addAll(this.generalDocument.relationshipTargetsFor(slideName, typeUri));
        }
        return names;
    }

    private Map<String, SlideFragments> slideMasterFragments() throws IOException, XMLStreamException {
        HashMap<String, SlideFragments> slideMasterFragments = new HashMap<String, SlideFragments>(this.presentationFragments.slideMasterNames().size());
        for (String name : this.presentationFragments.slideMasterNames()) {
            slideMasterFragments.put(name, this.slideMasterFragmentsOf(name));
        }
        return slideMasterFragments;
    }

    private SlideFragments slideMasterFragmentsOf(String partName) throws IOException, XMLStreamException {
        try (Reader reader = this.generalDocument.getPartReader(partName);){
            XMLEventReader eventReader = this.generalDocument.inputFactory().createXMLEventReader(reader);
            while (eventReader.hasNext()) {
                XMLEvent e = eventReader.nextEvent();
                if (e.isEndElement() && SlideMasterFragments.SLD_MASTER.equals(e.asEndElement().getName().getLocalPart())) {
                    break;
                }
                if (!e.isStartElement()) continue;
                if (!SlideMasterFragments.SLD_MASTER.equals(e.asStartElement().getName().getLocalPart())) continue;
                SlideMasterFragments slideTemplateFragments = new SlideMasterFragments(e.asStartElement(), this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), this.generalDocument.presetColorValues(), this.highlightColorValues, this.systemColorValues, this.indexedColors(), this.generalDocument.mainPartTheme());
                slideTemplateFragments.readWith(eventReader);
                SlideMasterFragments slideMasterFragments = slideTemplateFragments;
                return slideMasterFragments;
            }
        }
        return new SlideTemplateFragments.Empty();
    }

    private Map<String, SlideFragments> slideLayoutFragments() throws IOException, XMLStreamException {
        HashMap<String, SlideFragments> slideLayoutFragments = new HashMap<String, SlideFragments>(this.slideLayoutNames.size());
        for (String name : this.slideLayoutNames) {
            slideLayoutFragments.put(name, this.slideLayoutFragmentsOf(name));
        }
        return slideLayoutFragments;
    }

    private SlideFragments slideLayoutFragmentsOf(String partName) throws IOException, XMLStreamException {
        Iterator<Relationship> ri = this.generalDocument.relationshipsFor(partName).of(this.generalDocument.mainPartRelationshipsNamespace().uri().concat(SLIDE_MASTER)).iterator();
        String name = ri.hasNext() ? ri.next().target() : EMPTY;
        SlideTemplateFragments.Empty slideMasterFragments = this.slideMasterFragmentsByName.containsKey(name) ? this.slideMasterFragmentsByName.get(name) : new SlideTemplateFragments.Empty();
        return this.slideFragments(partName, slideMasterFragments);
    }

    private SlideFragments slideFragments(String partName, SlideFragments templateFragments) throws IOException, XMLStreamException {
        try (Reader reader = this.generalDocument.getPartReader(partName);){
            XMLEventReader eventReader = this.generalDocument.inputFactory().createXMLEventReader(reader);
            while (eventReader.hasNext()) {
                XMLEvent e = eventReader.nextEvent();
                if (e.isEndElement() && "cSld".equals(e.asEndElement().getName().getLocalPart())) {
                    break;
                }
                if (!e.isStartElement()) continue;
                if (!"cSld".equals(e.asStartElement().getName().getLocalPart())) continue;
                SlideFragments.Default slideFragments = new SlideFragments.Default(e.asStartElement(), this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), this.generalDocument.presetColorValues(), this.highlightColorValues, this.systemColorValues, this.indexedColors(), this.generalDocument.mainPartTheme(), templateFragments);
                slideFragments.readWith(eventReader);
                SlideFragments.Default default_ = slideFragments;
                return default_;
            }
        }
        return new SlideFragments.Empty(templateFragments);
    }

    private Map<String, SlideFragments> slideFragments() throws IOException, XMLStreamException {
        HashMap<String, SlideFragments> slideFragments = new HashMap<String, SlideFragments>(this.presentationFragments.slideNames().size());
        for (String name : this.presentationFragments.slideNames()) {
            slideFragments.put(name, this.slideFragmentsOf(name));
        }
        return slideFragments;
    }

    private SlideFragments slideFragmentsOf(String partName) throws IOException, XMLStreamException {
        Iterator<Relationship> ri = this.generalDocument.relationshipsFor(partName).of(this.generalDocument.mainPartRelationshipsNamespace().uri().concat(SLIDE_LAYOUT)).iterator();
        String name = ri.hasNext() ? ri.next().target() : EMPTY;
        SlideFragments slideLayoutFragments = this.slideLayoutFragmentsByName.containsKey(name) ? this.slideLayoutFragmentsByName.get(name) : new SlideFragments.Empty(new SlideTemplateFragments.Empty());
        return this.slideFragments(partName, slideLayoutFragments);
    }

    private Map<String, SlideFragments> notesMasterFragments() throws IOException, XMLStreamException {
        HashMap<String, SlideFragments> notesMasterFragments = new HashMap<String, SlideFragments>(this.presentationFragments.notesMasterNames().size());
        for (String name : this.presentationFragments.notesMasterNames()) {
            notesMasterFragments.put(name, this.notesMasterFragmentsOf(name));
        }
        return notesMasterFragments;
    }

    private SlideFragments notesMasterFragmentsOf(String partName) throws IOException, XMLStreamException {
        try (Reader reader = this.generalDocument.getPartReader(partName);){
            XMLEventReader eventReader = this.generalDocument.inputFactory().createXMLEventReader(reader);
            while (eventReader.hasNext()) {
                XMLEvent e = eventReader.nextEvent();
                if (e.isEndElement() && NotesMasterFragments.NOTES_MASTER.equals(e.asEndElement().getName().getLocalPart())) {
                    break;
                }
                if (!e.isStartElement()) continue;
                if (!NotesMasterFragments.NOTES_MASTER.equals(e.asStartElement().getName().getLocalPart())) continue;
                NotesMasterFragments notesMasterFragments = new NotesMasterFragments(e.asStartElement(), this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), this.generalDocument.presetColorValues(), this.highlightColorValues, this.systemColorValues, this.indexedColors(), this.generalDocument.mainPartTheme());
                notesMasterFragments.readWith(eventReader);
                NotesMasterFragments notesMasterFragments2 = notesMasterFragments;
                return notesMasterFragments2;
            }
        }
        return new SlideTemplateFragments.Empty();
    }

    private Map<String, SlideFragments> notesSlideFragments() throws IOException, XMLStreamException {
        HashMap<String, SlideFragments> slideFragments = new HashMap<String, SlideFragments>(this.notesSlideNames.size());
        for (String name : this.notesSlideNames) {
            slideFragments.put(name, this.notesSlideFragmentsOf(name));
        }
        return slideFragments;
    }

    private SlideFragments notesSlideFragmentsOf(String partName) throws IOException, XMLStreamException {
        Iterator<Relationship> ri = this.generalDocument.relationshipsFor(partName).of(this.generalDocument.mainPartRelationshipsNamespace().uri().concat(NOTES_MASTER)).iterator();
        String name = ri.hasNext() ? ri.next().target() : EMPTY;
        SlideTemplateFragments.Empty notesMasterFragments = this.notesMasterFragmentsByName.containsKey(name) ? this.notesMasterFragmentsByName.get(name) : new SlideTemplateFragments.Empty();
        return this.slideFragments(partName, notesMasterFragments);
    }

    private Map<String, Set<String>> slideLayoutsBySlide() throws IOException, XMLStreamException {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        String uri = this.generalDocument.mainPartRelationshipsNamespace().uri().concat(SLIDE_LAYOUT);
        for (String name : this.presentationFragments.slideNames()) {
            map.put(name, this.generalDocument.relationshipTargetsFor(name, uri));
        }
        return map;
    }

    private Map<String, Set<String>> slideMastersBySlideLayout() throws IOException, XMLStreamException {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        String uri = this.generalDocument.mainPartRelationshipsNamespace().uri().concat(SLIDE_MASTER);
        for (String name : this.slideLayoutNames) {
            map.put(name, this.generalDocument.relationshipTargetsFor(name, uri));
        }
        return map;
    }

    private Map<String, Set<String>> notesMastersByNotesSlide() throws IOException, XMLStreamException {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        String uri = this.generalDocument.mainPartRelationshipsNamespace().uri().concat(NOTES_MASTER);
        for (String name : this.notesSlideNames) {
            map.put(name, this.generalDocument.relationshipTargetsFor(name, uri));
        }
        return map;
    }

    private Map<String, String> slideMastersBy(String relatedPart) throws IOException, XMLStreamException {
        String namespaceUri = this.generalDocument.mainPartRelationshipsNamespace().uri();
        return this.generalDocument.partsByRelatedPart(this.presentationFragments.slideMasterNames(), namespaceUri.concat(relatedPart));
    }

    private Map<String, String> slideLayoutsBy(String relatedPart) throws IOException, XMLStreamException {
        String namespaceUri = this.generalDocument.mainPartRelationshipsNamespace().uri();
        return this.generalDocument.partsByRelatedPart(new ArrayList<String>(this.slideLayoutNames), namespaceUri.concat(relatedPart));
    }

    private Map<String, String> slidesBy(String relatedPart) throws IOException, XMLStreamException {
        String namespaceUri = this.generalDocument.mainPartRelationshipsNamespace().uri();
        return this.generalDocument.partsByRelatedPart(this.presentationFragments.slideNames(), namespaceUri.concat(relatedPart));
    }

    private Enumeration<? extends ZipEntry> entries() throws IOException, XMLStreamException {
        Enumeration<? extends ZipEntry> entries = this.generalDocument.entries();
        ArrayList<? extends ZipEntry> entryList = Collections.list(entries);
        entryList.sort(new ZipEntryComparator(this.reorderedPartNames()));
        return Collections.enumeration(entryList);
    }

    private List<String> reorderedPartNames() throws IOException, XMLStreamException {
        LinkedList<String> names = new LinkedList<String>();
        if (this.generalDocument.conditionalParameters().getReorderPowerpointDocProperties()) {
            String namespaceUri = this.generalDocument.rootRelationships().startElement().getName().getNamespaceURI();
            Relationships relationships = this.generalDocument.rootRelationships().of(namespaceUri.concat(METADATA).concat(CORE_PROPERTIES));
            names.addAll(this.generalDocument.targetsOf(relationships));
        }
        String namespace = this.generalDocument.mainPartRelationshipsNamespace().uri();
        names.addAll(this.mastersAndRelatedPartsWith(namespace));
        names.addAll(this.slidesAndRelatedPartsWith(namespace));
        return names;
    }

    private List<String> mastersAndRelatedPartsWith(String namespace) throws IOException, XMLStreamException {
        LinkedList<String> names = new LinkedList<String>();
        for (String slideMasterName : this.presentationFragments.slideMasterNames()) {
            names.add(slideMasterName);
            if (this.generalDocument.conditionalParameters().getReorderPowerpointRelationships()) {
                names.add(this.generalDocument.relationshipsPartPathFor(slideMasterName).asString());
            }
            names.addAll(this.diagramDataAndChartsFor(slideMasterName, namespace));
            ArrayList<String> slideLayoutNames = new ArrayList<String>(this.generalDocument.relationshipTargetsFor(slideMasterName, namespace.concat(SLIDE_LAYOUT)));
            slideLayoutNames.sort(new StringsComparator());
            for (String slideLayoutName : slideLayoutNames) {
                names.add(slideLayoutName);
                if (this.generalDocument.conditionalParameters().getReorderPowerpointRelationships()) {
                    names.add(this.generalDocument.relationshipsPartPathFor(slideLayoutName).asString());
                }
                names.addAll(this.diagramDataAndChartsFor(slideLayoutName, namespace));
            }
        }
        for (String notesMasterName : this.presentationFragments.notesMasterNames()) {
            names.add(notesMasterName);
            if (!this.generalDocument.conditionalParameters().getReorderPowerpointRelationships()) continue;
            names.add(this.generalDocument.relationshipsPartPathFor(notesMasterName).asString());
        }
        return names;
    }

    private List<String> slidesAndRelatedPartsWith(String namespace) throws IOException, XMLStreamException {
        LinkedList<String> names = new LinkedList<String>();
        for (String slideName : this.presentationFragments.slideNames()) {
            names.add(slideName);
            if (this.generalDocument.conditionalParameters().getReorderPowerpointRelationships()) {
                names.add(this.generalDocument.relationshipsPartPathFor(slideName).asString());
            }
            names.addAll(this.diagramDataAndChartsFor(slideName, namespace));
            if (this.generalDocument.conditionalParameters().getReorderPowerpointNotes() || this.generalDocument.conditionalParameters().getReorderPowerpointNotesAndComments()) {
                names.addAll(this.generalDocument.relationshipTargetsFor(slideName, namespace.concat(NOTES_SLIDE)));
            }
            if (!this.generalDocument.conditionalParameters().getReorderPowerpointComments() && !this.generalDocument.conditionalParameters().getReorderPowerpointNotesAndComments()) continue;
            names.addAll(this.generalDocument.relationshipTargetsFor(slideName, namespace.concat(COMMENTS)));
        }
        return names;
    }

    private List<String> diagramDataAndChartsFor(String relatedName, String namespace) throws IOException, XMLStreamException {
        LinkedList<String> names = new LinkedList<String>();
        if (this.generalDocument.conditionalParameters().getReorderPowerpointDiagramData()) {
            names.addAll(this.generalDocument.relationshipTargetsFor(relatedName, namespace.concat(DIAGRAM_DATA)));
        }
        if (this.generalDocument.conditionalParameters().getReorderPowerpointCharts()) {
            names.addAll(this.generalDocument.relationshipTargetsFor(relatedName, namespace.concat(CHART)));
        }
        return names;
    }

    @Override
    public PresetColorValues highlightColorValues() {
        return this.highlightColorValues;
    }

    @Override
    public SystemColorValues systemColorValues() {
        return this.systemColorValues;
    }

    @Override
    public IndexedColors indexedColors() {
        return this.presentationFragments.defaultTextStyle().indexedColors();
    }

    @Override
    public boolean hasNextPart() {
        return this.entries.hasMoreElements();
    }

    @Override
    public Part nextPart() throws IOException, XMLStreamException {
        ParseType parseType;
        String contentType;
        ZipEntry entry = this.entries.nextElement();
        String entryName = entry.getName();
        if (!this.isTranslatablePart(entryName, contentType = this.generalDocument.contentTypeFor(entry))) {
            if (this.isModifiablePart(entryName, contentType)) {
                return new ModifiablePart(this.generalDocument, entry, this.generalDocument.inputStreamFor(entry));
            }
            return new NonModifiablePart(this.generalDocument, entry);
        }
        if (this.isStyledTextPart(entry)) {
            if (this.isSlidablePart(entry.getName(), contentType)) {
                return new SlidablePart(this.generalDocument, entry, this.slideFragmentsFor(entry.getName(), contentType));
            }
            StyleDefinitions styleDefinitions = this.styleDefinitionsFor(entry);
            StyleOptimisation styleOptimisation = this.styleOptimisationFor(entry, styleDefinitions);
            return new StyledTextPart(this.generalDocument, entry, styleDefinitions, styleOptimisation, new NumberingDefinitions.Empty(), new ContentCategoriesDetection.NonApplicable());
        }
        if ("application/vnd.openxmlformats-package.relationships+xml".equals(contentType)) {
            return new RelationshipsPart(this.generalDocument, entry, this.generalDocument.relationshipsFrom(entry.getName()));
        }
        ContentFilter contentFilter = new ContentFilter(this.generalDocument.conditionalParameters(), entry.getName());
        this.generalDocument.conditionalParameters().nFileType = parseType = this.getParseType(contentType);
        contentFilter.setUpConfig(parseType);
        return new DefaultPart(this.generalDocument, entry, contentFilter);
    }

    @Override
    public StyleDefinitions styleDefinitionsFor(ZipEntry entry) {
        return new StyleDefinitions.Empty();
    }

    private StyleOptimisation styleOptimisationFor(ZipEntry entry, StyleDefinitions styleDefinitions) throws IOException, XMLStreamException {
        Iterator<Namespace> iterator = this.generalDocument.namespacesOf(entry).with("a").iterator();
        if (iterator.hasNext()) {
            Namespace namespace = iterator.next();
            return new StyleOptimisation.Default(new StyleOptimisation.Bypass(), this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), this.generalDocument.presetColorValues(), this.highlightColorValues, this.generalDocument.systemColorValues(), this.indexedColors(), this.generalDocument.mainPartTheme(), new QName(namespace.uri(), "pPr", namespace.prefix()), new QName(namespace.uri(), "defRPr", namespace.prefix()), Collections.emptyList(), styleDefinitions);
        }
        return new StyleOptimisation.Bypass();
    }

    private ParseType getParseType(String contentType) {
        ParseType parseType;
        if (contentType.equals("application/vnd.openxmlformats-package.core-properties+xml")) {
            parseType = ParseType.MSWORDDOCPROPERTIES;
        } else if (contentType.equals("application/vnd.openxmlformats-officedocument.presentationml.comments+xml")) {
            parseType = ParseType.MSPOWERPOINTCOMMENTS;
        } else {
            throw new IllegalStateException("Unexpected content type " + contentType);
        }
        return parseType;
    }

    private boolean isTranslatablePart(String entryName, String contentType) throws XMLStreamException, IOException {
        if (!entryName.endsWith(".xml") && !entryName.endsWith(".rels")) {
            return false;
        }
        if (this.isExcluded(entryName, contentType)) {
            return false;
        }
        if (this.isHidden(entryName, contentType)) {
            return false;
        }
        switch (contentType) {
            case "application/vnd.openxmlformats-package.core-properties+xml": {
                return this.generalDocument.conditionalParameters().getTranslatePowerpointDocProperties() && this.generalDocument.conditionalParameters().getTranslateDocProperties();
            }
            case "application/vnd.openxmlformats-package.relationships+xml": {
                return this.relationshipsTranslatable(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml": {
                return this.diagramDataTranslatable(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.drawingml.chart+xml": {
                return this.chartTranslatable(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.presentationml.comments+xml": {
                return this.generalDocument.conditionalParameters().getTranslatePowerpointComments() && this.generalDocument.conditionalParameters().getTranslateComments();
            }
        }
        return this.isStyledTextPart(entryName, contentType);
    }

    private boolean relationshipsTranslatable(String entryName) throws IOException, XMLStreamException {
        boolean translatable;
        if (this.generalDocument.conditionalParameters().getExtractExternalHyperlinks() && this.generalDocument.relationshipsFrom(entryName).availableWith("External")) {
            String mainPart = this.generalDocument.mainPartPathFor(entryName).asString();
            String contentType = this.generalDocument.contentTypes().with(mainPart).iterator().next().value();
            translatable = this.isTranslatablePart(mainPart, contentType);
        } else {
            translatable = false;
        }
        return translatable;
    }

    private boolean diagramDataTranslatable(String entryName) throws XMLStreamException, IOException {
        if (this.generalDocument.conditionalParameters().getTranslatePowerpointDiagramData()) {
            if (this.generalDocument.conditionalParameters().getTranslatePowerpointMasters()) {
                if (this.slideMastersByDiagramData.containsKey(entryName)) {
                    return this.isTranslatablePart(this.slideMastersByDiagramData.get(entryName), "application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml");
                }
                if (this.slideLayoutsByDiagramData.containsKey(entryName)) {
                    return this.isTranslatablePart(this.slideLayoutsByDiagramData.get(entryName), "application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml");
                }
            }
            if (!this.slidesByDiagramData.containsKey(entryName)) {
                return false;
            }
            return this.isTranslatablePart(this.slidesByDiagramData.get(entryName), "application/vnd.openxmlformats-officedocument.presentationml.slide+xml");
        }
        return false;
    }

    private boolean chartTranslatable(String entryName) throws XMLStreamException, IOException {
        if (this.generalDocument.conditionalParameters().getTranslatePowerpointCharts()) {
            if (this.generalDocument.conditionalParameters().getTranslatePowerpointMasters()) {
                if (this.slideMastersByChart.containsKey(entryName)) {
                    return this.isTranslatablePart(this.slideMastersByChart.get(entryName), "application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml");
                }
                if (this.slideLayoutsByChart.containsKey(entryName)) {
                    return this.isTranslatablePart(this.slideLayoutsByChart.get(entryName), "application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml");
                }
            }
            if (!this.slidesByChart.containsKey(entryName)) {
                return false;
            }
            return this.isTranslatablePart(this.slidesByChart.get(entryName), "application/vnd.openxmlformats-officedocument.presentationml.slide+xml");
        }
        return false;
    }

    private boolean isModifiablePart(String entryName, String contentType) {
        return "application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml".equals(contentType) || "application/vnd.openxmlformats-officedocument.theme+xml".equals(contentType) || "application/vnd.openxmlformats-officedocument.themeOverride+xml".equals(contentType) || this.isHidden(entryName, contentType);
    }

    @Override
    public boolean isStyledTextPart(ZipEntry entry) {
        return this.isStyledTextPart(entry.getName(), this.generalDocument.contentTypeFor(entry));
    }

    private boolean isStyledTextPart(String entryName, String contentType) {
        if (contentType.equals("application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml")) {
            return true;
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.drawingml.chart+xml")) {
            return true;
        }
        return this.isSlidablePart(entryName, contentType);
    }

    private boolean isSlidablePart(String entryName, String contentType) {
        return null != this.slideFragmentsFor(entryName, contentType);
    }

    private SlideFragments slideFragmentsFor(String entryName, String contentType) {
        if (this.generalDocument.conditionalParameters().getTranslatePowerpointMasters()) {
            if ("application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml".equals(contentType) && this.slideMasterFragmentsByName.containsKey(entryName)) {
                return this.slideMasterFragmentsByName.get(entryName);
            }
            if ("application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml".equals(contentType) && this.slideLayoutFragmentsByName.containsKey(entryName)) {
                return this.slideLayoutFragmentsByName.get(entryName);
            }
        }
        if ("application/vnd.openxmlformats-officedocument.presentationml.slide+xml".equals(contentType) && this.slideFragmentsByName.containsKey(entryName)) {
            return this.slideFragmentsByName.get(entryName);
        }
        if (this.generalDocument.conditionalParameters().getTranslatePowerpointNotes()) {
            if (this.generalDocument.conditionalParameters().getTranslatePowerpointMasters() && "application/vnd.openxmlformats-officedocument.presentationml.notesMaster+xml".equals(contentType) && this.notesMasterFragmentsByName.containsKey(entryName)) {
                return this.notesMasterFragmentsByName.get(entryName);
            }
            if ("application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml".equals(contentType) && this.notesSlideFragmentsByName.containsKey(entryName)) {
                return this.notesSlideFragmentsByName.get(entryName);
            }
        }
        return null;
    }

    private boolean isExcluded(String entryName, String contentType) {
        if (!this.generalDocument.conditionalParameters().getPowerpointIncludedSlideNumbersOnly()) {
            return false;
        }
        switch (contentType) {
            case "application/vnd.openxmlformats-officedocument.presentationml.slide+xml": {
                return this.isExcludedSlide(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml": {
                return this.isExcludedSlideLayout(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml": {
                return this.isExcludedSlideMaster(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.presentationml.comments+xml": {
                return this.isExcludedComment(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml": {
                return this.isExcludedNotesSlide(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.presentationml.notesMaster+xml": {
                return this.isExcludedNotesMaster(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.drawingml.chart+xml": {
                return this.isExcludedChart(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml": {
                return this.isExcludedDiagramData(entryName);
            }
        }
        return false;
    }

    private boolean isExcludedSlide(String entryName) {
        int slideIndex = this.presentationFragments.slideNames().indexOf(entryName);
        if (slideIndex == -1) {
            return false;
        }
        int slideNumber = slideIndex + 1;
        return !this.generalDocument.conditionalParameters().tsPowerpointIncludedSlideNumbers.contains(slideNumber);
    }

    private boolean isExcludedSlideLayout(String entryName) {
        boolean excluded = false;
        for (String slideName : this.slideLayoutsBySlide.keySet()) {
            if (!this.slideLayoutsBySlide.get(slideName).contains(entryName)) continue;
            if (this.isExcludedSlide(slideName)) {
                excluded = true;
                continue;
            }
            return false;
        }
        return excluded;
    }

    private boolean isExcludedSlideMaster(String entryName) {
        boolean excluded = false;
        for (String slideLayout : this.slideMastersBySlideLayout.keySet()) {
            if (!this.slideMastersBySlideLayout.get(slideLayout).contains(entryName)) continue;
            if (this.isExcludedSlideLayout(slideLayout)) {
                excluded = true;
                continue;
            }
            return false;
        }
        return excluded;
    }

    private boolean isExcludedComment(String entryName) {
        if (!this.slidesByComment.containsKey(entryName)) {
            return false;
        }
        return this.isExcludedSlide(this.slidesByComment.get(entryName));
    }

    private boolean isExcludedNotesSlide(String entryName) {
        if (!this.slidesByNotesSlide.containsKey(entryName)) {
            return false;
        }
        return this.isExcludedSlide(this.slidesByNotesSlide.get(entryName));
    }

    private boolean isExcludedNotesMaster(String entryName) {
        boolean excluded = false;
        for (String notesSlide : this.notesMastersByNotesSlide.keySet()) {
            if (!this.notesMastersByNotesSlide.get(notesSlide).contains(entryName)) continue;
            if (this.isExcludedNotesSlide(notesSlide)) {
                excluded = true;
                continue;
            }
            return false;
        }
        return excluded;
    }

    private boolean isExcludedChart(String entryName) {
        if (!this.slidesByChart.containsKey(entryName)) {
            return false;
        }
        return this.isExcludedSlide(this.slidesByChart.get(entryName));
    }

    private boolean isExcludedDiagramData(String entryName) {
        if (!this.slidesByDiagramData.containsKey(entryName)) {
            return false;
        }
        return this.isExcludedSlide(this.slidesByDiagramData.get(entryName));
    }

    private boolean isHidden(String entryName, String contentType) {
        if (this.generalDocument.conditionalParameters().getTranslatePowerpointHidden()) {
            return false;
        }
        switch (contentType) {
            case "application/vnd.openxmlformats-officedocument.presentationml.slide+xml": {
                return this.isHiddenSlide(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml": {
                return this.isHiddenSlideLayout(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml": {
                return this.isHiddenSlideMaster(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.presentationml.comments+xml": {
                return this.isHiddenComment(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml": {
                return this.isHiddenNotesSlide(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.presentationml.notesMaster+xml": {
                return this.isHiddenNotesMaster(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.drawingml.chart+xml": {
                return this.isHiddenChart(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml": {
                return this.isHiddenDiagramData(entryName);
            }
        }
        return false;
    }

    private boolean isHiddenSlide(String entryName) {
        return this.hiddenSlides.contains(entryName);
    }

    private boolean isHiddenSlideLayout(String entryName) {
        boolean hidden = false;
        for (String slideName : this.slideLayoutsBySlide.keySet()) {
            if (!this.slideLayoutsBySlide.get(slideName).contains(entryName)) continue;
            if (this.isHiddenSlide(slideName)) {
                hidden = true;
                continue;
            }
            return false;
        }
        return hidden;
    }

    private boolean isHiddenSlideMaster(String entryName) {
        boolean hidden = false;
        for (String slideLayout : this.slideMastersBySlideLayout.keySet()) {
            if (!this.slideMastersBySlideLayout.get(slideLayout).contains(entryName)) continue;
            if (this.isHiddenSlideLayout(slideLayout)) {
                hidden = true;
                continue;
            }
            return false;
        }
        return hidden;
    }

    private boolean isHiddenComment(String entryName) {
        if (!this.slidesByComment.containsKey(entryName)) {
            return false;
        }
        return this.isHiddenSlide(this.slidesByComment.get(entryName));
    }

    private boolean isHiddenNotesSlide(String entryName) {
        if (!this.slidesByNotesSlide.containsKey(entryName)) {
            return false;
        }
        return this.isHiddenSlide(this.slidesByNotesSlide.get(entryName));
    }

    private boolean isHiddenNotesMaster(String entryName) {
        boolean hidden = false;
        for (String notesSlide : this.notesMastersByNotesSlide.keySet()) {
            if (!this.notesMastersByNotesSlide.get(notesSlide).contains(entryName)) continue;
            if (this.isHiddenNotesSlide(notesSlide)) {
                hidden = true;
                continue;
            }
            return false;
        }
        return hidden;
    }

    private boolean isHiddenChart(String entryName) {
        if (!this.slidesByChart.containsKey(entryName)) {
            return false;
        }
        return this.isHiddenSlide(this.slidesByChart.get(entryName));
    }

    private boolean isHiddenDiagramData(String entryName) {
        if (!this.slidesByDiagramData.containsKey(entryName)) {
            return false;
        }
        return this.isHiddenSlide(this.slidesByDiagramData.get(entryName));
    }

    @Override
    public void close() throws IOException {
    }
}

