/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import net.sf.okapi.filters.openxml.BlockProperties;
import net.sf.okapi.filters.openxml.BlockProperty;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.IndexedColors;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponentParser;
import net.sf.okapi.filters.openxml.ParagraphBlockProperties;
import net.sf.okapi.filters.openxml.PresetColorValues;
import net.sf.okapi.filters.openxml.Property;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.SchemaDefinition;
import net.sf.okapi.filters.openxml.SkippableElements;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StrippableAttributes;
import net.sf.okapi.filters.openxml.StyleDefinition;
import net.sf.okapi.filters.openxml.SystemColorValues;
import net.sf.okapi.filters.openxml.Theme;

interface PowerpointStyleDefinition
extends StyleDefinition {
    public static final String DEF_PPR = "defPPr";
    public static final Set<String> PARAGRAPH_LEVELS = new HashSet<String>(Arrays.asList("lvl1pPr", "lvl2pPr", "lvl3pPr", "lvl4pPr", "lvl5pPr", "lvl6pPr", "lvl7pPr", "lvl8pPr", "lvl9pPr"));

    public String id();

    public PowerpointStyleDefinition mergedWith(PowerpointStyleDefinition var1);

    public static final class ParagraphLevel
    implements PowerpointStyleDefinition {
        private static final int ID_BEGIN_INDEX = 3;
        private static final int ID_END_INDEX = 4;
        private final ParagraphDefault paragraphDefault;
        private String id;

        ParagraphLevel(ParagraphDefault paragraphDefault) {
            this.paragraphDefault = paragraphDefault;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public PowerpointStyleDefinition mergedWith(PowerpointStyleDefinition other) {
            if (!(other instanceof ParagraphLevel)) {
                throw new IllegalArgumentException("The provided argument is illegal: ".concat(other.getClass().getSimpleName()));
            }
            ParagraphLevel that = (ParagraphLevel)other;
            if (!this.id().equals(that.id())) {
                throw new IllegalArgumentException("The provided paragraph level ID does not match with the available one: ".concat(that.id()).concat(" instead of ").concat(this.id()));
            }
            ParagraphLevel merged = new ParagraphLevel((ParagraphDefault)this.paragraphDefault.mergedWith(that.paragraphDefault));
            merged.id = this.id;
            return merged;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            this.id = this.readId();
            this.paragraphDefault.readWith(reader);
        }

        private String readId() {
            return this.paragraphDefault.startElement.getName().getLocalPart().substring(3, 4);
        }

        @Override
        public ParagraphBlockProperties paragraphProperties() {
            return this.paragraphDefault.paragraphProperties();
        }

        @Override
        public RunProperties runProperties() {
            return this.paragraphDefault.runProperties();
        }

        @Override
        public Markup asMarkup() {
            return this.paragraphDefault.asMarkup();
        }
    }

    public static final class ParagraphDefault
    implements PowerpointStyleDefinition {
        private static final String EMPTY = "";
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private final PresetColorValues presetColorValues;
        private final PresetColorValues highlightColorValues;
        private final SystemColorValues systemColorValues;
        private final IndexedColors indexedColors;
        private final Theme theme;
        private final StartElement startElement;
        private ParagraphBlockProperties paragraphProperties;
        private RunProperties defaultRunProperties;

        ParagraphDefault(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, PresetColorValues presetColorValues, PresetColorValues highlightColorValues, SystemColorValues systemColorValues, IndexedColors indexedColors, Theme theme, String namespaceUri, String prefix) {
            this(conditionalParameters, eventFactory, presetColorValues, highlightColorValues, systemColorValues, indexedColors, theme, eventFactory.createStartElement(prefix, namespaceUri, PowerpointStyleDefinition.DEF_PPR));
        }

        ParagraphDefault(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, PresetColorValues presetColorValues, PresetColorValues highlightColorValues, SystemColorValues systemColorValues, IndexedColors indexedColors, Theme theme, StartElement startElement) {
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
            this.presetColorValues = presetColorValues;
            this.highlightColorValues = highlightColorValues;
            this.systemColorValues = systemColorValues;
            this.indexedColors = indexedColors;
            this.theme = theme;
            this.startElement = startElement;
        }

        @Override
        public String id() {
            return EMPTY;
        }

        @Override
        public ParagraphBlockProperties paragraphProperties() {
            if (null == this.paragraphProperties) {
                this.paragraphProperties = new ParagraphBlockProperties.Drawing(new BlockProperties.Default(this.eventFactory, this.startElement.getName().getPrefix(), this.startElement.getName().getNamespaceURI(), this.startElement.getName().getLocalPart()), this.conditionalParameters, this.eventFactory, this.presetColorValues, this.highlightColorValues, this.systemColorValues, this.indexedColors, this.theme, new StrippableAttributes.DrawingRunProperties(this.conditionalParameters, this.eventFactory), new SchemaDefinition.TextParagraphProperties(new QName(this.startElement.getName().getNamespaceURI(), this.startElement.getName().getLocalPart(), this.startElement.getName().getPrefix())));
            }
            return this.paragraphProperties;
        }

        @Override
        public PowerpointStyleDefinition mergedWith(PowerpointStyleDefinition other) {
            if (!(other instanceof ParagraphDefault)) {
                throw new IllegalArgumentException("The provided argument is illegal: ".concat(other.getClass().getSimpleName()));
            }
            ParagraphDefault that = (ParagraphDefault)other;
            ParagraphDefault merged = new ParagraphDefault(this.conditionalParameters, this.eventFactory, this.presetColorValues, this.highlightColorValues, this.systemColorValues, this.indexedColors, this.theme, this.startElement);
            merged.paragraphProperties = this.paragraphProperties().mergedWith(that.paragraphProperties());
            merged.defaultRunProperties = this.runProperties().mergedWith(that.runProperties());
            return merged;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            StrippableAttributes.DrawingRunProperties strippableAttributes = new StrippableAttributes.DrawingRunProperties(this.conditionalParameters, this.eventFactory);
            this.paragraphProperties = new MarkupComponentParser().parseParagraphBlockProperties(new StartElementContext(this.startElement, reader, this.presetColorValues, this.highlightColorValues, this.systemColorValues, this.indexedColors, this.theme, this.eventFactory, this.conditionalParameters), strippableAttributes, new SkippableElements.Empty());
            ListIterator<Property> iterator = this.paragraphProperties.properties().listIterator();
            while (iterator.hasNext()) {
                Property blockProperty = iterator.next();
                if (!"defRPr".equals(blockProperty.getName().getLocalPart())) continue;
                this.defaultRunProperties = blockProperty.asRunProperties();
                if (this.defaultRunProperties.properties().isEmpty()) {
                    iterator.remove();
                    continue;
                }
                iterator.set(new BlockProperty(this.defaultRunProperties.getEvents(), this.conditionalParameters, this.eventFactory, this.presetColorValues, this.highlightColorValues, this.systemColorValues, this.indexedColors, this.theme, strippableAttributes));
            }
        }

        @Override
        public RunProperties runProperties() {
            if (null == this.defaultRunProperties) {
                this.defaultRunProperties = new RunProperties.Default(this.eventFactory, this.startElement.getName().getPrefix(), this.startElement.getName().getNamespaceURI(), "defRPr");
            }
            return this.defaultRunProperties;
        }

        @Override
        public Markup asMarkup() {
            return new Markup.General(Collections.singletonList(this.paragraphProperties()));
        }
    }
}

