/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import net.sf.okapi.filters.openxml.ConditionalParameters;

interface StrippableAttributes {
    public StartElement strip(StartElement var1);

    public static interface Name {
        public String value();

        public static enum Revision implements Name
        {
            RPR("rsidRPr"),
            DEL("rsidDel"),
            R("rsidR"),
            SECT("rsidSect"),
            P("rsidP"),
            R_DEFAULT("rsidRDefault"),
            TR("rsidTr");

            private final String value;

            private Revision(String value) {
                this.value = value;
            }

            @Override
            public String value() {
                return this.value;
            }
        }

        public static enum Direction implements Name
        {
            RTL("rtl"),
            RTL_COL("rtlCol");

            private final String value;

            private Direction(String value) {
                this.value = value;
            }

            @Override
            public String value() {
                return this.value;
            }
        }

        public static enum RunProperty implements Name
        {
            SPELLING_ERROR("err"),
            NO_PROOFING("noProof"),
            DIRTY("dirty"),
            SMART_TAG_CLEAN("smtClean"),
            LANG("lang"),
            ALT_LANG("altLang"),
            SPACING("spc");

            private final String value;

            private RunProperty(String value) {
                this.value = value;
            }

            @Override
            public String value() {
                return this.value;
            }
        }
    }

    public static final class WordSectionPropertiesRevisions
    implements StrippableAttributes {
        private final Default defaultStrippableAttributes;

        WordSectionPropertiesRevisions(XMLEventFactory eventFactory) {
            this(new Default(eventFactory));
        }

        WordSectionPropertiesRevisions(Default defaultStrippableAttributes) {
            this.defaultStrippableAttributes = defaultStrippableAttributes;
            this.defaultStrippableAttributes.names.addAll(Set.of(Name.Revision.RPR.value(), Name.Revision.DEL.value(), Name.Revision.R.value(), Name.Revision.SECT.value()));
        }

        @Override
        public StartElement strip(StartElement startElement) {
            return this.defaultStrippableAttributes.strip(startElement);
        }
    }

    public static final class WordTableRowRevisions
    implements StrippableAttributes {
        private final Default defaultStrippableAttributes;

        WordTableRowRevisions(XMLEventFactory eventFactory) {
            this(new Default(eventFactory));
        }

        WordTableRowRevisions(Default defaultStrippableAttributes) {
            this.defaultStrippableAttributes = defaultStrippableAttributes;
            this.defaultStrippableAttributes.names.addAll(Set.of(Name.Revision.RPR.value(), Name.Revision.DEL.value(), Name.Revision.R.value(), Name.Revision.TR.value()));
        }

        @Override
        public StartElement strip(StartElement startElement) {
            return this.defaultStrippableAttributes.strip(startElement);
        }
    }

    public static final class WordRunRevisions
    implements StrippableAttributes {
        private final Default defaultStrippableAttributes;

        WordRunRevisions(XMLEventFactory eventFactory) {
            this(new Default(eventFactory));
        }

        WordRunRevisions(Default defaultStrippableAttributes) {
            this.defaultStrippableAttributes = defaultStrippableAttributes;
            this.defaultStrippableAttributes.names.addAll(Set.of(Name.Revision.RPR.value(), Name.Revision.DEL.value(), Name.Revision.R.value()));
        }

        @Override
        public StartElement strip(StartElement startElement) {
            return this.defaultStrippableAttributes.strip(startElement);
        }
    }

    public static final class WordParagraphRevisions
    implements StrippableAttributes {
        private final Default defaultStrippableAttributes;

        WordParagraphRevisions(XMLEventFactory eventFactory) {
            this(new Default(eventFactory));
        }

        WordParagraphRevisions(Default defaultStrippableAttributes) {
            this.defaultStrippableAttributes = defaultStrippableAttributes;
            this.defaultStrippableAttributes.names.addAll(Set.of(Name.Revision.RPR.value(), Name.Revision.DEL.value(), Name.Revision.R.value(), Name.Revision.P.value(), Name.Revision.R_DEFAULT.value()));
        }

        @Override
        public StartElement strip(StartElement startElement) {
            return this.defaultStrippableAttributes.strip(startElement);
        }
    }

    public static final class DrawingBodyDirection
    implements StrippableAttributes {
        private final Default defaultStrippableAttributes;

        DrawingBodyDirection(XMLEventFactory eventFactory) {
            this(new Default(eventFactory));
        }

        DrawingBodyDirection(Default defaultStrippableAttributes) {
            this.defaultStrippableAttributes = defaultStrippableAttributes;
            this.defaultStrippableAttributes.names.add(Name.Direction.RTL_COL.value());
        }

        @Override
        public StartElement strip(StartElement startElement) {
            return this.defaultStrippableAttributes.strip(startElement);
        }
    }

    public static final class DrawingDirection
    implements StrippableAttributes {
        private final Default defaultStrippableAttributes;

        DrawingDirection(XMLEventFactory eventFactory) {
            this(new Default(eventFactory));
        }

        DrawingDirection(Default defaultStrippableAttributes) {
            this.defaultStrippableAttributes = defaultStrippableAttributes;
            this.defaultStrippableAttributes.names.add(Name.Direction.RTL.value());
        }

        @Override
        public StartElement strip(StartElement startElement) {
            return this.defaultStrippableAttributes.strip(startElement);
        }
    }

    public static final class DrawingRunProperties
    implements StrippableAttributes {
        private final Default defaultStrippableAttributes;

        DrawingRunProperties(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory) {
            this(new Default(eventFactory), conditionalParameters);
        }

        DrawingRunProperties(Default defaultStrippableAttributes, ConditionalParameters conditionalParameters) {
            this.defaultStrippableAttributes = defaultStrippableAttributes;
            Stream<String> unconditional = Stream.of(Name.RunProperty.SPELLING_ERROR.value(), Name.RunProperty.NO_PROOFING.value(), Name.RunProperty.DIRTY.value(), Name.RunProperty.SMART_TAG_CLEAN.value(), Name.RunProperty.LANG.value(), Name.RunProperty.ALT_LANG.value());
            Stream<String> merged = conditionalParameters.getCleanupAggressively() ? Stream.concat(unconditional, Stream.of(Name.RunProperty.SPACING.value())) : unconditional;
            this.defaultStrippableAttributes.names.addAll(merged.collect(Collectors.toSet()));
        }

        @Override
        public StartElement strip(StartElement startElement) {
            return this.defaultStrippableAttributes.strip(startElement);
        }
    }

    public static final class Default
    implements StrippableAttributes {
        private final Set<String> names;
        private final XMLEventFactory eventFactory;

        Default(XMLEventFactory eventFactory) {
            this(new HashSet<String>(), eventFactory);
        }

        Default(Set<String> names, XMLEventFactory eventFactory) {
            this.names = names;
            this.eventFactory = eventFactory;
        }

        @Override
        public StartElement strip(StartElement startElement) {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            Iterator<Attribute> currentAttributesIterator = startElement.getAttributes();
            while (currentAttributesIterator.hasNext()) {
                Attribute attribute = currentAttributesIterator.next();
                if (this.names.contains(attribute.getName().getLocalPart())) continue;
                attributes.add(attribute);
            }
            return this.eventFactory.createStartElement(startElement.getName(), attributes.iterator(), startElement.getNamespaces());
        }
    }
}

