/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.CodeTypeFactory;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.RunCode;
import net.sf.okapi.filters.openxml.RunFonts;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunPropertiesPairWithDetectedRunFonts;
import net.sf.okapi.filters.openxml.TextUnitProperties;
import net.sf.okapi.filters.openxml.Textual;
import net.sf.okapi.filters.openxml.TranslatableAttributeText;
import net.sf.okapi.filters.openxml.XMLEvents;

abstract class TextUnitMapper {
    private static final int DEFAULT_CODE_STACK_POPS_LIMIT = 0;
    private static final int UNUSED_RUN_POSITION_VALUE = -1;
    private static final String NESTED_ID_GENERATOR_PREFIX = "sub";
    static final String REFERENCES = "references";
    protected final IdGenerator idGenerator;
    protected final XMLEventFactory eventFactory;
    protected List<ITextUnit> referentTus = new ArrayList<ITextUnit>();
    protected List<XMLEvents> hiddenCodes = new ArrayList<XMLEvents>();
    protected Map<Integer, XMLEvents> visibleCodes = new HashMap<Integer, XMLEvents>();
    protected Deque<RunCode> runCodeStack = new ArrayDeque<RunCode>();
    protected int nextCodeId = 1;
    protected IdGenerator nestedIdsGenerator;
    RunPropertiesPairWithDetectedRunFonts baseRunPropertiesPairWithDetectedRunFonts;

    TextUnitMapper(IdGenerator idGenerator, XMLEventFactory eventFactory) {
        this.idGenerator = idGenerator;
        this.eventFactory = eventFactory;
    }

    public abstract List<ITextUnit> map();

    void baseRunPropertiesPairWithDetectedRunFonts(List<Chunk> chunks, QName name) {
        this.baseRunPropertiesPairWithDetectedRunFonts = chunks.stream().filter(c -> c instanceof Run).min(Comparator.comparingInt(chunk -> ((Run)chunk).propertiesPair().direct().count())).map(chunk -> ((Run)chunk).propertiesPair()).orElseGet(() -> new RunPropertiesPairWithDetectedRunFonts(new RunProperties.Default(this.eventFactory, name.getPrefix(), name.getNamespaceURI(), "rPr"), new RunProperties.Default(this.eventFactory, name.getPrefix(), name.getNamespaceURI(), "rPr"), new RunFonts(this.eventFactory, this.eventFactory.createStartElement(name.getPrefix(), name.getNamespaceURI(), "rFonts"), new EnumMap<RunFonts.ContentCategory, String>(RunFonts.ContentCategory.class), EnumSet.noneOf(RunFonts.ContentCategory.class))));
    }

    boolean processRun(ITextUnit textUnit, Run run) {
        List<ITextUnit> nestedTus = this.processNestedBlocks(run, textUnit.getId());
        TextUnitProperties.addInteger(textUnit, REFERENCES, this.countDirectReferences(nestedTus));
        this.referentTus.addAll(nestedTus);
        return this.addRun(textUnit.getSource().getFirstContent(), 0, -1, run, null);
    }

    protected List<ITextUnit> processNestedBlocks(Run run, String parentId) {
        IdGenerator nestedIdsGenerator = this.getNestedIdsGenerator(parentId);
        ArrayList<ITextUnit> tus = new ArrayList<ITextUnit>();
        for (Textual textual : run.getNestedTextualItems()) {
            if (!(textual instanceof TranslatableAttributeText)) continue;
            TextUnit tu = new TextUnit(nestedIdsGenerator.createId(), ((TranslatableAttributeText)textual).getText());
            tu.setPreserveWhitespaces(true);
            tu.setIsReferent(true);
            tus.add(tu);
        }
        return tus;
    }

    int countDirectReferences(List<ITextUnit> textUnits) {
        int directReferences = textUnits.size();
        for (ITextUnit textUnit : textUnits) {
            directReferences -= TextUnitProperties.integer(textUnit, REFERENCES);
        }
        return directReferences;
    }

    private IdGenerator getNestedIdsGenerator(String parentId) {
        if (this.nestedIdsGenerator == null) {
            this.nestedIdsGenerator = new IdGenerator(parentId, NESTED_ID_GENERATOR_PREFIX);
        }
        return this.nestedIdsGenerator;
    }

    boolean addRun(TextFragment tf, int codeStackPopsLimit, int runPosition, Run run, Run nextRun) {
        if (!run.containsVisibleText()) {
            if (tf.getCodedText().isEmpty()) {
                this.hiddenCodes.add(run);
            } else {
                this.addIsolatedCode(tf, run);
            }
            return false;
        }
        RunPropertiesPairWithDetectedRunFonts rpp = run.propertiesPair();
        RunProperties rp = rpp.direct();
        while (this.runCodeStack.size() > codeStackPopsLimit && !this.runCodeStack.isEmpty() && !this.runCodeStack.peekFirst().runPropertiesPair().direct().isSubsetOf(rp)) {
            this.addClosingCode(tf, this.runCodeStack.pop());
        }
        if (0 == runPosition && null != nextRun && !nextRun.propertiesPair().direct().equals(rp) && !nextRun.propertiesPair().direct().isSubsetOf(rp) || !this.baseRunPropertiesPairWithDetectedRunFonts.direct().equals(rp) && (this.runCodeStack.isEmpty() || !this.runCodeStack.peekFirst().runPropertiesPair().direct().equals(rp))) {
            RunCode rc = new RunCode(this.nextCodeId++, CodeTypeFactory.createCodeType(rpp.combined()), rpp);
            this.runCodeStack.push(rc);
            this.addOpeningCode(tf, rc);
        }
        this.addRunContent(tf, run);
        return true;
    }

    protected void addRunContent(TextFragment tf, Run run) {
        for (XMLEvents xMLEvents : run.getBodyChunks()) {
            if (xMLEvents instanceof Run.RunText) {
                this.addText(tf, ((Run.RunText)xMLEvents).characters().getData());
                continue;
            }
            this.addIsolatedCode(tf, xMLEvents);
        }
    }

    protected void popAllRunCodes(TextFragment tf) {
        while (!this.runCodeStack.isEmpty()) {
            this.addClosingCode(tf, this.runCodeStack.pop());
        }
    }

    protected void addText(TextFragment tf, String text) {
        tf.append(text);
    }

    protected void addOpeningCode(TextFragment tf, RunCode rc) {
        Code code = new Code(TextFragment.TagType.OPENING, rc.type());
        code.setId(rc.id());
        code.setData("<run" + code.getId() + ">");
        this.visibleCodes.put(rc.id(), rc.runPropertiesPair());
        tf.append(code);
    }

    protected void addClosingCode(TextFragment tf, RunCode rc) {
        Code code = new Code(TextFragment.TagType.CLOSING, rc.type());
        code.setId(rc.id());
        code.setData("</run" + code.getId() + ">");
        tf.append(code);
    }

    protected void addIsolatedCode(TextFragment tf, XMLEvents events) {
        int codeId = this.nextCodeId++;
        this.visibleCodes.put(codeId, events);
        Code code = new Code(TextFragment.TagType.PLACEHOLDER, "x", this.getCodeData(events, codeId));
        code.setId(codeId);
        tf.append(code);
    }

    private String getCodeData(XMLEvents codeEvents, int codeId) {
        if (codeEvents instanceof Run) {
            return "<run" + codeId + "/>";
        }
        return "<tags" + codeId + "/>";
    }
}

