/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.IndexedColors;
import net.sf.okapi.filters.openxml.MasterAndPagePart;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.NonModifiablePart;
import net.sf.okapi.filters.openxml.Part;
import net.sf.okapi.filters.openxml.PresetColorValues;
import net.sf.okapi.filters.openxml.Relationship;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.SystemColorValues;
import net.sf.okapi.filters.openxml.ZipEntryComparator;

class VisioDocument
implements Document {
    private static final String MASTERS = Namespaces.VisioDocumentRelationships.getDerivedURI("/masters");
    private static final String PAGES = Namespaces.VisioDocumentRelationships.getDerivedURI("/pages");
    private static final String MASTER = Namespaces.VisioDocumentRelationships.getDerivedURI("/master");
    private static final String PAGE = Namespaces.VisioDocumentRelationships.getDerivedURI("/page");
    private final Document.General generalDocument;
    private PresetColorValues highlightColorValues;
    private SystemColorValues systemColorValues;
    private Enumeration<? extends ZipEntry> entries;
    private List<String> mastersAndPages;

    VisioDocument(Document.General generalDocument) {
        this.generalDocument = generalDocument;
    }

    @Override
    public Event open() throws IOException, XMLStreamException {
        this.highlightColorValues = new PresetColorValues.Default(Collections.emptyList());
        this.systemColorValues = new SystemColorValues.Default(Collections.emptyList());
        this.mastersAndPages = this.mastersAndPages();
        this.entries = this.entries();
        return this.generalDocument.startDocumentEvent();
    }

    private List<String> mastersAndPages() throws IOException, XMLStreamException {
        Iterator<Relationship> mastersIterator = this.generalDocument.mainPartRelationships().of(MASTERS).iterator();
        if (!mastersIterator.hasNext()) {
            throw new OkapiBadFilterInputException("Unexpected number of relationships");
        }
        Iterator<Relationship> pagesIterator = this.generalDocument.mainPartRelationships().of(PAGES).iterator();
        if (!pagesIterator.hasNext()) {
            throw new OkapiBadFilterInputException("Unexpected number of relationships");
        }
        Relationships masterRelationships = this.generalDocument.relationshipsFor(mastersIterator.next().target());
        Relationships pageRelationships = this.generalDocument.relationshipsFor(pagesIterator.next().target());
        ArrayList<String> targets = new ArrayList<String>(this.generalDocument.targetsOf(masterRelationships.of(MASTER)));
        targets.addAll(this.generalDocument.targetsOf(pageRelationships.of(PAGE)));
        return targets;
    }

    private Enumeration<? extends ZipEntry> entries() {
        ArrayList<? extends ZipEntry> entries = Collections.list(this.generalDocument.entries());
        entries.sort(new ZipEntryComparator(this.mastersAndPages));
        return Collections.enumeration(entries);
    }

    @Override
    public PresetColorValues highlightColorValues() {
        return this.highlightColorValues;
    }

    @Override
    public SystemColorValues systemColorValues() {
        return this.systemColorValues;
    }

    @Override
    public IndexedColors indexedColors() {
        return StyleDefinitions.Empty.INDEXED_COLORS;
    }

    @Override
    public boolean isStyledTextPart(ZipEntry entry) {
        return false;
    }

    @Override
    public boolean hasNextPart() {
        return this.entries.hasMoreElements();
    }

    @Override
    public Part nextPart() {
        ZipEntry entry = this.entries.nextElement();
        if (!this.isTranslatablePart(entry)) {
            return new NonModifiablePart(this.generalDocument, entry);
        }
        return new MasterAndPagePart(this.generalDocument, entry);
    }

    @Override
    public StyleDefinitions styleDefinitionsFor(ZipEntry entry) {
        return new StyleDefinitions.Empty();
    }

    private boolean isTranslatablePart(ZipEntry entry) {
        String contentType = this.generalDocument.contentTypeFor(entry);
        return entry.getName().endsWith(".xml") && (VisioDocument.isMasterPart(contentType) || VisioDocument.isPagePart(contentType));
    }

    private static boolean isMasterPart(String type) {
        return "application/vnd.ms-visio.master+xml".equals(type);
    }

    private static boolean isPagePart(String type) {
        return "application/vnd.ms-visio.page+xml".equals(type);
    }

    @Override
    public void close() throws IOException {
    }
}

