/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.filters.openxml.ContentCategoriesDetection;
import net.sf.okapi.filters.openxml.ContentFilter;
import net.sf.okapi.filters.openxml.DefaultPart;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.HighlightColorValues;
import net.sf.okapi.filters.openxml.IndexedColors;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupModifiablePart;
import net.sf.okapi.filters.openxml.ModifiablePart;
import net.sf.okapi.filters.openxml.Namespace;
import net.sf.okapi.filters.openxml.NonModifiablePart;
import net.sf.okapi.filters.openxml.NumberingDefinitions;
import net.sf.okapi.filters.openxml.NumberingPart;
import net.sf.okapi.filters.openxml.ParseType;
import net.sf.okapi.filters.openxml.Part;
import net.sf.okapi.filters.openxml.PresetColorValues;
import net.sf.okapi.filters.openxml.Relationship;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.RelationshipsPart;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleOptimisation;
import net.sf.okapi.filters.openxml.StyledTextPart;
import net.sf.okapi.filters.openxml.SystemColorValues;
import net.sf.okapi.filters.openxml.WordStyleDefinitions;
import net.sf.okapi.filters.openxml.WordStyleDefinitionsReader;
import net.sf.okapi.filters.openxml.ZipEntryComparator;

class WordDocument
implements Document {
    private static final String GLOSSARY_DOCUMENT = "/glossaryDocument";
    private static final String STYLES = "/styles";
    private static final String NUMBERING = "/numbering";
    private static final String EMPTY = "";
    private final Document.General generalDocument;
    private Enumeration<? extends ZipEntry> entries;
    private PresetColorValues highlightColorValues;
    private SystemColorValues systemColorValues;
    private String glossaryPartPath;
    private String glossaryStyleDefinitionsPartPath;
    private StyleDefinitions mainStyleDefinitions;
    private StyleDefinitions glossaryStyleDefinitions;
    private NumberingDefinitions numberingDefinitions;
    private LinkedHashMap<ZipEntry, Markup> postponedParts;

    WordDocument(Document.General generalDocument) {
        this.generalDocument = generalDocument;
    }

    @Override
    public Event open() throws IOException, XMLStreamException {
        this.postponedParts = new LinkedHashMap();
        this.entries = this.entries();
        this.highlightColorValues = new HighlightColorValues();
        this.systemColorValues = new SystemColorValues.Default(Collections.emptyList());
        this.initialiseGlossaryPartName();
        this.initialiseStyleDefinitions();
        this.initialiseNumberingDefinitions();
        return this.generalDocument.startDocumentEvent();
    }

    private Enumeration<? extends ZipEntry> entries() {
        ArrayList<? extends ZipEntry> entryList = new ArrayList<ZipEntry>();
        String numberingPartPath = this.generalDocument.targetFor(NUMBERING);
        entryList.addAll(Collections.list(this.generalDocument.entries()));
        ListIterator iterator = entryList.listIterator();
        while (iterator.hasNext()) {
            String name = ((ZipEntry)iterator.next()).getName();
            if (!name.equals(numberingPartPath)) continue;
            iterator.remove();
        }
        if (!numberingPartPath.isEmpty()) {
            entryList.add(new ZipEntry(numberingPartPath));
        }
        entryList.sort(new ZipEntryComparator(this.reorderedPartPaths()));
        return Collections.enumeration(entryList);
    }

    private List<String> reorderedPartPaths() {
        LinkedList<String> names = new LinkedList<String>();
        names.add(this.generalDocument.relationshipsPartPathFor(this.generalDocument.mainPartPath()).asString());
        names.add(this.generalDocument.mainPartPath());
        return names;
    }

    private void initialiseGlossaryPartName() {
        String glossaryDocumentSourceType = this.generalDocument.mainPartRelationshipsNamespace().uri().concat(GLOSSARY_DOCUMENT);
        Iterator<Relationship> ri = this.generalDocument.mainPartRelationships().of(glossaryDocumentSourceType).iterator();
        this.glossaryPartPath = ri.hasNext() ? ri.next().target() : EMPTY;
    }

    private void initialiseStyleDefinitions() throws IOException, XMLStreamException {
        String stylesType = this.generalDocument.mainPartRelationshipsNamespace().uri().concat(STYLES);
        Iterator<Relationship> ri = this.generalDocument.mainPartRelationships().of(stylesType).iterator();
        this.mainStyleDefinitions = ri.hasNext() ? this.styleDefinitions(ri.next().target()) : this.styleDefinitions(EMPTY);
        if (this.glossaryPartPath.isEmpty()) {
            this.glossaryStyleDefinitions = this.styleDefinitions(EMPTY);
        } else {
            Iterator<Relationship> gri = this.generalDocument.relationshipsFor(this.glossaryPartPath).of(stylesType).iterator();
            if (gri.hasNext()) {
                this.glossaryStyleDefinitionsPartPath = gri.next().target();
                this.glossaryStyleDefinitions = this.styleDefinitions(this.glossaryStyleDefinitionsPartPath);
            } else {
                this.glossaryStyleDefinitionsPartPath = EMPTY;
                this.glossaryStyleDefinitions = this.styleDefinitions(EMPTY);
            }
        }
    }

    private StyleDefinitions styleDefinitions(String partPath) throws IOException, XMLStreamException {
        if (partPath.isEmpty()) {
            return new StyleDefinitions.Empty();
        }
        try (Reader reader = this.generalDocument.getPartReader(partPath);){
            WordStyleDefinitions styleDefinitions = new WordStyleDefinitions(this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), this.generalDocument.presetColorValues(), this.highlightColorValues, this.systemColorValues, this.generalDocument.mainPartTheme());
            styleDefinitions.readWith(new WordStyleDefinitionsReader(this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), this.generalDocument.presetColorValues(), this.highlightColorValues, this.systemColorValues, StyleDefinitions.Empty.INDEXED_COLORS, this.generalDocument.mainPartTheme(), this.generalDocument.inputFactory().createXMLEventReader(reader)));
            WordStyleDefinitions wordStyleDefinitions = styleDefinitions;
            return wordStyleDefinitions;
        }
    }

    private void initialiseNumberingDefinitions() throws IOException, XMLStreamException {
        String partPath = this.generalDocument.targetFor(NUMBERING);
        if (partPath.isEmpty()) {
            this.numberingDefinitions = new NumberingDefinitions.Empty();
        } else {
            try (Reader reader = this.generalDocument.getPartReader(partPath);){
                this.numberingDefinitions = new NumberingDefinitions.Default();
                this.numberingDefinitions.readWith(this.generalDocument.inputFactory().createXMLEventReader(reader));
            }
        }
    }

    @Override
    public PresetColorValues highlightColorValues() {
        return this.highlightColorValues;
    }

    @Override
    public SystemColorValues systemColorValues() {
        return this.systemColorValues;
    }

    @Override
    public IndexedColors indexedColors() {
        return this.mainStyleDefinitions.indexedColors();
    }

    @Override
    public boolean isStyledTextPart(ZipEntry entry) {
        String type = this.generalDocument.contentTypeFor(entry);
        return type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml") || type.equals("application/vnd.ms-word.document.macroEnabled.main+xml") || type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.header+xml") || type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml") || type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml") || type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml") || type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml") || type.equals("application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml") || type.equals("application/vnd.openxmlformats-officedocument.drawingml.chart+xml") || this.isGlossaryStyledTextPart(entry);
    }

    private boolean isGlossaryStyledTextPart(ZipEntry entry) {
        String type = this.generalDocument.contentTypeFor(entry);
        return type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml");
    }

    @Override
    public boolean hasNextPart() {
        return this.entries.hasMoreElements() || !this.postponedParts.isEmpty();
    }

    @Override
    public Part nextPart() throws IOException, XMLStreamException {
        if (!this.entries.hasMoreElements()) {
            return this.nextPostponedPart();
        }
        ZipEntry entry = this.entries.nextElement();
        String contentType = this.generalDocument.contentTypeFor(entry);
        if (!this.isTranslatablePart(entry)) {
            if (this.isModifiablePart(entry.getName(), contentType)) {
                switch (contentType) {
                    case "application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml": {
                        this.postponedParts.put(entry, new Markup.Empty());
                        return this.nextPart();
                    }
                    case "application/vnd.openxmlformats-officedocument.theme+xml": {
                        return new ModifiablePart(this.generalDocument, entry, this.generalDocument.inputStreamFor(entry));
                    }
                }
                throw new IllegalStateException("Unsupported modifiable content type: ".concat(contentType));
            }
            return new NonModifiablePart(this.generalDocument, entry);
        }
        if (this.isStyledTextPart(entry)) {
            StyleDefinitions styleDefinitions = this.styleDefinitionsFor(entry);
            StyleOptimisation styleOptimisation = this.styleOptimisationsFor(entry, styleDefinitions);
            return new StyledTextPart(this.generalDocument, entry, styleDefinitions, styleOptimisation, this.numberingDefinitions, new ContentCategoriesDetection.Default(this.generalDocument.sourceLocale()));
        }
        if ("application/vnd.openxmlformats-package.relationships+xml".equals(contentType)) {
            Relationships relationships = entry.getName().equals(this.generalDocument.relationshipsPartPathFor(this.generalDocument.mainPartPath()).asString()) ? this.generalDocument.mainPartRelationships() : this.generalDocument.relationshipsFrom(entry.getName());
            return new RelationshipsPart(this.generalDocument, entry, relationships);
        }
        if ("application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml".equals(contentType)) {
            return new NumberingPart(this.generalDocument, entry, this.numberingDefinitions);
        }
        ContentFilter contentFilter = new ContentFilter(this.generalDocument.conditionalParameters(), entry.getName());
        ParseType parseType = ParseType.MSWORD;
        if ("application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml".equals(contentType)) {
            contentFilter.setBInSettingsFile(true);
        } else if ("application/vnd.openxmlformats-package.core-properties+xml".equals(contentType)) {
            parseType = ParseType.MSWORDDOCPROPERTIES;
        }
        contentFilter.setUpConfig(parseType);
        return new DefaultPart(this.generalDocument, entry, contentFilter);
    }

    private Part nextPostponedPart() {
        Iterator<Map.Entry<ZipEntry, Markup>> iterator = this.postponedParts.entrySet().iterator();
        Map.Entry<ZipEntry, Markup> mapEntry = iterator.next();
        iterator.remove();
        String contentType = this.generalDocument.contentTypeFor(mapEntry.getKey());
        if ("application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml".equals(contentType)) {
            return new MarkupModifiablePart(this.generalDocument, mapEntry.getKey(), this.styleDefinitions(mapEntry.getKey()).asMarkup());
        }
        return new MarkupModifiablePart(this.generalDocument, mapEntry.getKey(), mapEntry.getValue());
    }

    private StyleDefinitions styleDefinitions(ZipEntry entry) {
        if (entry.getName().equals(this.glossaryStyleDefinitionsPartPath)) {
            return this.glossaryStyleDefinitions;
        }
        return this.mainStyleDefinitions;
    }

    @Override
    public StyleDefinitions styleDefinitionsFor(ZipEntry entry) {
        if (this.isGlossaryStyledTextPart(entry)) {
            return this.glossaryStyleDefinitions;
        }
        return this.mainStyleDefinitions;
    }

    private StyleOptimisation styleOptimisationsFor(ZipEntry entry, StyleDefinitions styleDefinitions) throws IOException, XMLStreamException {
        StyleOptimisation styleOptimisation;
        if (this.generalDocument.conditionalParameters().getAllowWordStyleOptimisation()) {
            Iterator<Namespace> iterator = this.generalDocument.namespacesOf(entry).with("w").iterator();
            if (iterator.hasNext()) {
                Namespace namespace = iterator.next();
                styleOptimisation = new StyleOptimisation.Default(new StyleOptimisation.Bypass(), this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), this.generalDocument.presetColorValues(), this.generalDocument.highlightColorValues(), this.generalDocument.systemColorValues(), this.generalDocument.indexedColors(), this.generalDocument.mainPartTheme(), new QName(namespace.uri(), "pPr", namespace.prefix()), new QName(namespace.uri(), "rPr", namespace.prefix()), Collections.singletonList(new QName(namespace.uri(), "rStyle", namespace.prefix())), styleDefinitions);
            } else {
                styleOptimisation = new StyleOptimisation.Bypass();
            }
        } else {
            styleOptimisation = new StyleOptimisation.Bypass();
        }
        return styleOptimisation;
    }

    private boolean isTranslatablePart(ZipEntry entry) throws XMLStreamException, IOException {
        String type = this.generalDocument.contentTypeFor(entry);
        if (!entry.getName().endsWith(".xml") && !entry.getName().endsWith(".rels")) {
            return false;
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml")) {
            return true;
        }
        if (type.equals("application/vnd.ms-word.document.macroEnabled.main+xml")) {
            return true;
        }
        if (this.generalDocument.conditionalParameters().getTranslateDocProperties() && type.equals("application/vnd.openxmlformats-package.core-properties+xml")) {
            return true;
        }
        if ("application/vnd.openxmlformats-package.relationships+xml".equals(type)) {
            return this.generalDocument.conditionalParameters().getExtractExternalHyperlinks() && this.generalDocument.relationshipsFrom(entry.getName()).availableWith("External");
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.header+xml") || type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml")) {
            return this.generalDocument.conditionalParameters().getTranslateWordHeadersFooters();
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml")) {
            return this.generalDocument.conditionalParameters().getTranslateWordNumberingLevelText();
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml")) {
            return this.generalDocument.conditionalParameters().getTranslateComments();
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml")) {
            return true;
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.drawingml.chart+xml")) {
            return true;
        }
        return this.isStyledTextPart(entry);
    }

    private boolean isModifiablePart(String entryName, String contentType) {
        return "application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml".equals(contentType);
    }

    @Override
    public void close() throws IOException {
    }
}

