/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.XMLEventSerializer;
import net.sf.okapi.filters.openxml.XMLEvents;

class XMLEventHelpers {
    static final QName ATTR_XML_SPACE = Namespaces.XML.getQName("space");
    static final QName WPML_ID = Namespaces.WordProcessingML.getQName("id");
    static final QName WPML_NAME = Namespaces.WordProcessingML.getQName("name");
    static final QName WPML_VAL = Namespaces.WordProcessingML.getQName("val");
    static final QName DML_VAL = Namespaces.DrawingML.getQName("val");
    static final QName WPML_PROPERTY_VANISH = Namespaces.WordProcessingML.getQName("vanish");
    static final QName DML_HYPERLINK_ACTION = Namespaces.DrawingML.getQName("action");
    static final String LOCAL_SHEET_VIEW = "sheetView";
    static final String DRAWING_ALIGNMENT = "algn";
    static final String DRAWING_ALIGNMENT_LEFT = "l";
    static final String DRAWING_ALIGNMENT_RIGHT = "r";
    static final String LOCAL_PRESENTATION = "presentation";
    static final String LOCAL_TABLE = "tbl";
    static final String LOCAL_TABLE_GRID = "tblGrid";
    static final String LOCAL_TABLE_ROW = "tr";
    static final String LOCAL_TEXT_BODY = "txBody";
    static final String LOCAL_PARA = "p";
    static final String LOCAL_STRING_ITEM = "si";
    static final String LOCAL_PARAGRAPH_PROPERTIES = "pPr";
    static final String LOCAL_BIDIRECTIONAL = "bidi";
    static final String LOCAL_BIDI_VISUAL = "bidiVisual";
    static final String LOCAL_RTL = "rtl";
    static final String LOCAL_RTL_COL = "rtlCol";
    static final String LOCAL_READING_ORDER = "readingOrder";
    static final String LOCAL_READING_ORDER_RTL_VALUE = "2";
    static final String LOCAL_RIGHT_TO_LEFT = "rightToLeft";
    static final String LOCAL_RUN = "r";
    static final String LOCAL_PROPERTY_LANGUAGE = "lang";
    static final String LOCAL_TEXT = "t";
    static final String LOCAL_VALUE = "v";
    static final String LOCAL_NO_BREAK_HYPHEN = "noBreakHyphen";
    static final String LOCAL_REGULAR_HYPHEN_VALUE = "-";
    static final String LOCAL_SOFT_HYPHEN = "softHyphen";
    static final String LOCAL_TAB = "tab";
    static final String LOCAL_BREAK = "br";
    static final String LOCAL_CARRIAGE_RETURN = "cr";
    static final String LOCAL_SECTION_PROPERTIES = "sectPr";
    static final String LOCAL_TEXTPATH = "textpath";
    static final String LOCAL_DRAWING_PROPERTY = "docPr";
    static final String LOCAL_GRAPHICS_PROPERTY = "cNvPr";
    static final String LOCAL_TYPE = "type";
    private static final String LOCAL_TABLE_COLUMN = "tableColumn";
    private static final String LOCAL_SHEET_FORMULA = "f";
    private static final String LOCAL_TABLE_FORMULA = "formula";
    private static final String LOCAL_CALCULATED_FORMULA = "calculatedColumnFormula";
    private static final Set<String> BOOLEAN_ATTRIBUTE_FALSE_VALUES = new LinkedHashSet<String>(2);
    private static final Set<String> BOOLEAN_ATTRIBUTE_TRUE_VALUES;
    static final boolean DEFAULT_BOOLEAN_ATTRIBUTE_TRUE_VALUE;
    static final boolean DEFAULT_BOOLEAN_ATTRIBUTE_FALSE_VALUE;

    XMLEventHelpers() {
    }

    static boolean isSectionPropertiesStartEvent(XMLEvent event) {
        return XMLEventHelpers.isStartElement(event, LOCAL_SECTION_PROPERTIES);
    }

    static boolean isPresentationStartEvent(XMLEvent event) {
        return XMLEventHelpers.isStartElement(event, LOCAL_PRESENTATION);
    }

    static boolean isPresentationEndEvent(XMLEvent event) {
        return XMLEventHelpers.isEndElement(event, LOCAL_PRESENTATION);
    }

    static boolean isTableStartEvent(XMLEvent event) {
        return XMLEventHelpers.isStartElement(event, LOCAL_TABLE);
    }

    static boolean isTableEndEvent(XMLEvent event) {
        return XMLEventHelpers.isEndElement(event, LOCAL_TABLE);
    }

    static boolean isTablePropertiesStartEvent(XMLEvent event) {
        return XMLEventHelpers.isStartElement(event, "tblPr");
    }

    static boolean isTableGridStartEvent(XMLEvent event) {
        return XMLEventHelpers.isStartElement(event, LOCAL_TABLE_GRID);
    }

    static boolean isTableGridEndEvent(XMLEvent event) {
        return XMLEventHelpers.isEndElement(event, LOCAL_TABLE_GRID);
    }

    static boolean isTableRowStartEvent(XMLEvent event) {
        return XMLEventHelpers.isStartElement(event, LOCAL_TABLE_ROW);
    }

    static boolean isTableRowEndEvent(XMLEvent event) {
        return XMLEventHelpers.isEndElement(event, LOCAL_TABLE_ROW);
    }

    static boolean isTextBodyStartEvent(XMLEvent event) {
        return XMLEventHelpers.isStartElement(event, LOCAL_TEXT_BODY);
    }

    static boolean isTextBodyEndEvent(XMLEvent event) {
        return XMLEventHelpers.isEndElement(event, LOCAL_TEXT_BODY);
    }

    static boolean isTextBodyPropertiesStartEvent(XMLEvent event) {
        return XMLEventHelpers.isStartElement(event, "bodyPr");
    }

    static boolean isParagraphStartEvent(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_PARA);
    }

    static boolean isParagraphEndEvent(XMLEvent e) {
        return XMLEventHelpers.isEndElement(e, LOCAL_PARA);
    }

    static boolean isStringItemStartEvent(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_STRING_ITEM);
    }

    static boolean isStringItemEndEvent(XMLEvent e) {
        return XMLEventHelpers.isEndElement(e, LOCAL_STRING_ITEM);
    }

    static boolean isParagraphPropertiesStartEvent(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_PARAGRAPH_PROPERTIES);
    }

    static boolean isRunStartEvent(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, "r") && !Namespaces.Math.containsName(e.asStartElement().getName());
    }

    static boolean isRunPropsStartEvent(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, "rPr");
    }

    static boolean isTextStartEvent(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_TEXT);
    }

    static boolean isTableColumnEvent(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_TABLE_COLUMN);
    }

    static boolean isExcelFormula(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_SHEET_FORMULA) || XMLEventHelpers.isStartElement(e, LOCAL_TABLE_FORMULA) || XMLEventHelpers.isStartElement(e, LOCAL_CALCULATED_FORMULA);
    }

    static boolean isNoBreakHyphenStartEvent(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_NO_BREAK_HYPHEN);
    }

    static boolean isSoftHyphenStartEvent(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_SOFT_HYPHEN);
    }

    static boolean isTabStartEvent(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_TAB);
    }

    static boolean isLineBreakStartEvent(XMLEvent e) {
        if (XMLEventHelpers.isStartElement(e, LOCAL_BREAK) || XMLEventHelpers.isStartElement(e, LOCAL_CARRIAGE_RETURN)) {
            QName typeName;
            StartElement start = e.asStartElement();
            Attribute a = start.getAttributeByName(typeName = XMLEventHelpers.createQName(LOCAL_TYPE, start.getName()));
            if (a == null) {
                return true;
            }
            String type = a.getValue();
            if (!type.equals("page") && !type.equals("column")) {
                return true;
            }
        }
        return false;
    }

    static boolean isPageBreak(StartElement startElement) {
        QName name = startElement.getName();
        if (!LOCAL_BREAK.equals(name.getLocalPart())) {
            return false;
        }
        QName typeName = new QName(name.getNamespaceURI(), LOCAL_TYPE);
        return "page".equals(XMLEventHelpers.getAttributeValue(startElement, typeName));
    }

    static boolean isTextPath(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_TEXTPATH);
    }

    static boolean isGraphicsProperty(XMLEvent e) {
        return XMLEventHelpers.isStartElement(e, LOCAL_DRAWING_PROPERTY) || XMLEventHelpers.isStartElement(e, LOCAL_GRAPHICS_PROPERTY);
    }

    static boolean isStartElement(XMLEvent e, StartElement correspondingStartElement) {
        return e.isStartElement() && e.asStartElement().getName().equals(correspondingStartElement.getName());
    }

    static boolean isStartElement(XMLEvent e, String expectedLocalPart) {
        return e.isStartElement() && expectedLocalPart.equals(e.asStartElement().getName().getLocalPart());
    }

    static boolean isEndElement(XMLEvent e, StartElement correspondingStartElement) {
        return e.isEndElement() && e.asEndElement().getName().equals(correspondingStartElement.getName());
    }

    static boolean isEndElement(XMLEvent e, String expectedLocalPart) {
        return e.isEndElement() && expectedLocalPart.equals(e.asEndElement().getName().getLocalPart());
    }

    static boolean hasPreserveWhitespace(StartElement e) {
        return "preserve".equals(XMLEventHelpers.getAttributeValue(e, ATTR_XML_SPACE));
    }

    static boolean isWhitespace(XMLEvent e) {
        return e.isCharacters() && e.asCharacters().getData().trim().isEmpty();
    }

    static String getAttributeValue(StartElement el, QName name) {
        return XMLEventHelpers.getAttributeValue(el, name, null);
    }

    static String getAttributeValue(StartElement el, QName name, String defaultValue) {
        Attribute attr = el.getAttributeByName(name);
        return attr != null ? attr.getValue() : defaultValue;
    }

    static boolean getBooleanAttributeValue(StartElement element, QName name, boolean defaultValue) {
        Attribute attribute = element.getAttributeByName(name);
        if (null == attribute) {
            return defaultValue;
        }
        return BOOLEAN_ATTRIBUTE_TRUE_VALUES.contains(attribute.getValue());
    }

    static Set<String> booleanAttributeFalseValues() {
        return BOOLEAN_ATTRIBUTE_FALSE_VALUES;
    }

    static Set<String> booleanAttributeTrueValues() {
        return BOOLEAN_ATTRIBUTE_TRUE_VALUES;
    }

    static QName createQName(String localPart, QName modelName) {
        return new QName(modelName.getNamespaceURI(), localPart, modelName.getPrefix());
    }

    static List<XMLEvent> gatherEvents(StartElementContext startElementContext) throws XMLStreamException {
        ArrayList<XMLEvent> p = new ArrayList<XMLEvent>();
        p.add(startElementContext.getStartElement());
        while (startElementContext.getEventReader().hasNext()) {
            XMLEvent e = startElementContext.getEventReader().nextEvent();
            p.add(e);
            if (!XMLEventHelpers.isEndElement(e, startElementContext.getStartElement())) continue;
            return p;
        }
        throw new IllegalStateException("Unterminated start element: " + XMLEventSerializer.serialize(startElementContext.getStartElement()));
    }

    static List<XMLEvent> eventsFor(StartElement startElement, XMLEventReader reader) throws XMLStreamException {
        LinkedList<XMLEvent> events = new LinkedList<XMLEvent>();
        events.add(startElement);
        while (reader.hasNext()) {
            XMLEvent e = reader.nextEvent();
            events.add(e);
            if (!e.isEndElement() || !e.asEndElement().getName().equals(startElement.getName())) continue;
            break;
        }
        return events;
    }

    static boolean eventEquals(List<XMLEvent> e1, List<XMLEvent> e2) {
        if (e1.size() != e2.size()) {
            return false;
        }
        for (int i = 0; i < e1.size(); ++i) {
            if (XMLEventHelpers.eventEquals(e1.get(i), e2.get(i))) continue;
            return false;
        }
        return true;
    }

    static boolean eventEquals(XMLEvent e1, XMLEvent e2) {
        if (e1.getEventType() != e2.getEventType()) {
            return false;
        }
        switch (e1.getEventType()) {
            case 1: {
                return XMLEventHelpers.startElementEquals(e1.asStartElement(), e2.asStartElement());
            }
            case 2: {
                return e1.asEndElement().getName().equals(e2.asEndElement().getName());
            }
            case 4: {
                return e1.asCharacters().getData().equals(e2.asCharacters().getData());
            }
        }
        return true;
    }

    static boolean startElementEquals(StartElement e1, StartElement e2) {
        return e1.getName().equals(e2.getName()) && XMLEventHelpers.attrEquals(e1, e2);
    }

    static boolean attrEquals(StartElement e1, StartElement e2) {
        List<Attribute> a1 = XMLEventHelpers.attributesToList(e1);
        List<Attribute> a2 = XMLEventHelpers.attributesToList(e2);
        if (a1.size() != a2.size()) {
            return false;
        }
        for (Attribute a : a1) {
            boolean foundMatch = false;
            for (Attribute test : a2) {
                if (!XMLEventHelpers.attrEquals(a, test)) continue;
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            return false;
        }
        return true;
    }

    static List<Attribute> attributesToList(StartElement el) {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        Iterator<Attribute> it = el.getAttributes();
        while (it.hasNext()) {
            attrs.add(it.next());
        }
        return attrs;
    }

    static boolean attrEquals(Attribute a1, Attribute a2) {
        return Objects.equals(a1.getName(), a2.getName()) && Objects.equals(a1.getValue(), a2.getValue());
    }

    static void addChunksToList(List<XMLEvent> list, List<Chunk> chunks) {
        for (XMLEvents xMLEvents : chunks) {
            list.addAll(xMLEvents.getEvents());
        }
    }

    static {
        BOOLEAN_ATTRIBUTE_FALSE_VALUES.add(BooleanAttributeValue.FALSE_STRING.toString());
        BOOLEAN_ATTRIBUTE_FALSE_VALUES.add(BooleanAttributeValue.FALSE_INTEGER.toString());
        BOOLEAN_ATTRIBUTE_TRUE_VALUES = new LinkedHashSet<String>(2);
        BOOLEAN_ATTRIBUTE_TRUE_VALUES.add(BooleanAttributeValue.TRUE_STRING.toString());
        BOOLEAN_ATTRIBUTE_TRUE_VALUES.add(BooleanAttributeValue.TRUE_INTEGER.toString());
        DEFAULT_BOOLEAN_ATTRIBUTE_TRUE_VALUE = Boolean.valueOf(BooleanAttributeValue.TRUE_STRING.toString());
        DEFAULT_BOOLEAN_ATTRIBUTE_FALSE_VALUE = Boolean.valueOf(BooleanAttributeValue.FALSE_STRING.toString());
    }

    static enum BooleanAttributeValue {
        FALSE_INTEGER("0"),
        TRUE_INTEGER("1"),
        FALSE_STRING("false"),
        TRUE_STRING("true");

        private final String value;

        private BooleanAttributeValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

