/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.subtitles;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SplitCaption
implements Iterable<ArrayList<String>> {
    private ArrayList<ArrayList<String>> captions;
    private final boolean dontSplitWords;
    private final int trueMaxChar;

    private SplitCaption(boolean dontSplitWords, int trueMaxChar) {
        this.dontSplitWords = dontSplitWords;
        this.trueMaxChar = trueMaxChar;
        this.captions = new ArrayList();
    }

    private SplitCaption(String s, int maxLine, int maxChar, int widthPerCaption, int numCaptions, boolean dontSplitWords, int trueMaxChar) {
        this(dontSplitWords, trueMaxChar);
        for (String caption : SplitCaption.splitEqually(s, numCaptions)) {
            this.addAndSplitCaption(caption, maxLine, maxChar, false);
        }
    }

    private int numCaptions() {
        return this.captions.size();
    }

    private void addAndSplitCaptionDontSplitWords(String s, int maxLine, boolean attemptMinFill) {
        int maxChar = SplitCaption.minParts(s, maxLine);
        if (attemptMinFill) {
            maxChar = this.trueMaxChar;
        }
        ArrayList<String> caption = new ArrayList<String>();
        String[] captionWords = s.split("\\s+");
        int indexCaptionWords = 0;
        do {
            StringBuilder line = new StringBuilder();
            while (indexCaptionWords < captionWords.length) {
                line.append(captionWords[indexCaptionWords]);
                if (line.length() > maxChar || ++indexCaptionWords == captionWords.length) break;
                line.append(" ");
            }
            caption.add(line.toString());
        } while (indexCaptionWords != captionWords.length);
        if (!attemptMinFill && caption.size() < maxLine) {
            this.addAndSplitCaptionDontSplitWords(s, maxLine, true);
            return;
        }
        this.captions.add(caption);
    }

    private void addAndSplitCaption(String s, int maxLine, int maxChar, boolean attemptMaxFill) {
        if (this.dontSplitWords) {
            this.addAndSplitCaptionDontSplitWords(s, maxLine, false);
            return;
        }
        ArrayList<String> caption = new ArrayList<String>();
        String[] captionWords = s.split("\\s+");
        int indexCaptionWords = 0;
        int averageLengthPerLine = s.length() / maxLine;
        do {
            StringBuilder line = new StringBuilder();
            int lastWordIndex = 0;
            while (indexCaptionWords < captionWords.length) {
                line.append(captionWords[indexCaptionWords]);
                if (!attemptMaxFill && line.length() > averageLengthPerLine || line.length() > maxChar || ++indexCaptionWords == captionWords.length) break;
                lastWordIndex = line.length();
                line.append(" ");
            }
            if (line.length() > maxChar) {
                if (lastWordIndex == 0 || caption.size() == maxLine - 1) {
                    this.addEqually(s, maxChar, maxLine);
                    return;
                }
                --indexCaptionWords;
                line.delete(lastWordIndex, line.length());
            }
            caption.add(line.toString());
        } while (indexCaptionWords != captionWords.length);
        if (indexCaptionWords == captionWords.length) {
            this.captions.add(caption);
            return;
        }
        if (!attemptMaxFill) {
            this.addAndSplitCaption(s, maxLine, maxChar, true);
            return;
        }
        this.addEqually(s, maxChar, maxLine);
    }

    private void addEqually(String s, int maxChar, int maxLine) {
        this.captions.add(SplitCaption.splitEquallyIntoMinParts(s, maxChar, maxLine));
    }

    @Override
    public Iterator<ArrayList<String>> iterator() {
        return new Iterator<ArrayList<String>>(){
            int current = 0;

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The method remove() not supported.");
            }

            @Override
            public ArrayList<String> next() {
                if (this.current >= SplitCaption.this.captions.size()) {
                    throw new NoSuchElementException("No more content parts.");
                }
                return SplitCaption.this.captions.get(this.current++);
            }

            @Override
            public boolean hasNext() {
                return this.current < SplitCaption.this.captions.size();
            }
        };
    }

    private static ArrayList<String> splitEquallyIntoMinParts(String s, int maxChar, int maxParts) {
        return SplitCaption.splitEqually(s, Math.min(maxParts, SplitCaption.minParts(s, maxChar)));
    }

    private static ArrayList<String> splitEqually(String s, int parts) {
        int increment;
        int maxChar = s.length() / parts;
        int modLength = SplitCaption.modLength(s, parts);
        ArrayList<String> result = new ArrayList<String>();
        for (int index = 0; index < s.length(); index += increment) {
            increment = maxChar;
            if (modLength > 0) {
                ++increment;
                --modLength;
            }
            result.add(s.substring(index, Math.min(index + increment, s.length())).trim());
        }
        while (result.size() < parts) {
            result.add("");
        }
        return result;
    }

    private static int modLength(String s, int maxLength) {
        return s.length() % maxLength;
    }

    private static int minParts(String s, int maxLength) {
        return s.length() / maxLength + (SplitCaption.modLength(s, maxLength) == 0 ? 0 : 1);
    }

    public static SplitCaption splitCaptionDontSplitWords(String wholeCaption, int numCaptions, int maxLine, int maxChar, int trueMaxChar, boolean attemptMinFill) {
        String[] captionWords = wholeCaption.split("\\s+");
        SplitCaption splitCaption = new SplitCaption(true, trueMaxChar);
        int widthPerCaption = maxLine * maxChar;
        int indexCaptionWords = 0;
        for (int i = 0; i < numCaptions; ++i) {
            StringBuilder caption = new StringBuilder();
            int lastWordIndex = 0;
            while (indexCaptionWords < captionWords.length) {
                caption.append(captionWords[indexCaptionWords]);
                if (caption.length() >= widthPerCaption || ++indexCaptionWords == captionWords.length) break;
                lastWordIndex = caption.length();
                caption.append(" ");
            }
            if (attemptMinFill && caption.length() > widthPerCaption && lastWordIndex != 0) {
                caption.delete(lastWordIndex, caption.length());
                --indexCaptionWords;
            }
            splitCaption.addAndSplitCaptionDontSplitWords(caption.toString(), maxLine, false);
        }
        if (!attemptMinFill && splitCaption.numCaptions() < numCaptions) {
            return SplitCaption.splitCaptionDontSplitWords(wholeCaption, numCaptions, maxLine, trueMaxChar, trueMaxChar, true);
        }
        return splitCaption;
    }

    public static SplitCaption splitCaption(String wholeCaption, int numCaptions, int maxLine, int maxChar, boolean attemptMaxFill, boolean attemptMinFill, boolean dontSplitWords) {
        int lenCaption = wholeCaption.length();
        int trueMaxChar = maxChar;
        if (lenCaption > numCaptions * maxLine * maxChar) {
            maxChar = SplitCaption.minParts(wholeCaption, numCaptions * maxLine);
        }
        int maxWidthPerCaption = maxLine * maxChar;
        String[] captionWords = wholeCaption.split("\\s+");
        if (captionWords.length < numCaptions) {
            return new SplitCaption(wholeCaption, maxLine, maxChar, maxWidthPerCaption, numCaptions, dontSplitWords, trueMaxChar);
        }
        SplitCaption splitCaption = new SplitCaption(dontSplitWords, trueMaxChar);
        int indexCaptionWords = 0;
        int captionLengthLeft = lenCaption;
        for (int i = 0; i < numCaptions; ++i) {
            if (indexCaptionWords == captionWords.length) {
                if (attemptMinFill) {
                    return new SplitCaption(wholeCaption, maxLine, maxChar, maxWidthPerCaption, numCaptions, dontSplitWords, trueMaxChar);
                }
                return SplitCaption.splitCaption(wholeCaption, numCaptions, maxLine, maxChar, attemptMaxFill, true, dontSplitWords);
            }
            int widthPerCaption = captionLengthLeft / (numCaptions - i);
            widthPerCaption = Math.min(widthPerCaption, maxWidthPerCaption);
            StringBuilder caption = new StringBuilder();
            int lastWordIndex = 0;
            while (indexCaptionWords < captionWords.length) {
                caption.append(captionWords[indexCaptionWords]);
                if (!attemptMaxFill && caption.length() >= widthPerCaption || caption.length() >= maxWidthPerCaption || ++indexCaptionWords == captionWords.length) break;
                lastWordIndex = caption.length();
                caption.append(" ");
            }
            if (caption.length() > maxWidthPerCaption) {
                if (lastWordIndex == 0 || splitCaption.numCaptions() == numCaptions - 1) {
                    if (dontSplitWords) {
                        return SplitCaption.splitCaptionDontSplitWords(wholeCaption, numCaptions, maxLine, maxChar, trueMaxChar, false);
                    }
                    return new SplitCaption(wholeCaption, maxLine, maxChar, maxWidthPerCaption, numCaptions, dontSplitWords, trueMaxChar);
                }
                caption.delete(lastWordIndex, caption.length());
                --indexCaptionWords;
            }
            if (attemptMinFill && caption.length() > widthPerCaption && lastWordIndex != 0) {
                caption.delete(lastWordIndex, caption.length());
                --indexCaptionWords;
            }
            splitCaption.addAndSplitCaption(caption.toString(), maxLine, maxChar, false);
            captionLengthLeft -= caption.length();
        }
        if (indexCaptionWords == captionWords.length) {
            return splitCaption;
        }
        if (attemptMaxFill) {
            return new SplitCaption(wholeCaption, maxLine, maxChar, maxWidthPerCaption, numCaptions, dontSplitWords, trueMaxChar);
        }
        return SplitCaption.splitCaption(wholeCaption, numCaptions, maxLine, maxChar, true, attemptMinFill, dontSplitWords);
    }
}

