/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.subtitles;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.SpinInputPart;
import net.sf.okapi.common.uidescription.TextInputPart;

public class SubtitleParameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String TIMEFORMAT = "timeFormat";
    private static final String MAXLINESPERCAPTION = "maxLinesPerCaption";
    private static final String MAXCHARSPERLINE = "maxCharsPerLine";
    private static final String CJKCHARSPERLINE = "cjkCharsPerLine";
    private static final String KEEPTIMECODES = "keepTimecodes";
    private static final String SPLITWORDS = "splitWords";

    public String getTimeFormat() {
        return this.getString(TIMEFORMAT);
    }

    public void setTimeFormat(String timeFormat) {
        this.setString(TIMEFORMAT, timeFormat);
    }

    public int getMaxLinesPerCaption() {
        return this.getInteger(MAXLINESPERCAPTION);
    }

    public void setMaxLinesPerCaption(int maxLinesPerCaption) {
        this.setInteger(MAXLINESPERCAPTION, maxLinesPerCaption);
    }

    public int getMaxCharsPerLine() {
        return this.getInteger(MAXCHARSPERLINE);
    }

    public void setMaxCharsPerLine(int maxCharsPerLine) {
        this.setInteger(MAXCHARSPERLINE, maxCharsPerLine);
    }

    public int getCjkCharsPerLine() {
        return this.getInteger(CJKCHARSPERLINE);
    }

    public void setCjkCharsPerLine(int cjkCharsPerLine) {
        this.setInteger(CJKCHARSPERLINE, cjkCharsPerLine);
    }

    public boolean getKeepTimecodes() {
        return this.getBoolean(KEEPTIMECODES);
    }

    public void setKeepTimecodes(boolean keepTimecodes) {
        this.setBoolean(KEEPTIMECODES, keepTimecodes);
    }

    public boolean getSplitWords() {
        return this.getBoolean(SPLITWORDS);
    }

    public void setSplitWords(boolean splitWords) {
        this.setBoolean(SPLITWORDS, splitWords);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(KEEPTIMECODES, "Keep timecodes", null);
        desc.add(TIMEFORMAT, "Time format", null);
        desc.add(MAXCHARSPERLINE, "Max characters per line", null);
        desc.add(MAXLINESPERCAPTION, "Max lines per caption", null);
        desc.add(CJKCHARSPERLINE, "Max characters per line for CJK", null);
        desc.add(SPLITWORDS, "Split words so that they don't go over the char limit", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        return this.createEditorDescription("Subtitle Filter Parameters", paramDesc);
    }

    protected EditorDescription createEditorDescription(String caption, ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription(caption, true, false);
        CheckboxPart cp = desc.addCheckboxPart(paramDesc.get(KEEPTIMECODES));
        TextInputPart tip = desc.addTextInputPart(paramDesc.get(TIMEFORMAT));
        tip.setAllowEmpty(false);
        SpinInputPart sip = desc.addSpinInputPart(paramDesc.get(MAXLINESPERCAPTION));
        sip.setRange(1, 9999999);
        sip = desc.addSpinInputPart(paramDesc.get(MAXCHARSPERLINE));
        sip.setRange(1, 9999999);
        sip = desc.addSpinInputPart(paramDesc.get(CJKCHARSPERLINE));
        sip.setRange(1, 9999999);
        cp = desc.addCheckboxPart(paramDesc.get(SPLITWORDS));
        return desc;
    }
}

