/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.table.csv;

import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.filters.table.csv.Parameters;

public class CSVSkeletonWriter
extends GenericSkeletonWriter {
    Parameters params = new Parameters();

    @Override
    public String processStartDocument(LocaleId outputLocale, String outputEncoding, EncoderManager encoderManager, StartDocument resource) {
        IParameters params = resource.getFilterParameters();
        if (params instanceof net.sf.okapi.filters.table.Parameters) {
            params = ((net.sf.okapi.filters.table.Parameters)params).getActiveParameters();
        }
        this.params = (Parameters)params;
        return super.processStartDocument(outputLocale, outputEncoding, encoderManager, resource);
    }

    private void escapeQualifiers(TextContainer tc) {
        if (tc.getUnSegmentedContentCopy().toText().contains(this.params.textQualifier)) {
            switch (this.params.escapingMode) {
                case 1: {
                    block4: for (TextPart tp : tc.getParts()) {
                        TextFragment pf = tp.getContent();
                        int i = 0;
                        while (i < pf.length()) {
                            String pt = pf.toString();
                            if (!this.params.removeQualifiers && tc.getParts().get(0).equals(tp) && i == 0) {
                                ++i;
                                continue;
                            }
                            if (!this.params.removeQualifiers && tc.getParts().get(tc.getParts().size() - 1).equals(tp) && i == pt.length() - 1) continue block4;
                            if (pt.substring(i).startsWith(this.params.textQualifier)) {
                                if (i == pt.length() - 1) {
                                    pf.insert(i, this.params.textQualifier);
                                    continue block4;
                                }
                                if (pt.substring(i + this.params.textQualifier.length()).startsWith(this.params.textQualifier)) {
                                    i += 2 * this.params.textQualifier.length();
                                    continue;
                                }
                                pf.insert(i, this.params.textQualifier);
                                i += 2 * this.params.textQualifier.length();
                                continue;
                            }
                            ++i;
                        }
                    }
                    break;
                }
                case 2: {
                    block6: for (TextPart tp : tc.getParts()) {
                        TextFragment pf = tp.getContent();
                        int i = 0;
                        while (i < pf.length()) {
                            String pt = pf.toString();
                            if (!this.params.removeQualifiers && tc.getParts().get(0).equals(tp) && i == 0) {
                                ++i;
                                continue;
                            }
                            if (!this.params.removeQualifiers && tc.getParts().get(tc.getParts().size() - 1).equals(tp) && i == pt.length() - 1) continue block6;
                            if (pt.substring(i).startsWith(this.params.textQualifier)) {
                                if (i == 0) {
                                    pf.insert(0, "\\");
                                    i += 1 + this.params.textQualifier.length();
                                    continue;
                                }
                                if (pt.charAt(i - 1) == '\\') {
                                    i += this.params.textQualifier.length();
                                    continue;
                                }
                                pf.insert(i, "\\");
                                i += 1 + this.params.textQualifier.length();
                                continue;
                            }
                            ++i;
                        }
                    }
                    break;
                }
            }
        }
    }

    @Override
    public String processTextUnit(ITextUnit tu) {
        boolean isTarget = tu.hasTarget(this.outputLoc);
        TextContainer tc = isTarget ? tu.getTarget(this.outputLoc) : tu.getSource();
        if (tc == null) {
            return super.processTextUnit(tu);
        }
        TextFragment tf = tc.getUnSegmentedContentCopy();
        String text = tf.toText();
        if (tu.hasProperty("qualified") && "yes".equals(tu.getProperty("qualified").getValue())) {
            this.escapeQualifiers(tc);
            return super.processTextUnit(tu);
        }
        if (!this.params.addQualifiers) {
            return super.processTextUnit(tu);
        }
        if (text.contains(this.params.fieldDelimiter) || text.contains("\n")) {
            this.escapeQualifiers(tc);
            if (tc.hasBeenSegmented()) {
                tc.insert(0, new TextPart(this.params.textQualifier));
                tc.append(new TextPart(this.params.textQualifier));
            } else {
                tf.insert(0, new TextFragment(this.params.textQualifier));
                tf.append(this.params.textQualifier);
                tc.setContent(tf);
            }
            tu.setProperty(new Property("qualified", "yes", Property.FILTER_AND_DISPLAY));
        }
        return super.processTextUnit(tu);
    }
}

