/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.ttml;

import java.io.IOException;
import java.util.Iterator;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StreamedSource;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.subtitles.SubtitleFilter;
import net.sf.okapi.filters.ttml.TTMLParameters;
import net.sf.okapi.filters.ttml.TTMLSkeletonPart;
import net.sf.okapi.filters.ttml.TTMLSkeletonWriter;

@UsingParameters(value=TTMLParameters.class)
public class TTMLFilter
extends SubtitleFilter {
    public static final String FILTER_NAME = "okf_ttml";
    public static final String FILTER_MIME = "application/ttml+xml";
    private static final String ELEM_METADATA = "metadata";
    private static final String ELEM_MAX_CHAR = "okp:maximum_character_count";
    private static final String ELEM_MAX_LINE = "okp:maximum_line_count";
    private static final String ELEM_CAPTION = "p";
    private static final String ELEM_LINE_BREAK = "br";
    public static final String ATTR_TIME_BEGIN = "begin";
    public static final String ATTR_TIME_END = "end";
    private static final String TERMINAL_REGEX = "[.\uff0e\u3002!\uff01?\uff1f\u061f\uff1f][^a-zA-Z0-9]*$";
    private StreamedSource document;
    private Iterator<Segment> nodeIterator;
    private boolean isInsideMetadata = false;
    private boolean isInsideCaption = false;

    public TTMLFilter() {
        this.setName(FILTER_NAME);
        this.setDisplayName("TTML Filter");
        this.setMimeType(FILTER_MIME);
        this.setParameters(new TTMLParameters());
        this.addConfiguration(new FilterConfiguration(this.getName(), FILTER_MIME, this.getClass().getName(), "TTML", "TTML Documents", "okf_ttml.fprm", ".ttml"));
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (TTMLParameters)params;
    }

    @Override
    public TTMLParameters getParameters() {
        return (TTMLParameters)this.params;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new TTMLSkeletonWriter();
    }

    @Override
    public void close() {
        super.close();
        try {
            if (this.document != null) {
                this.document.close();
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Could not close " + this.getDocumentName(), e);
        }
        this.document = null;
        this.LOGGER.debug("{} has been closed", (Object)this.getDocumentName());
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        super.open(input, generateSkeleton);
        try {
            if (this.document != null) {
                this.document.close();
            }
            this.document = new StreamedSource(input.getReader());
            this.nodeIterator = this.document.iterator();
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        this.loadMaxWidthFromConfig();
    }

    private void loadMaxWidthFromConfig() {
        this.maxChar = this.params.getMaxCharsPerLine();
        this.maxLine = this.params.getMaxLinesPerCaption();
    }

    private boolean updateMaxChar(String n) {
        try {
            this.maxChar = Integer.parseInt(n);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean updateMaxLine(String n) {
        try {
            this.maxLine = Integer.parseInt(n);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public boolean hasNext() {
        return this.eventBuilder.hasNext();
    }

    @Override
    public Event next() {
        if (this.eventBuilder.hasQueuedEvents()) {
            return this.eventBuilder.next();
        }
        while (this.nodeIterator.hasNext() && !this.isCanceled()) {
            StartTag tag;
            Segment segment = this.nodeIterator.next();
            if (segment instanceof StartTag) {
                tag = (StartTag)segment;
                this.handleStartTag(tag);
            } else if (segment instanceof EndTag) {
                tag = (EndTag)segment;
                this.handleEndTag((EndTag)tag);
            } else {
                this.addString(segment.toString());
            }
            if (!this.eventBuilder.hasQueuedEvents()) continue;
            break;
        }
        if (!this.nodeIterator.hasNext()) {
            this.endFilter();
        }
        return this.eventBuilder.next();
    }

    private void handleStartTag(StartTag tag) {
        switch (tag.getName()) {
            case "metadata": {
                if (!this.isInsideTextRun()) {
                    this.isInsideMetadata = true;
                }
                this.addString(tag.toString());
                break;
            }
            case "okp:maximum_character_count": {
                this.addString(tag.toString());
                if (!this.isInsideMetadata) break;
                String maxChar = this.nodeIterator.next().toString();
                this.updateMaxChar(maxChar);
                this.addString(maxChar);
                break;
            }
            case "okp:maximum_line_count": {
                this.addString(tag.toString());
                if (!this.isInsideMetadata) break;
                String maxLine = this.nodeIterator.next().toString();
                this.updateMaxLine(maxLine);
                this.addString(maxLine);
                break;
            }
            case "p": {
                if (!this.isInsideTextRun()) {
                    this.eventBuilder.startTextUnit();
                }
                Attribute begin = tag.getAttributes().get(ATTR_TIME_BEGIN);
                Attribute end = tag.getAttributes().get(ATTR_TIME_END);
                this.appendToSkeleton(tag.toString(), begin.getBegin() - tag.getBegin(), begin.getEnd() - tag.getBegin(), end.getBegin() - tag.getBegin(), end.getEnd() - tag.getBegin());
                this.addCaptionAnnotation(begin.getValue(), end.getValue());
                this.isInsideCaption = true;
                break;
            }
            case "br": {
                if (this.isInsideTextRun()) break;
                this.addString(tag.toString());
                break;
            }
            default: {
                this.addString(tag.toString());
            }
        }
    }

    private void handleEndTag(EndTag tag) {
        switch (tag.getName()) {
            case "metadata": {
                if (!this.isInsideTextRun()) {
                    this.isInsideMetadata = false;
                }
                this.addString(tag.toString());
                break;
            }
            case "p": {
                String captionText;
                this.isInsideCaption = false;
                this.addString(tag.toString());
                if (!this.isInsideTextRun() || !(captionText = this.eventBuilder.peekMostRecentTextUnit().getSource().getFirstContent().getText()).isEmpty() && !this.endsWithPunctuation(captionText)) break;
                this.eventBuilder.endTextUnit();
                break;
            }
            default: {
                this.addString(tag.toString());
            }
        }
    }

    private void appendToSkeleton(String text, int startBeginTime, int endBeginTime, int startEndTime, int endEndTime) {
        this.eventBuilder.appendToSkeleton(new TTMLSkeletonPart(text, startBeginTime, endBeginTime, startEndTime, endEndTime));
    }

    private void appendToSkeleton(String text) {
        this.eventBuilder.appendToSkeleton(new TTMLSkeletonPart(text));
    }

    @Override
    protected void addString(String string) {
        if (this.isInsideTextRun()) {
            if (this.isInsideCaption) {
                this.addToTextUnit(string);
            } else {
                this.appendToSkeleton(string);
            }
        } else {
            this.addToDocumentPart(string);
        }
    }

    @Override
    protected String getTerminalRegex() {
        return TERMINAL_REGEX;
    }
}

