/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.vtt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.subtitles.SubtitleFilter;
import net.sf.okapi.filters.vtt.VTTParameters;
import net.sf.okapi.filters.vtt.VTTSkeletonPart;
import net.sf.okapi.filters.vtt.VTTSkeletonWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=VTTParameters.class)
public class VTTFilter
extends SubtitleFilter {
    public static final String FILTER_NAME = "okf_vtt";
    public static final String FILTER_MIME = "text/vtt";
    public static final String HEADER_REGEX = "^(.+)\\s+-->\\s+(.+?)($|\\s+)(.*)";
    public static final Pattern HEADER_PATTERN = Pattern.compile("^(.+)\\s+-->\\s+(.+?)($|\\s+)(.*)");
    private static final String TERMINAL_REGEX = "([.\uff0e\u3002!\uff01?\uff1f\u061f\uff1f][^a-zA-Z0-9]*|</ ?v>)$";
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private BufferedReader reader;
    private boolean captionHasEnded = false;

    public VTTFilter() {
        this.setName(FILTER_NAME);
        this.setDisplayName("VTT Filter");
        this.setMimeType(FILTER_MIME);
        this.setParameters(new VTTParameters());
        this.addConfiguration(new FilterConfiguration(this.getName(), FILTER_MIME, this.getClass().getName(), "VTT", "VTT Documents", "okf_vtt.fprm", ".vtt;.srt"));
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (VTTParameters)params;
    }

    @Override
    public VTTParameters getParameters() {
        return (VTTParameters)this.params;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new VTTSkeletonWriter();
    }

    @Override
    public void close() {
        super.close();
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Could not close " + this.getDocumentName(), e);
        }
        this.LOGGER.debug("{} has been closed", (Object)this.getDocumentName());
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        super.open(input, generateSkeleton);
        this.reader = VTTFilter.getBufferedReader(input.getReader());
    }

    private static BufferedReader getBufferedReader(Reader inputReader) {
        if (inputReader instanceof BufferedReader) {
            return (BufferedReader)inputReader;
        }
        return new BufferedReader(inputReader);
    }

    @Override
    public Event next() {
        if (this.eventBuilder.hasQueuedEvents()) {
            return this.eventBuilder.next();
        }
        String line = null;
        try {
            while (!this.isCanceled() && (line = this.reader.readLine()) != null) {
                Matcher matcher = HEADER_PATTERN.matcher(line);
                if (matcher.find()) {
                    if (!this.eventBuilder.isInsideTextRun()) {
                        this.eventBuilder.startTextUnit();
                    }
                    this.addCaptionAnnotation(matcher.group(1), matcher.group(2));
                    this.appendToSkeleton(line, true);
                    this.captionHasEnded = false;
                } else if (this.eventBuilder.isInsideTextRun()) {
                    if (line.trim().isEmpty()) {
                        String captionText = this.eventBuilder.peekMostRecentTextUnit().getSource().getFirstContent().getText();
                        if (captionText.isEmpty() || this.endsWithPunctuation(captionText)) {
                            this.eventBuilder.endTextUnit();
                            this.addToDocumentPart(line);
                            this.addToDocumentPart(this.getNewlineType());
                        } else {
                            this.captionHasEnded = true;
                            this.appendToSkeleton(line, false);
                        }
                    } else if (this.captionHasEnded) {
                        this.appendToSkeleton(line, false);
                    } else {
                        this.addToTextUnit(line);
                    }
                } else {
                    this.addToDocumentPart(line);
                    this.addToDocumentPart(this.getNewlineType());
                }
                if (!this.eventBuilder.hasQueuedEvents()) continue;
                break;
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Reading error", e);
        }
        if (line == null) {
            this.endFilter();
        }
        return this.eventBuilder.next();
    }

    private void appendToSkeleton(String text, boolean isHeader) {
        this.eventBuilder.appendToSkeleton(new VTTSkeletonPart(text, isHeader));
    }

    @Override
    protected String getTerminalRegex() {
        return TERMINAL_REGEX;
    }
}

