/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.vtt;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.TextInputPart;
import net.sf.okapi.filters.subtitles.SubtitleParameters;

public class VTTParameters
extends SubtitleParameters {
    private static final String CUESETTINGS = "cueSettings";
    private static final String DISCARDCUES = "discardCues";

    public String getCueSettings() {
        return this.getString(CUESETTINGS);
    }

    public void setCueSettings(String cueSettings) {
        this.setString(CUESETTINGS, cueSettings);
    }

    public boolean getDiscardCues() {
        return this.getBoolean(DISCARDCUES);
    }

    public void setDiscardCues(boolean discardCues) {
        this.setBoolean(DISCARDCUES, discardCues);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = super.getParametersDescription();
        desc.add(CUESETTINGS, "Replace existing cue settings with text", null);
        desc.add(DISCARDCUES, "Discard existing cue settings", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = this.createEditorDescription("VTT Filter Parameters", paramDesc);
        CheckboxPart cp = desc.addCheckboxPart(paramDesc.get(DISCARDCUES));
        TextInputPart tip = desc.addTextInputPart(paramDesc.get(CUESETTINGS));
        tip.setAllowEmpty(true);
        tip.setMasterPart(cp, false);
        return desc;
    }
}

