/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xini.rainbowkit;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.DefaultParameters;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.xini.rainbowkit.XINIRainbowkitReader;
import net.sf.okapi.filters.xini.rainbowkit.XINIRainbowkitWriter;

public class XINIRainbowkitFilter
implements IFilter {
    private EncoderManager encoderManager;
    private XINIRainbowkitReader reader;
    private LinkedList<Event> queue = new LinkedList();
    private String relDocName;
    private DefaultParameters params;
    private IFilterConfigurationMapper fcMapper;

    public XINIRainbowkitFilter() {
    }

    public XINIRainbowkitFilter(String relDocName) {
        this();
        this.relDocName = relDocName;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void close() {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    @Override
    public String getName() {
        return "okf_rainbowkitxini";
    }

    @Override
    public String getDisplayName() {
        return "XINI RainbowKit Filter";
    }

    @Override
    public String getMimeType() {
        return "text/x-xini";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "text/x-xini", this.getClass().getName(), "XINI (Rainbow T-Kit)", "Configuration for XINI documents from ONTRAM T-Kits.", null));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("text/x-xini", "net.sf.okapi.common.encoder.XMLEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public Event next() {
        return this.queue.poll();
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.close();
        this.reader = new XINIRainbowkitReader();
        this.reader.setTargetLocale(input.getTargetLocales().get(0));
        this.reader.open(input);
        this.queue.addAll(this.reader.getFilterEvents(this.relDocName));
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (DefaultParameters)params;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new XINIRainbowkitWriter();
    }
}

