/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.yaml;

import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.YamlEncoder;
import net.sf.okapi.common.encoder.YamlScalarTypes;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snakeyaml.engine.v2.common.FlowStyle;

public class YamlSkeletonWriter
extends GenericSkeletonWriter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Property scalarType;
    private Property scalarFlow;
    private Property scalarParentIndent;
    private boolean flow;
    private int fullIndent;
    private FlowStyle flowStyle;
    private boolean wrap;

    public YamlSkeletonWriter(boolean wrap) {
        this.wrap = wrap;
        this.flowStyle = FlowStyle.AUTO;
        this.flow = false;
    }

    @Override
    public String processTextUnit(ITextUnit resource) {
        TextUnitUtil.unsegmentTU(resource);
        if (resource.hasProperty("Scalar Type")) {
            this.scalarType = resource.getProperty("Scalar Type");
            this.scalarFlow = resource.getProperty("Scalar Flow");
            this.scalarParentIndent = resource.getProperty("Parent Scalar Indent");
            this.flow = this.scalarFlow.getBoolean();
            this.fullIndent = Integer.parseInt(this.scalarParentIndent.getValue());
            this.flowStyle = this.flow ? FlowStyle.FLOW : FlowStyle.BLOCK;
        }
        this.getEncoderManager().updateEncoder("text/x-yaml");
        YamlEncoder encoder = (YamlEncoder)this.getEncoderManager().getEncoder();
        encoder.setScalarType(YamlScalarTypes.valueOf(this.scalarType.getValue()));
        TextFragment text = resource.getSource().getFirstContent();
        for (Code code : text.getCodes()) {
            code.setData(encoder.encode(code.getData(), EncoderContext.INLINE));
            String codeDisplayText = code.getDisplayText();
            if (codeDisplayText == null) continue;
            code.setDisplayText(encoder.encode(codeDisplayText, EncoderContext.INLINE));
        }
        String encoded = super.processTextUnit(resource);
        encoded = encoded.replaceAll("\r\n", "\n").replaceAll("\r", "\n").replaceAll("\n", this.getEncoderManager().getLineBreak());
        this.flowStyle = FlowStyle.AUTO;
        this.flow = false;
        this.fullIndent = 0;
        return encoded;
    }
}

