/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.merge.step;

import com.gc.iotools.stream.is.InputStreamFromOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.exceptions.OkapiFilterCreationException;
import net.sf.okapi.common.exceptions.OkapiMergeException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import net.sf.okapi.lib.merge.merge.SkeletonMergerWriter;
import net.sf.okapi.lib.merge.step.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class OriginalDocumentXliffMergerStep
extends BasePipelineStep {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IFilter filter;
    SkeletonMergerWriter skelMergerWriter;
    private IFilterConfigurationMapper fcMapper;
    private String outputEncoding;
    private RawDocument originalDocument;
    private Parameters params = new Parameters();

    public OriginalDocumentXliffMergerStep() {
        this.skelMergerWriter = new SkeletonMergerWriter();
    }

    @Override
    public String getName() {
        return "Original Document Xliff Merger";
    }

    @Override
    public String getDescription() {
        return "Tkit merger which re-filters the original source file to provide the skeleton for merging.";
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_ENCODING)
    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALES)
    public void setTargetLocales(List<LocaleId> targetLocales) {
        this.setTargetLocale(targetLocales.get(0));
    }

    @StepParameterMapping(parameterType=StepParameterType.SECOND_INPUT_RAWDOC)
    public void setSecondInput(RawDocument secondInput) {
        this.originalDocument = secondInput;
    }

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_MAPPER)
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleStartBatchItem(Event event) {
        this.filter = this.fcMapper.createFilter(this.originalDocument.getFilterConfigId(), null);
        if (this.filter == null) {
            throw new OkapiFilterCreationException(String.format("Cannot create the filter or load the configuration for '%s'", this.originalDocument.getFilterConfigId()));
        }
        this.filter.open(this.originalDocument);
        this.skelMergerWriter.setFilter(this.filter);
        this.skelMergerWriter.setOptions(this.getTargetLocale(), this.outputEncoding);
        net.sf.okapi.lib.merge.merge.Parameters parameters = this.skelMergerWriter.getParameters();
        parameters.setCopyCodeMetadata(this.params.isCopyCodeMetadata());
        this.skelMergerWriter.setParameters(parameters);
        return event;
    }

    @Override
    public Event handleEvent(Event event) {
        if (!event.isRawDocument() && !event.isStartBatchItem()) {
            return this.skelMergerWriter.handleEvent(event);
        }
        return super.handleEvent(event);
    }

    @Override
    protected Event handleRawDocument(final Event event) {
        InputStreamFromOutputStream<Void> is = new InputStreamFromOutputStream<Void>(){
            OkapiMergeException error;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void produce(OutputStream sink) {
                try (XLIFFFilter xlfFilter = new XLIFFFilter();){
                    net.sf.okapi.filters.xliff.Parameters xliffParams = new net.sf.okapi.filters.xliff.Parameters();
                    xliffParams.setPreserveSpaceByDefault(OriginalDocumentXliffMergerStep.this.params.isPreserveWhiteSpaceByDefault());
                    xlfFilter.setParameters(xliffParams);
                    OriginalDocumentXliffMergerStep.this.skelMergerWriter.setOutput(sink);
                    xlfFilter.open(event.getRawDocument());
                    while (xlfFilter.hasNext()) {
                        OriginalDocumentXliffMergerStep.this.skelMergerWriter.handleEvent(xlfFilter.next());
                    }
                }
                catch (Exception e) {
                    this.error = new OkapiMergeException("Error merging from original file", e);
                }
                finally {
                    OriginalDocumentXliffMergerStep.this.skelMergerWriter.close();
                    OriginalDocumentXliffMergerStep.this.originalDocument.close();
                }
                return null;
            }

            protected void afterClose() {
                if (this.error != null) {
                    try {
                        this.close();
                    }
                    catch (IOException e) {
                        OriginalDocumentXliffMergerStep.this.logger.error("Error closing InputStreamFromOutputStream", (Throwable)e);
                    }
                    throw this.error;
                }
            }
        };
        return new Event(EventType.RAW_DOCUMENT, new RawDocument((InputStream)is, this.outputEncoding, this.getTargetLocale()));
    }

    @Override
    public void cancel() {
    }

    @Override
    public void destroy() {
        this.skelMergerWriter.close();
        this.originalDocument.close();
    }

    public SkeletonMergerWriter getSkelMergerWriter() {
        return this.skelMergerWriter;
    }
}

