/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.serialization.filter;

import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.filters.AbstractFilter;
import net.sf.okapi.common.filters.EventBuilder;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.lib.serialization.Proto2Okapi;
import net.sf.okapi.lib.serialization.filter.Parameters;
import net.sf.okapi.proto.Event;

public class ProtoFilter
extends AbstractFilter {
    private static final String MIMETYPE = "text/x-protobuf";
    private RawDocument input;
    private EventBuilder eventBuilder;
    private boolean binary;
    private Parameters params = new Parameters();
    private InputStream inputStream;
    private Event.Builder builder;

    public ProtoFilter() {
        this.setMimeType(MIMETYPE);
        this.setMultilingual(true);
        this.setName("okf_protobuf");
        this.setDisplayName("Protobuf Filter");
        this.addConfiguration(new FilterConfiguration(this.getName(), MIMETYPE, this.getClass().getName(), "Protobuf", "Configuration for Protobuf files of various types", null, ".json;"));
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, false);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.binary = false;
        this.input = input;
        this.input.setEncoding(StandardCharsets.UTF_8);
        if (this.params.getOutput() == Parameters.PROTOBUF_OUTPUT.BINARY) {
            this.binary = true;
            this.inputStream = this.input.getStream();
        }
        if (this.eventBuilder == null) {
            this.eventBuilder = new EventBuilder(this.getParentId(), this);
        } else {
            this.eventBuilder.reset(this.getParentId(), this);
        }
        this.eventBuilder.setMimeType(MIMETYPE);
        this.eventBuilder.setPreserveWhitespace(true);
        this.builder = Event.newBuilder();
    }

    @Override
    public boolean hasNext() {
        return this.eventBuilder.hasNext();
    }

    @Override
    public net.sf.okapi.common.Event next() {
        if (this.eventBuilder.hasQueuedEvents()) {
            return this.eventBuilder.next();
        }
        if (this.params.getOutput() == Parameters.PROTOBUF_OUTPUT.BINARY) {
            net.sf.okapi.common.Event e = Proto2Okapi.toEvent(this.loadFromBinary());
            this.eventBuilder.addFilterEvent(e);
        } else if (this.params.getOutput() == Parameters.PROTOBUF_OUTPUT.JSON_LINES) {
            try (BufferedReader reader = new BufferedReader(this.input.getReader());){
                String line;
                while ((line = reader.readLine()) != null && !line.isEmpty()) {
                    net.sf.okapi.common.Event e = Proto2Okapi.toEvent(this.loadFromJson(line));
                    this.eventBuilder.addFilterEvent(e);
                    this.builder.clear();
                }
            }
            catch (IOException e) {
                throw new OkapiBadFilterInputException("Error parsing or converting JSON Event", e);
            }
        }
        return this.eventBuilder.next();
    }

    protected Event loadFromJson(String json) throws IOException {
        JsonFormat.parser().merge(json, (Message.Builder)this.builder);
        return this.builder.build();
    }

    protected Event loadFromBinary() {
        try {
            return Event.parseDelimitedFrom(this.inputStream);
        }
        catch (IOException | UnsupportedOperationException e) {
            throw new OkapiBadFilterInputException("Error parsing or converting Protobuf Events", e);
        }
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected boolean isUtf8Encoding() {
        return !this.binary;
    }

    @Override
    public void close() {
        super.close();
        if (this.input != null) {
            this.input.close();
        }
    }
}

