/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.transifex;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String SERVER = "server";
    private static final String PROJECTID = "projectId";
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private static final String PROJECTURL = "projectUrl";
    private static final String OPENSOURCE = "openSource";

    public Parameters() {
    }

    public Parameters(String initialData) {
        super(initialData);
    }

    @Override
    public void reset() {
        super.reset();
        this.setServer("http://www.transifex.net/api/2/");
        this.setProjectId("");
        this.setUser("");
        this.setPassword("");
        this.setProjectUrl("");
        this.setOpenSource(true);
    }

    public String getServer() {
        return this.getString(SERVER);
    }

    public String getServerWithoutAPI() {
        String host = this.getString(SERVER);
        if (host.endsWith("api/2/")) {
            return host.substring(0, host.length() - 6);
        }
        return host;
    }

    public void setServer(String server) {
        if (((String)server).endsWith("\\")) {
            server = ((String)server).substring(0, ((String)server).length() - 1) + "/";
        } else if (!((String)server).endsWith("/")) {
            server = (String)server + "/";
        }
        this.setString(SERVER, (String)server);
    }

    public boolean getOpenSource() {
        return this.getBoolean(OPENSOURCE);
    }

    public void setOpenSource(boolean openSource) {
        this.setBoolean(OPENSOURCE, openSource);
    }

    public String getProjectUrl() {
        return this.getString(PROJECTURL);
    }

    public void setProjectUrl(String projectUrl) {
        this.setString(PROJECTURL, projectUrl);
    }

    public String getProjectId() {
        return this.getString(PROJECTID);
    }

    public void setProjectId(String projectId) {
        this.setString(PROJECTID, projectId);
    }

    public String getUser() {
        return this.getString(USER);
    }

    public void setUser(String user) {
        this.setString(USER, user);
    }

    public String getPassword() {
        return this.getString(PASSWORD);
    }

    public void setPassword(String password) {
        this.setString(PASSWORD, password);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(SERVER, "Server URL", "Full URL of the server (e.g. http://www.transifex.net/)");
        desc.add(USER, "User name", "User name to login");
        desc.add(PASSWORD, "Password", "Password to login");
        desc.add(PROJECTID, "Project ID", "Identifier of the project (case sensitive)");
        desc.add(OPENSOURCE, "Is an open-source project", "True for open-source projects");
        desc.add(PROJECTURL, "Project Repository URL", "URL of your project repository");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Transifex Settings");
        desc.addTextInputPart(paramsDesc.get(SERVER));
        desc.addTextInputPart(paramsDesc.get(USER));
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(PASSWORD));
        tip.setPassword(true);
        desc.addTextInputPart(paramsDesc.get(PROJECTID));
        desc.addTextInputPart(paramsDesc.get(PROJECTURL));
        desc.addCheckboxPart(paramsDesc.get(OPENSOURCE));
        return desc;
    }
}

