/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.translation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.query.IQuery;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.translation.ITMQuery;
import net.sf.okapi.lib.translation.QueryUtil;
import net.sf.okapi.lib.translation.ResourceItem;

public class QueryManager
implements Iterator<QueryResult> {
    private LinkedHashMap<Integer, ResourceItem> resList;
    private ArrayList<QueryResult> results;
    private int current = -1;
    private int lastId = 0;
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private LinkedHashMap<String, String> attributes;
    private int threshold = 75;
    private int maxHits = 5;
    private int totalSegments;
    private int exactBestMatches;
    private int fuzzyBestMatches;
    private String rootDir;
    private int noQueryThreshold = 101;
    private int thresholdToFill = Integer.MAX_VALUE;
    private boolean leverageIfTargetIsEmpty = true;
    private boolean leverageIfTargetIsSameAsSource = true;
    private boolean downgradeIdenticalBestMatches = false;
    private String targetPrefix = null;
    private int thresholdToPrefix = 99;
    private boolean copySourceOnNoText = false;

    public QueryManager() {
        this.resList = new LinkedHashMap();
        this.results = new ArrayList();
        this.attributes = new LinkedHashMap();
    }

    public static boolean canLeverage(Segment srcSeg, Segment trgSeg, boolean leverageIfTargetIsEmpty, boolean leverageIfTargetIsSameAsSource) {
        if (leverageIfTargetIsEmpty) {
            if (trgSeg.text.isEmpty()) {
                return true;
            }
            if (leverageIfTargetIsSameAsSource) {
                return trgSeg.getContent().compareTo(srcSeg.text, TextFragment.CompareMode.CODE_DATA_ONLY) == 0;
            }
            return false;
        }
        return true;
    }

    public static boolean canLeverage(TextContainer srcTc, TextContainer trgTc, boolean leverageIfTargetIsEmpty, boolean leverageIfTargetIsSameAsSource) {
        if (leverageIfTargetIsEmpty) {
            if (trgTc.isEmpty()) {
                return true;
            }
            if (leverageIfTargetIsSameAsSource) {
                return srcTc.compareTo(trgTc, TextFragment.CompareMode.CODE_DATA_ONLY) == 0;
            }
            return false;
        }
        return true;
    }

    public int addResource(IQuery connector, String name) {
        assert (connector != null);
        ResourceItem ri = new ResourceItem();
        ri.query = connector;
        ri.enabled = true;
        ri.name = name;
        this.resList.put(++this.lastId, ri);
        return this.lastId;
    }

    public int addAndInitializeResource(IQuery connector, String resourceName, IParameters params) {
        int id = this.addResource(connector, resourceName);
        connector.setNoQueryThreshold(this.noQueryThreshold);
        connector.setRootDirectory(this.rootDir);
        connector.setParameters(params);
        if (this.srcLoc != null && this.trgLoc != null) {
            connector.setLanguages(this.srcLoc, this.trgLoc);
        }
        connector.open();
        for (String name : this.attributes.keySet()) {
            connector.setAttribute(name, this.attributes.get(name));
        }
        if (connector instanceof ITMQuery) {
            ((ITMQuery)connector).setThreshold(this.threshold);
            ((ITMQuery)connector).setMaximumHits(this.maxHits);
        }
        return id;
    }

    public int addAndInitializeResource(String connectorClass, String resourceName, String connectorParams) {
        IQuery conn;
        try {
            conn = (IQuery)Class.forName(connectorClass).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new OkapiException("Error creating connector.", e);
        }
        IParameters tmParams = conn.getParameters();
        if (tmParams != null) {
            tmParams.fromString(connectorParams);
        }
        return this.addAndInitializeResource(conn, resourceName == null ? conn.getName() : resourceName, tmParams);
    }

    public int addAndInitializeResource(String connectorClass, String resourceName, ClassLoader loader, String connectorParams) {
        IQuery conn;
        try {
            conn = (IQuery)Class.forName(connectorClass, true, loader).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new OkapiException("Error creating connector.", e);
        }
        IParameters tmParams = conn.getParameters();
        if (tmParams != null) {
            tmParams.fromString(connectorParams);
        }
        return this.addAndInitializeResource(conn, resourceName == null ? conn.getName() : resourceName, tmParams);
    }

    public void setEnabled(int resourceId, boolean enabled) {
        this.resList.get((Object)Integer.valueOf((int)resourceId)).enabled = enabled;
    }

    public void remove(int resourceId) {
        this.resList.remove(resourceId);
    }

    public IQuery getInterface(int resourceId) {
        return this.resList.get((Object)Integer.valueOf((int)resourceId)).query;
    }

    public ResourceItem getResource(int resourceId) {
        return this.resList.get(resourceId);
    }

    public String getName(int resourceId) {
        return this.resList.get((Object)Integer.valueOf((int)resourceId)).name;
    }

    public Map<Integer, ResourceItem> getResources() {
        return this.resList;
    }

    public void close() {
        for (ResourceItem ri : this.resList.values()) {
            ri.query.close();
        }
    }

    public List<QueryResult> getResults() {
        return this.results;
    }

    public void rewind() {
        this.current = !this.results.isEmpty() ? 0 : -1;
    }

    @Override
    public boolean hasNext() {
        if (this.current >= this.results.size()) {
            this.current = -1;
        }
        return this.current > -1;
    }

    @Override
    public QueryResult next() {
        if (this.current > -1 && this.current < this.results.size()) {
            ++this.current;
            return this.results.get(this.current - 1);
        }
        this.current = -1;
        return null;
    }

    public int query(String plainText) {
        this.results.clear();
        block0: for (int id : this.resList.keySet()) {
            ResourceItem ri = this.resList.get(id);
            if (!ri.enabled || ri.query.query(plainText) <= 0) continue;
            QueryResult res = null;
            while (ri.query.hasNext()) {
                res = ri.query.next();
                res.connectorId = id;
                if (res.getCombinedScore() < this.threshold) continue block0;
                this.results.add(res);
            }
        }
        this.results = QueryUtil.removeDuplicates(this.results);
        if (!this.results.isEmpty()) {
            this.current = 0;
        }
        return this.results.size();
    }

    public int query(TextFragment text) {
        this.results.clear();
        for (int id : this.resList.keySet()) {
            ResourceItem ri = this.resList.get(id);
            if (!ri.enabled || ri.query.query(text) <= 0) continue;
            QueryResult res = null;
            while (ri.query.hasNext() && (res = ri.query.next()).getCombinedScore() >= this.threshold) {
                res.connectorId = id;
                this.results.add(res);
            }
        }
        this.results = QueryUtil.removeDuplicates(this.results);
        if (!this.results.isEmpty()) {
            this.current = 0;
        }
        return this.results.size();
    }

    public void setAttribute(String name, String value) {
        this.attributes.put(name, value);
        for (ResourceItem ri : this.resList.values()) {
            ri.query.setAttribute(name, value);
        }
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
        for (ResourceItem ri : this.resList.values()) {
            ri.query.removeAttribute(name);
        }
    }

    public void clearAttributes() {
        this.attributes.clear();
        for (ResourceItem ri : this.resList.values()) {
            ri.query.clearAttributes();
        }
    }

    public void setLanguages(LocaleId sourceLocale, LocaleId targetLocale) {
        this.srcLoc = sourceLocale;
        this.trgLoc = targetLocale;
        for (ResourceItem ri : this.resList.values()) {
            ri.query.setLanguages(this.srcLoc, this.trgLoc);
        }
    }

    public LocaleId getSourceLanguage() {
        return this.srcLoc;
    }

    public LocaleId getTargetLanguage() {
        return this.trgLoc;
    }

    public void setThreshold(int value) {
        this.threshold = value;
        for (ResourceItem ri : this.resList.values()) {
            if (!(ri.query instanceof ITMQuery)) continue;
            ((ITMQuery)ri.query).setThreshold(this.threshold);
        }
    }

    public void setMaximumHits(int max) {
        this.maxHits = max;
        for (ResourceItem ri : this.resList.values()) {
            if (!(ri.query instanceof ITMQuery)) continue;
            ((ITMQuery)ri.query).setMaximumHits(this.maxHits);
        }
    }

    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
        for (ResourceItem ri : this.resList.values()) {
            ri.query.setRootDirectory(this.rootDir);
        }
    }

    public void setNoQueryThreshold(int noQueryThreshold) {
        this.noQueryThreshold = noQueryThreshold;
        for (ResourceItem ri : this.resList.values()) {
            ri.query.setNoQueryThreshold(this.noQueryThreshold);
        }
    }

    public void setOptions(int thresholdToFill, boolean fillIfTargetIsEmpty, boolean fillIfTargetIsSameAsSource, boolean downgradeIdenticalBestMatches, String targetPrefix, int thresholdToPrefix, boolean copySourceOnNoText) {
        this.thresholdToFill = thresholdToFill;
        this.leverageIfTargetIsEmpty = fillIfTargetIsEmpty;
        this.leverageIfTargetIsSameAsSource = fillIfTargetIsSameAsSource;
        this.downgradeIdenticalBestMatches = downgradeIdenticalBestMatches;
        this.targetPrefix = targetPrefix;
        this.thresholdToPrefix = thresholdToPrefix;
        this.copySourceOnNoText = copySourceOnNoText;
    }

    public void leverage(ITextUnit tu) {
        if (!tu.isTranslatable()) {
            return;
        }
        this.totalSegments += tu.getSource().getSegments().count();
        for (int id : this.resList.keySet()) {
            ResourceItem ri = this.resList.get(id);
            if (!ri.enabled) continue;
            ri.query.leverage(tu);
        }
        AltTranslationsAnnotation altTrans = null;
        AltTranslation bestMatch = null;
        for (LocaleId loc : tu.getTargetLocales()) {
            TextContainer tc = tu.getTarget(loc);
            if (tc == null) continue;
            if (this.copySourceOnNoText) {
                for (Segment srcSeg : tu.getSourceSegments()) {
                    Segment trgSeg;
                    if (srcSeg.text.hasText(false) || (trgSeg = tc.getSegments().get(srcSeg.id)) == null) continue;
                    trgSeg.text = srcSeg.text.clone();
                }
            }
            if ((altTrans = tc.getAnnotation(AltTranslationsAnnotation.class)) != null) {
                altTrans.sort();
                if (this.downgradeIdenticalBestMatches) {
                    altTrans.downgradeIdenticalBestMatches(false, this.threshold);
                }
                if ((bestMatch = altTrans.getFirst()) != null) {
                    if (bestMatch.getCombinedScore() >= 100) {
                        ++this.exactBestMatches;
                    } else if (bestMatch.getCombinedScore() > 0) {
                        ++this.fuzzyBestMatches;
                    }
                    if (bestMatch.getCombinedScore() >= this.thresholdToFill && QueryManager.canLeverage(tu.getSource(), tc, this.leverageIfTargetIsEmpty, this.leverageIfTargetIsSameAsSource)) {
                        if (this.targetPrefix != null && bestMatch.getCombinedScore() <= this.thresholdToPrefix) {
                            TextFragment tf = new TextFragment(this.targetPrefix + bestMatch.getTarget().getFirstContent().getCodedText(), bestMatch.getTarget().getFirstContent().getClonedCodes());
                            tu.setTargetContent(this.getTargetLanguage(), tf);
                        } else {
                            tu.setTargetContent(this.getTargetLanguage(), bestMatch.getTarget().getFirstContent());
                        }
                        if (tu.getSource().hasBeenSegmented()) {
                            tu.getSource().joinAll();
                        }
                    }
                }
            }
            for (Segment trgSeg : tc.getSegments()) {
                Segment srcSeg;
                altTrans = trgSeg.getAnnotation(AltTranslationsAnnotation.class);
                if (altTrans == null) continue;
                altTrans.sort();
                if (this.downgradeIdenticalBestMatches) {
                    altTrans.downgradeIdenticalBestMatches(false, this.threshold);
                }
                if ((bestMatch = altTrans.getFirst()) == null) continue;
                if (bestMatch.getCombinedScore() >= 100) {
                    ++this.exactBestMatches;
                } else if (bestMatch.getCombinedScore() > 0) {
                    ++this.fuzzyBestMatches;
                }
                if (bestMatch.getCombinedScore() < this.thresholdToFill || (srcSeg = tu.getSourceSegment(trgSeg.id, false)) == null || !QueryManager.canLeverage(srcSeg, trgSeg, this.leverageIfTargetIsEmpty, this.leverageIfTargetIsSameAsSource)) continue;
                if (this.targetPrefix != null && bestMatch.getCombinedScore() <= this.thresholdToPrefix) {
                    trgSeg.text = new TextFragment(this.targetPrefix + bestMatch.getTarget().getFirstContent().getCodedText(), bestMatch.getTarget().getFirstContent().getClonedCodes());
                    continue;
                }
                trgSeg.text = bestMatch.getTarget().getFirstContent();
            }
        }
    }

    public void resetCounters() {
        this.totalSegments = 0;
        this.exactBestMatches = 0;
        this.fuzzyBestMatches = 0;
    }

    public int getTotalSegments() {
        return this.totalSegments;
    }

    public int getExactBestMatches() {
        return this.exactBestMatches;
    }

    public int getFuzzyBestMatches() {
        return this.fuzzyBestMatches;
    }
}

