/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.changeTracking;

import java.util.Objects;
import net.sf.okapi.lib.xliff2.Util;
import net.sf.okapi.lib.xliff2.core.DataWithExtAttributes;
import net.sf.okapi.lib.xliff2.core.IWithExtAttributes;

public class Item
extends DataWithExtAttributes
implements IWithExtAttributes {
    public static final String TAG_NAME = "item";
    public static final String PROPERTY_CONTENT_VALUE = "content";
    public static final String PROPERTY_ATTR_NAME = "property";
    private String property;
    private String text;

    public Item() {
    }

    public Item(Item original) {
        super(original);
        this.property = original.property;
        this.text = original.text;
    }

    public Item(String property) {
        this.setProperty(property);
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public final void setProperty(String property) {
        if (Util.isNoE(property)) {
            throw new IllegalArgumentException("'property' is a required attribute and cannot be null.");
        }
        this.property = property;
    }

    public String getProperty() {
        return this.property;
    }

    public String getAttributesString() {
        StringBuilder attrs = new StringBuilder();
        attrs.append(" ");
        attrs.append(PROPERTY_ATTR_NAME);
        attrs.append("=\"");
        attrs.append(this.property);
        attrs.append("\"");
        return attrs.toString();
    }

    public String getOpeningTagName() {
        return "ctr:item";
    }

    public String getClosingTag() {
        return "</ctr:item>";
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.property, this.text);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Item other = (Item)obj;
        if (this.property == null ? other.property != null : !this.property.equals(other.property)) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }
}

