/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import java.util.Objects;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.Util;
import net.sf.okapi.lib.xliff2.core.CTagCommon;
import net.sf.okapi.lib.xliff2.core.CanReorder;
import net.sf.okapi.lib.xliff2.core.Directionality;
import net.sf.okapi.lib.xliff2.core.Tag;
import net.sf.okapi.lib.xliff2.core.TagType;

public class CTag
extends Tag {
    protected CTagCommon cc = null;
    private String data;
    private boolean initialWithData;
    private String dataRef;
    private Directionality dataDir = Directionality.AUTO;
    private String disp;
    private String equiv = "";
    private String subFlows;
    private CanReorder canReorder = CanReorder.YES;

    CTag(CTagCommon cc, TagType tagType, String id, String data) {
        this.cc = cc == null ? new CTagCommon(id) : cc;
        this.tagType = tagType;
        this.data = data;
    }

    public CTag(TagType tagType, String id, String data) {
        this(null, tagType, id, data);
    }

    CTag(CTag opposite, String data) {
        switch (opposite.tagType) {
            case CLOSING: {
                this.tagType = TagType.OPENING;
                break;
            }
            case OPENING: {
                this.tagType = TagType.CLOSING;
                break;
            }
            default: {
                throw new InvalidParameterException("Counterpart must be an opening or closing tag.");
            }
        }
        this.cc = opposite.cc;
        this.data = data;
    }

    CTag(CTag original, CTag opposite) {
        super(original);
        this.cc = opposite == null ? new CTagCommon(original.cc) : opposite.cc;
        this.data = original.data;
        this.dataDir = original.dataDir;
        this.dataRef = original.dataRef;
        this.initialWithData = original.initialWithData;
        this.canReorder = original.canReorder;
        this.disp = original.disp;
        this.equiv = original.equiv;
        this.subFlows = original.subFlows;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof CTag)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        CTag cTag = (CTag)other;
        return this.initialWithData == cTag.initialWithData && Objects.equals(this.cc, cTag.cc) && Objects.equals(this.data, cTag.data) && Objects.equals(this.dataRef, cTag.dataRef) && this.dataDir == cTag.dataDir && Objects.equals(this.disp, cTag.disp) && Objects.equals(this.equiv, cTag.equiv) && Objects.equals(this.subFlows, cTag.subFlows) && this.canReorder == cTag.canReorder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.cc, this.data, this.initialWithData, this.dataRef, this.dataDir, this.disp, this.equiv, this.subFlows, this.canReorder});
    }

    @Override
    public boolean isCode() {
        return true;
    }

    @Override
    public boolean isMarker() {
        return false;
    }

    @Override
    public String getId() {
        return this.cc.getId();
    }

    @Override
    public String getType() {
        return this.cc.getType();
    }

    @Override
    public void setType(String type) {
        this.cc.setType(type);
    }

    public String getSubType() {
        return this.cc.getSubType();
    }

    public void setSubType(String subType) {
        this.cc.setSubType(subType);
    }

    public boolean getCanCopy() {
        return this.cc.getCanCopy();
    }

    public void setCanCopy(boolean canCopy) {
        this.cc.setCanCopy(canCopy);
    }

    public boolean getCanOverlap() {
        return this.cc.getCanOverlap();
    }

    public void setCanOverlap(boolean canOverlap) {
        this.cc.setCanOverlap(canOverlap);
    }

    public boolean getCanDelete() {
        return this.cc.getCanDelete();
    }

    public void setCanDelete(boolean canDelete) {
        this.cc.setCanDelete(canDelete);
    }

    public CanReorder getCanReorder() {
        if (this.tagType == TagType.CLOSING && this.canReorder == CanReorder.FIRSTNO) {
            return CanReorder.NO;
        }
        return this.canReorder;
    }

    public void setCanReorder(CanReorder canReorder) {
        this.canReorder = canReorder;
        if (canReorder != CanReorder.YES) {
            this.setCanDelete(false);
            this.setCanCopy(false);
        }
    }

    public String getCopyOf() {
        return this.cc.getCopyOf();
    }

    public void setCopyOf(String id) {
        this.cc.setCopyOf(id);
    }

    public boolean hasData() {
        return !Util.isNoE(this.data);
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getDataRef() {
        return this.dataRef;
    }

    public void setDataRef(String dataRef) {
        this.dataRef = dataRef;
    }

    public boolean isInitialWithData() {
        return this.initialWithData;
    }

    public void setInitialWithData(boolean initialWithData) {
        this.initialWithData = initialWithData;
    }

    public Directionality getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(Directionality dir) {
        this.dataDir = dir;
    }

    public String getDisp() {
        return this.disp;
    }

    public void setDisp(String disp) {
        this.disp = disp;
    }

    public String getEquiv() {
        return this.equiv;
    }

    public void setEquiv(String equiv) {
        if (equiv == null) {
            this.equiv = "";
        }
        this.equiv = equiv;
    }

    public String getSubFlows() {
        return this.subFlows;
    }

    public void setSubFlows(String subFlows) {
        if (subFlows == null) {
            this.subFlows = null;
            return;
        }
        String[] ids = subFlows.split("[\\t\\n ]+", -1);
        Object value = "";
        for (String id : ids) {
            if (id.isEmpty()) continue;
            if (!((String)value).isEmpty()) {
                value = (String)value + " ";
            }
            value = (String)value + id;
        }
        this.subFlows = value;
    }

    public String[] getSubFlowsIds() {
        if (this.subFlows == null) {
            return new String[0];
        }
        return this.subFlows.split(" ", -1);
    }

    public Directionality getDir() {
        return this.cc.getDir();
    }

    public void setDir(Directionality dir) {
        this.cc.setDir(dir);
    }

    public void verifyTypeSubTypeValues() {
        if (this.cc.getSubType() == null) {
            return;
        }
        String type = this.getType();
        switch (this.cc.getSubType()) {
            case "xlf:lb": 
            case "xlf:pb": 
            case "xlf:b": 
            case "xlf:i": 
            case "xlf:u": {
                if (type != null && type.equals("fmt")) break;
                throw new InvalidParameterException(String.format("When subType is '%s', type must be 'fmt'.", this.cc.getSubType()));
            }
            case "xlf:var": {
                if (type != null && type.equals("ui")) break;
                throw new InvalidParameterException(String.format("When subType is '%s', type must be 'fmt'.", this.cc.getSubType()));
            }
        }
    }
}

