/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.changeTracking.ChangeTrack;
import net.sf.okapi.lib.xliff2.core.ExtElements;
import net.sf.okapi.lib.xliff2.core.IWithChangeTrack;
import net.sf.okapi.lib.xliff2.core.IWithExtElements;
import net.sf.okapi.lib.xliff2.core.IWithMetadata;
import net.sf.okapi.lib.xliff2.core.IWithNotes;
import net.sf.okapi.lib.xliff2.core.IWithValidation;
import net.sf.okapi.lib.xliff2.core.InheritedDataWithExtAttributes;
import net.sf.okapi.lib.xliff2.core.Note;
import net.sf.okapi.lib.xliff2.core.Notes;
import net.sf.okapi.lib.xliff2.metadata.Metadata;
import net.sf.okapi.lib.xliff2.validation.Validation;

class CompleteData
extends InheritedDataWithExtAttributes
implements IWithNotes,
IWithMetadata,
IWithValidation,
IWithExtElements,
IWithChangeTrack {
    private Notes notes;
    private Metadata metadata;
    private Validation validation;
    private ChangeTrack changeTrack;
    private ExtElements xelems;
    private String name;
    private String type;

    protected CompleteData() {
    }

    protected CompleteData(CompleteData original) {
        super(original);
        if (original.getNoteCount() > 0) {
            this.notes = new Notes(original.notes);
        }
        if (original.hasMetadata()) {
            this.metadata = new Metadata(original.metadata);
        }
        if (original.hasValidation()) {
            this.validation = new Validation(original.validation, false);
        }
        if (original.hasExtElements()) {
            this.xelems = new ExtElements(original.xelems);
        }
        this.name = original.name;
        this.type = original.type;
    }

    @Override
    public ExtElements getExtElements() {
        if (this.xelems == null) {
            this.xelems = new ExtElements();
        }
        return this.xelems;
    }

    @Override
    public boolean hasExtElements() {
        if (this.xelems == null) {
            return false;
        }
        return !this.xelems.isEmpty();
    }

    @Override
    public ExtElements setExtElements(ExtElements elements) {
        this.xelems = elements;
        return this.getExtElements();
    }

    @Override
    public void addNote(Note note) {
        if (this.notes == null) {
            this.notes = new Notes();
        }
        this.notes.add(note);
    }

    @Override
    public Notes getNotes() {
        if (this.notes == null) {
            this.notes = new Notes();
        }
        return this.notes;
    }

    @Override
    public int getNoteCount() {
        if (this.notes == null) {
            return 0;
        }
        return this.notes.size();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (type != null) {
            int n = type.indexOf(58);
            if (n == -1 || n == 0 || n == type.length() - 1) {
                throw new InvalidParameterException(String.format("Invalid value '%s' for type.", type));
            }
            if (type.startsWith("xlf:")) {
                throw new InvalidParameterException("The prefix 'xlf' is reserved.");
            }
        }
        this.type = type;
    }

    @Override
    public boolean hasMetadata() {
        if (this.metadata == null) {
            return false;
        }
        return !this.metadata.isEmpty();
    }

    @Override
    public Metadata getMetadata() {
        if (this.metadata == null) {
            this.metadata = new Metadata();
        }
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public boolean hasValidation() {
        if (this.validation == null) {
            return false;
        }
        return !this.validation.isEmpty();
    }

    @Override
    public Validation getValidation() {
        if (this.validation == null) {
            this.validation = new Validation();
        }
        return this.validation;
    }

    @Override
    public void setValidation(Validation validation) {
        this.validation = validation;
    }

    @Override
    public ChangeTrack getChangeTrack() {
        if (this.changeTrack == null) {
            this.changeTrack = new ChangeTrack();
        }
        return this.changeTrack;
    }

    @Override
    public void setChangeTrack(ChangeTrack changeTrack) {
        this.changeTrack = changeTrack;
    }

    @Override
    public boolean hasChangeTrack() {
        if (this.changeTrack == null) {
            return false;
        }
        return !this.changeTrack.isEmpty();
    }
}

