/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import java.util.Objects;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.Util;
import net.sf.okapi.lib.xliff2.core.DataWithExtAttributes;

public class StartXliffData
extends DataWithExtAttributes {
    private String version;
    private String sourceLang;
    private String targetLang;

    public StartXliffData(String version) {
        if (version == null) {
            version = "2.0";
        }
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSourceLanguage() {
        return this.sourceLang;
    }

    public void setSourceLanguage(String sourceLang) {
        String msg = Util.validateLang(sourceLang);
        if (msg != null) {
            throw new InvalidParameterException(String.format("The source language value '%s' is invalid.\n" + msg, sourceLang));
        }
        this.sourceLang = sourceLang;
    }

    public String getTargetLanguage() {
        return this.targetLang;
    }

    public void setTargetLanguage(String targetLang) {
        String msg;
        if (targetLang != null && (msg = Util.validateLang(targetLang)) != null) {
            throw new InvalidParameterException(String.format("The target language value '%s' is invalid.\n" + msg, targetLang));
        }
        this.targetLang = targetLang;
    }

    public void setNamespace(String prefix, String namespaceURI) {
        this.getExtAttributes().setNamespace(prefix, namespaceURI);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sourceLang, this.targetLang, this.version);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StartXliffData other = (StartXliffData)obj;
        if (this.sourceLang == null ? other.sourceLang != null : !this.sourceLang.equals(other.sourceLang)) {
            return false;
        }
        if (this.targetLang == null ? other.targetLang != null : !this.targetLang.equals(other.targetLang)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

