/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.desegmentation;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String DESEGMENTSOURCE = "desegmentSource";
    private static final String DESEGMENTTARGET = "desegmentTarget";
    private static final String RENUMBERCODES = "renumberCodes";

    public boolean getDesegmentSource() {
        return this.getBoolean(DESEGMENTSOURCE);
    }

    public void setDesegmentSource(boolean desegmentSource) {
        this.setBoolean(DESEGMENTSOURCE, desegmentSource);
    }

    public boolean getDesegmentTarget() {
        return this.getBoolean(DESEGMENTTARGET);
    }

    public void setDesegmentTarget(boolean desegmentTarget) {
        this.setBoolean(DESEGMENTTARGET, desegmentTarget);
    }

    public boolean getRenumberCodes() {
        return this.getBoolean(RENUMBERCODES);
    }

    public void setRenumberCodes(boolean renumberCodes) {
        this.setBoolean(RENUMBERCODES, renumberCodes);
    }

    @Override
    public void reset() {
        super.reset();
        this.setDesegmentSource(true);
        this.setDesegmentTarget(true);
        this.setRenumberCodes(false);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(DESEGMENTSOURCE, "Join all segments of the source text", null);
        desc.add(DESEGMENTTARGET, "Join all segments of the target text", null);
        desc.add(RENUMBERCODES, "Restore original IDs to renumbered codes", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Desegmentation", true, false);
        desc.addCheckboxPart(paramDesc.get(DESEGMENTSOURCE));
        desc.addCheckboxPart(paramDesc.get(DESEGMENTTARGET));
        desc.addCheckboxPart(paramDesc.get(RENUMBERCODES));
        return desc;
    }
}

