/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.patternschecker;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.lib.verification.PatternItem;

public class Parameters
extends StringParameters {
    private static final String CHECKPATTERNS = "checkPatterns";
    private static final String PATTERNCOUNT = "patternCount";
    private static final String USEPATTERN = "usePattern";
    private static final String FROMSOURCEPATTERN = "fromSourcePattern";
    private static final String SEVERITYPATTERN = "severityPattern";
    private static final String SOURCEPATTERN = "sourcePattern";
    private static final String TARGETPATTERN = "targetPattern";
    private static final String DESCPATTERN = "descPattern";
    List<PatternItem> patterns;

    public boolean getCheckPatterns() {
        return this.getBoolean(CHECKPATTERNS);
    }

    public void setCheckPatterns(boolean patterns) {
        this.setBoolean(CHECKPATTERNS, patterns);
    }

    public List<PatternItem> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(List<PatternItem> patterns) {
        this.patterns = patterns;
    }

    @Override
    public void reset() {
        super.reset();
        this.setCheckPatterns(true);
        this.patterns = new ArrayList<PatternItem>();
        this.patterns.add(new PatternItem("[\\(\\uFF08]", "[\\(\\uFF08]", true, 0, "Opening parenthesis"));
        this.patterns.add(new PatternItem("[\\)\\uFF09]", "[\\)\\uFF09]", true, 0, "Closing parenthesis"));
        this.patterns.add(new PatternItem("[\\p{Ps}\\p{Pe}&&[^\\(\\)\\uFF08\\uFF09]]", "<same>", true, 0, "Bracketing characters (except parentheses)"));
        this.patterns.add(new PatternItem("[\\w\\.\\-]+@[\\w\\.\\-]+", "<same>", true, 1, "Email addresses"));
        this.patterns.add(new PatternItem("https?:[\\w/\\.:;+\\-~\\%#\\$?=&,()]+[\\w/:;+\\-~\\%#\\$?=&,()]+|www\\.[\\w/\\.:;+\\-~\\%#\\$?=&,()]+|ftp:[\\w/\\.:;+\\-~\\%#?=&,]+", "<same>", true, 1, "URLs"));
        this.patterns.add(new PatternItem("\\b(?:\\d{1,3}\\.){3}\\d{1,3}\\b", "<same>", true, 2, "IP addresses"));
        this.patterns.add(new PatternItem("%(([-0+#]?)[-0+#]?)((\\d\\$)?)(([\\d\\*]*)(\\.[\\d\\*]*)?)[dioxXucsfeEgGpn]", "<same>", true, 2, "C-style printf codes"));
        PatternItem item = new PatternItem("<same>", "([\\p{Ll}\\p{Lu}\\p{Lt}\\p{Lo}])\\1\\1", true, 1, "Tripled letter");
        item.fromSource = false;
        this.patterns.add(item);
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
        int count = this.buffer.getInteger(PATTERNCOUNT, 0);
        if (count > 0) {
            this.patterns.clear();
        }
        for (int i = 0; i < count; ++i) {
            boolean enabled = this.buffer.getBoolean(String.format("%s%d", USEPATTERN, i), true);
            int severity = this.buffer.getInteger(String.format("%s%d", SEVERITYPATTERN, i), 1);
            boolean fromSource = this.buffer.getBoolean(String.format("%s%d", FROMSOURCEPATTERN, i), true);
            String source = this.buffer.getString(String.format("%s%d", SOURCEPATTERN, i), "");
            String target = this.buffer.getString(String.format("%s%d", TARGETPATTERN, i), "<same>");
            String desc = this.buffer.getString(String.format("%s%d", DESCPATTERN, i), "");
            this.patterns.add(new PatternItem(source, target, enabled, severity, fromSource, desc));
        }
    }

    @Override
    public String toString() {
        this.buffer.setInteger(PATTERNCOUNT, this.patterns.size());
        for (int i = 0; i < this.patterns.size(); ++i) {
            this.buffer.setBoolean(String.format("%s%d", USEPATTERN, i), this.patterns.get((int)i).enabled);
            this.buffer.setBoolean(String.format("%s%d", FROMSOURCEPATTERN, i), this.patterns.get((int)i).fromSource);
            this.buffer.setInteger(String.format("%s%d", SEVERITYPATTERN, i), this.patterns.get((int)i).severity);
            this.buffer.setString(String.format("%s%d", SOURCEPATTERN, i), this.patterns.get((int)i).source);
            this.buffer.setString(String.format("%s%d", TARGETPATTERN, i), this.patterns.get((int)i).target);
            this.buffer.setString(String.format("%s%d", DESCPATTERN, i), this.patterns.get((int)i).description);
        }
        return super.toString();
    }
}

