/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.postprocess;

import java.io.File;
import java.util.ArrayList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.PipelineParameters;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.filters.rainbowkit.Manifest;
import net.sf.okapi.filters.rainbowkit.MergingInfo;
import net.sf.okapi.lib.merge.merge.ITextUnitMerger;
import net.sf.okapi.lib.merge.merge.TextUnitMerger;
import net.sf.okapi.steps.rainbowkit.postprocess.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Merger {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Parameters parameters;
    private final IFilterConfigurationMapper fcMapper;
    private final Manifest manifest;
    private final LocaleId trgLoc;
    private IFilter filter;
    private IFilterWriter writer;
    private boolean skipEmptySourceEntries;
    private boolean useSubDoc;
    private int errorCount;
    private RawDocument rawDoc;
    private ITextUnitMerger textUnitMerger;

    public Merger(Parameters parameters, IFilterConfigurationMapper fcMapper, Manifest manifest, LocaleId forcedTargetLocale) {
        this.parameters = parameters;
        this.fcMapper = fcMapper;
        this.manifest = manifest;
        this.trgLoc = forcedTargetLocale;
        this.textUnitMerger = new TextUnitMerger();
        this.textUnitMerger.getParameters().setAddMissing(false);
        this.textUnitMerger.getParameters().setCopyCodeMetadata(parameters.getCopyCodeMetadata());
        this.textUnitMerger.getParameters().setSkipOriginalTargetCodeMetadata(parameters.getSkipOriginalTargetCodeMetadata());
    }

    public void close() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        if (this.filter != null) {
            this.filter.close();
            this.filter = null;
        }
    }

    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case TEXT_UNIT: {
                this.processTextUnit(event);
                if (!this.parameters.getReturnRawDocument()) break;
                event = Event.createNoopEvent();
                break;
            }
            case START_SUBDOCUMENT: {
                if (!this.parameters.getReturnRawDocument()) break;
                this.useSubDoc = true;
                event = Event.createNoopEvent();
                break;
            }
            case END_DOCUMENT: {
                this.flushFilterEvents();
                this.close();
                if (!this.parameters.getReturnRawDocument() || this.useSubDoc) break;
                event = this.createMultiEvent();
                break;
            }
            default: {
                if (!this.parameters.getReturnRawDocument()) break;
                event = Event.createNoopEvent();
            }
        }
        return event;
    }

    private Event createMultiEvent() {
        ArrayList<Event> list = new ArrayList<Event>();
        PipelineParameters pp = new PipelineParameters();
        pp.setOutputURI(this.rawDoc.getInputURI());
        pp.setSourceLocale(this.rawDoc.getSourceLocale());
        pp.setTargetLocale(this.rawDoc.getTargetLocale());
        pp.setOutputEncoding(this.rawDoc.getEncoding());
        pp.setInputRawDocument(this.rawDoc);
        list.add(new Event(EventType.PIPELINE_PARAMETERS, pp));
        list.add(new Event(EventType.RAW_DOCUMENT, this.rawDoc));
        return new Event(EventType.MULTI_EVENT, new MultiEvent(list));
    }

    public Event startMerging(MergingInfo info, Event event) {
        this.errorCount = 0;
        this.useSubDoc = false;
        this.logger.info("Merging: {}", (Object)info.getRelativeInputPath());
        this.filter = this.fcMapper.createFilter(info.getFilterId(), this.filter);
        if (this.filter == null) {
            throw new OkapiBadFilterInputException(String.format("Filter cannot be created (%s).", info.getFilterId()));
        }
        IParameters fprm = this.filter.getParameters();
        if (fprm != null) {
            fprm.fromString(info.getFilterParameters());
        }
        File file = new File(this.manifest.getTempOriginalDirectory() + info.getRelativeInputPath());
        RawDocument rd = new RawDocument(file.toURI(), info.getInputEncoding(), this.manifest.getSourceLocale(), this.trgLoc);
        this.filter.open(rd);
        this.writer = this.filter.createFilterWriter();
        this.writer.setOptions(this.trgLoc, info.getTargetEncoding());
        String outPath = this.getOutputPath(info);
        this.writer.setOutput(outPath);
        this.skipEmptySourceEntries = info.getExtractionType().equals("po") || info.getExtractionType().equals("transifex") || info.getExtractionType().equals("table");
        Event internalEvent = null;
        if (this.filter.hasNext()) {
            internalEvent = this.filter.next();
        }
        if (internalEvent == null || internalEvent.getEventType() != EventType.START_DOCUMENT) {
            ++this.errorCount;
            this.logger.error("The start document event is missing when parsing the original file.");
        } else {
            this.writer.handleEvent(internalEvent);
        }
        if (this.parameters.getReturnRawDocument()) {
            this.rawDoc = event.getStartDocument().isMultilingual() ? new RawDocument(new File(outPath).toURI(), info.getTargetEncoding(), this.manifest.getSourceLocale(), this.manifest.getTargetLocale()) : new RawDocument(new File(outPath).toURI(), info.getTargetEncoding(), this.manifest.getTargetLocale(), this.manifest.getTargetLocale());
            event = Event.createNoopEvent();
        } else {
            event = internalEvent;
        }
        return event;
    }

    private String getOutputPath(MergingInfo info) {
        if (Util.isEmpty(this.parameters.getOverrideOutputPath())) {
            return this.manifest.getMergeDirectory() + info.getRelativeTargetPath();
        }
        return Util.ensureSeparator(this.parameters.getOverrideOutputPath(), false) + info.getRelativeTargetPath();
    }

    private void flushFilterEvents() {
        while (this.filter.hasNext()) {
            this.writer.handleEvent(this.filter.next());
        }
        this.writer.close();
    }

    private ITextUnit mergeTextUnit(ITextUnit tuFromSkel, ITextUnit tuFromTrans) {
        if (!tuFromSkel.isTranslatable()) {
            return tuFromSkel;
        }
        this.textUnitMerger.setTargetLocale(this.trgLoc);
        ITextUnit mergedTu = this.textUnitMerger.mergeTargets(tuFromSkel, tuFromTrans);
        return mergedTu;
    }

    private void processTextUnit(Event event) {
        ITextUnit traTu = event.getTextUnit();
        Event oriEvent = this.processUntilTextUnit();
        if (oriEvent == null) {
            ++this.errorCount;
            this.logger.error("No corresponding text unit for id='{}' in the original file.", (Object)traTu.getId());
            return;
        }
        ITextUnit oriTu = oriEvent.getTextUnit();
        ITextUnit mergedTu = this.mergeTextUnit(oriTu, traTu);
        if (this.manifest.getUpdateApprovedFlag()) {
            mergedTu.getTarget(this.trgLoc).setProperty(new Property("approved", "yes"));
        }
        oriEvent.setResource(mergedTu);
        this.writer.handleEvent(oriEvent);
    }

    private Event processUntilTextUnit() {
        while (this.filter.hasNext()) {
            Event event = this.filter.next();
            if (event.getEventType() == EventType.TEXT_UNIT) {
                ITextUnit tu = event.getTextUnit();
                if (this.skipEmptySourceEntries && tu.isEmpty()) {
                    this.writer.handleEvent(event);
                    continue;
                }
                return event;
            }
            this.writer.handleEvent(event);
        }
        return null;
    }

    public int getErrorCount() {
        return this.errorCount;
    }
}

