/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rtfconversion;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.ListSelectionPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    public static final int LBTYPE_PLATFORM = 0;
    public static final int LBTYPE_DOS = 1;
    public static final int LBTYPE_UNIX = 2;
    public static final int LBTYPE_MAC = 3;
    private static final String LINEBREAK = "lineBreak";
    private static final String BOMONUTF8 = "bomOnUTF8";
    private static final String UPDATEENCODING = "updateEncoding";

    @Override
    public void reset() {
        super.reset();
        this.setBomOnUTF8(true);
        this.setLineBreak(System.getProperty("line.separator"));
        if (this.getLineBreak() == null) {
            this.setLineBreak("\r\n");
        }
        this.setUpdateEncoding(true);
    }

    public String getLineBreak() {
        return this.getString(LINEBREAK);
    }

    public void setLineBreak(String lineBreak) {
        this.setString(LINEBREAK, lineBreak);
    }

    public boolean getBomOnUTF8() {
        return this.getBoolean(BOMONUTF8);
    }

    public void setUpdateEncoding(boolean updateEncoding) {
        this.setBoolean(UPDATEENCODING, updateEncoding);
    }

    public boolean getUpdateEncoding() {
        return this.getBoolean(UPDATEENCODING);
    }

    public void setBomOnUTF8(boolean bomOnUTF8) {
        this.setBoolean(BOMONUTF8, bomOnUTF8);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(LINEBREAK, "Type of line-break to use", "Select the type of line-break to use in the output.");
        desc.add(BOMONUTF8, "Use Byte-Order-Mark for UTF-8 output", null);
        desc.add(UPDATEENCODING, "Try to update the encoding declarations (when detected)", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("RTF Conversion", true, false);
        desc.addCheckboxPart(paramsDesc.get(BOMONUTF8));
        desc.addCheckboxPart(paramsDesc.get(UPDATEENCODING));
        String[] values = new String[]{"\r\n", "\n", "\r"};
        String[] labels = new String[]{"DOS/Windows (Carriage-Return + Line-Feed, \\r\\n, 0x0D+0x0A)", "Unix/Linux (Line-Feed, \\n, 0x0A)", "Macintosh (Carriage-Return, \\r, 0x0D)"};
        ListSelectionPart lsp = desc.addListSelectionPart(paramsDesc.get(LINEBREAK), values);
        lsp.setChoicesLabels(labels);
        lsp.setListType(0);
        return desc;
    }
}

