/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tokenization;

import com.ibm.icu.text.RuleBasedBreakIterator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TreeMap;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.StringUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.steps.tokenization.ITokenizer;
import net.sf.okapi.steps.tokenization.Token;
import net.sf.okapi.steps.tokenization.Tokens;

public class RbbiTokenizer
implements ITokenizer {
    private final TreeMap<LocaleId, RuleBasedBreakIterator> iterators = new TreeMap();
    private RuleBasedBreakIterator iterator = null;
    private LocaleId language;
    private int start;
    private int end;
    private String text;

    @Override
    public boolean hasNext() {
        return this.end != -1;
    }

    @Override
    public Token next() {
        this.end = this.iterator.next();
        if (this.end == -1) {
            return null;
        }
        if (this.start >= this.end) {
            return null;
        }
        int tokenId = this.iterator.getRuleStatus();
        String value = this.text.substring(this.start, this.end);
        String name = Tokens.getTokenName(tokenId);
        String description = Tokens.getTokenDescription(tokenId);
        Token token = new Token(tokenId, value, name, description, this.start, this.end);
        this.start = this.end;
        return token;
    }

    @Override
    public void init(String text, LocaleId language) {
        this.language = language;
        this.text = text;
        if (Util.isEmpty(this.text)) {
            return;
        }
        if (this.iterators.containsKey(language)) {
            this.iterator = this.iterators.get(language);
        } else {
            try {
                String rules = StringUtil.readString(RbbiTokenizer.class.getResource("/rbbi.txt"));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                RuleBasedBreakIterator.compileRules((String)rules, (OutputStream)out);
                ByteArrayInputStream is = new ByteArrayInputStream(out.toByteArray());
                this.iterator = RuleBasedBreakIterator.getInstanceFromCompiledRules((InputStream)is);
            }
            catch (IOException | NullPointerException e) {
                throw new OkapiBadFilterInputException("Cannot load compiled break rules.", e);
            }
            this.iterators.put(language, this.iterator);
        }
        if (this.iterator == null) {
            return;
        }
        this.iterator.setText(this.text);
        this.end = this.start = this.iterator.first();
    }
}

