/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xmlanalysis;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.DefaultEntityResolver;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.xmlanalysis.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLAnalyzer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Parameters params = new Parameters();
    private LinkedHashMap<String, Info> elements;

    public XMLAnalyzer() {
        this.reset();
    }

    public void reset() {
        this.elements = new LinkedHashMap();
    }

    public Parameters getParameters() {
        return this.params;
    }

    public void setParameters(Parameters params) {
        this.params = params;
    }

    public void analyzeDocument(RawDocument rd) {
        DocumentBuilder docBuilder;
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        fact.setNamespaceAware(true);
        fact.setValidating(false);
        try {
            fact.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (ParserConfigurationException e) {
            this.logger.warn("Unsupported DocumentBuilderFactory feature. Possible security vulnerabilities.", (Throwable)e);
        }
        try {
            docBuilder = fact.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new OkapiIOException(e);
        }
        docBuilder.setEntityResolver(new DefaultEntityResolver());
        rd.setEncoding("UTF-8");
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(rd.getStream(), rd.getEncoding());
        detector.detectBom();
        if (detector.isAutodetected()) {
            String encoding = detector.getEncoding();
            if (encoding.equals("UTF-16LE") || encoding.equals("UTF-16BE")) {
                encoding = "UTF-16";
            }
            rd.setEncoding(encoding);
        }
        Document doc = null;
        try {
            InputSource is = new InputSource(rd.getStream());
            doc = docBuilder.parse(is);
        }
        catch (SAXException e) {
            throw new OkapiIOException("Error when parsing the document.", e);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error when reading the document.", e);
        }
        Node node = doc.getDocumentElement();
        DocumentTraversal traversal = (DocumentTraversal)((Object)doc);
        TreeWalker walker = traversal.createTreeWalker(node, -1, null, false);
        String lastElem = node.getNodeName();
        this.getInfo((String)lastElem).isRoot = true;
        while (node != null) {
            switch (node.getNodeType()) {
                case 1: {
                    lastElem = node.getNodeName();
                    Info info = this.getInfo(lastElem);
                    if (this.isTextContent(node.getPreviousSibling())) {
                        info.withinText = true;
                    } else if (this.isTextContent(node.getNextSibling())) {
                        info.withinText = true;
                    }
                    if (!this.hasTextContent(node)) break;
                    info.hasText = true;
                    break;
                }
                case 4: {
                    this.getInfo((String)lastElem).hasCDATA = true;
                }
            }
            node = walker.nextNode();
        }
    }

    public HashMap<String, Info> getResults() {
        return this.elements;
    }

    private boolean hasText(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private boolean hasTextContent(Node parent) {
        if (parent == null) {
            return false;
        }
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!this.isTextContent(node)) continue;
            return true;
        }
        return false;
    }

    private boolean isTextContent(Node node) {
        if (node == null) {
            return false;
        }
        return (node.getNodeType() == 3 || node.getNodeType() == 4) && this.hasText(node.getNodeValue());
    }

    private Info getInfo(String key) {
        if (!this.elements.containsKey(key)) {
            this.elements.put(key, new Info());
        }
        return this.elements.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateOutput() {
        XMLWriter xw = null;
        try {
            xw = new XMLWriter(this.params.getOutputPath());
            xw.writeStartHTMLDocument("XML Analyis");
            xw.writeElementString("h1", "XML Analyis Results");
            xw.writeRawXML("<table cellspacing=\"0\" cellpadding=\"5\" border=\"1\">");
            xw.writeStartElement("tr");
            xw.writeRawXML(String.format("<td valign=\"top\">%s</td>", "All elements:"));
            xw.writeRawXML("<td valign=\"top\"><code>");
            for (String name : this.elements.keySet()) {
                xw.writeString(name + " ");
            }
            xw.writeRawXML("\u00a0</code></td>");
            xw.writeEndElementLineBreak();
            xw.writeStartElement("tr");
            xw.writeRawXML(String.format("<td valign=\"top\">%s</td>", "Root elements:"));
            xw.writeRawXML("<td valign=\"top\"><code>");
            for (String name : this.elements.keySet()) {
                if (!this.elements.get((Object)name).isRoot) continue;
                xw.writeString(name + " ");
            }
            xw.writeRawXML("\u00a0</code></td>");
            xw.writeEndElementLineBreak();
            xw.writeStartElement("tr");
            xw.writeRawXML(String.format("<td valign=\"top\">%s</td>", "Elements with text content:"));
            xw.writeRawXML("<td valign=\"top\"><code>");
            for (String name : this.elements.keySet()) {
                if (!this.elements.get((Object)name).hasText) continue;
                xw.writeString(name + " ");
            }
            xw.writeRawXML("\u00a0</code></td>");
            xw.writeEndElementLineBreak();
            xw.writeStartElement("tr");
            xw.writeRawXML(String.format("<td valign=\"top\">%s</td>", "Elements within text (inline):"));
            xw.writeRawXML("<td valign=\"top\"><code>");
            for (String name : this.elements.keySet()) {
                if (!this.elements.get((Object)name).withinText) continue;
                xw.writeString(name + " ");
            }
            xw.writeRawXML("\u00a0</code></td>");
            xw.writeEndElementLineBreak();
            xw.writeStartElement("tr");
            xw.writeRawXML(String.format("<td valign=\"top\">%s</td>", "Elements with CDATA:"));
            xw.writeRawXML("<td valign=\"top\"><code>");
            for (String name : this.elements.keySet()) {
                if (!this.elements.get((Object)name).hasCDATA) continue;
                xw.writeString(name + " ");
            }
            xw.writeRawXML("\u00a0</code></td>");
            xw.writeEndElementLineBreak();
            xw.writeRawXML("</table>");
        }
        finally {
            if (xw != null) {
                xw.writeEndDocument();
                xw.close();
            }
            if (this.params.getAutoOpen()) {
                Util.openURL(new File(this.params.getOutputPath()).getAbsolutePath());
            }
        }
    }

    static class Info {
        boolean isRoot;
        boolean hasText;
        boolean withinText;
        boolean hasCDATA;

        Info() {
        }
    }
}

