/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene90.blocktree;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.lucene90.blocktree.CompressionAlgorithm;
import org.apache.lucene.codecs.lucene90.blocktree.IntersectTermsEnum;
import org.apache.lucene.codecs.lucene90.blocktree.SegmentTermsEnum;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Transition;
import org.apache.lucene.util.fst.FST;

final class IntersectTermsEnumFrame {
    final int ord;
    long fp;
    long fpOrig;
    long fpEnd;
    long lastSubFP;
    int state;
    int lastState;
    int metaDataUpto;
    byte[] suffixBytes = new byte[128];
    final ByteArrayDataInput suffixesReader = new ByteArrayDataInput();
    byte[] suffixLengthBytes;
    final ByteArrayDataInput suffixLengthsReader;
    byte[] statBytes = new byte[64];
    int statsSingletonRunLength = 0;
    final ByteArrayDataInput statsReader = new ByteArrayDataInput();
    final ByteArrayDataInput floorDataReader = new ByteArrayDataInput();
    int prefix;
    int entCount;
    int nextEnt;
    boolean isLastInFloor;
    boolean isLeafBlock;
    int numFollowFloorBlocks;
    int nextFloorLabel;
    final Transition transition = new Transition();
    int transitionIndex;
    int transitionCount;
    FST.Arc<BytesRef> arc;
    final BlockTermState termState;
    byte[] bytes = new byte[32];
    final ByteArrayDataInput bytesReader = new ByteArrayDataInput();
    int startBytePos;
    int suffix;
    private final IntersectTermsEnum ite;

    public IntersectTermsEnumFrame(IntersectTermsEnum ite, int ord) throws IOException {
        this.ite = ite;
        this.ord = ord;
        this.termState = ite.fr.parent.postingsReader.newTermState();
        this.termState.totalTermFreq = -1L;
        this.suffixLengthBytes = new byte[32];
        this.suffixLengthsReader = new ByteArrayDataInput();
    }

    void loadNextFloorBlock() throws IOException {
        assert (this.numFollowFloorBlocks > 0) : "nextFloorLabel=" + this.nextFloorLabel;
        do {
            this.fp = this.fpOrig + (this.floorDataReader.readVLong() >>> 1);
            --this.numFollowFloorBlocks;
            this.nextFloorLabel = this.numFollowFloorBlocks != 0 ? this.floorDataReader.readByte() & 0xFF : 256;
        } while (this.numFollowFloorBlocks != 0 && this.nextFloorLabel <= this.transition.min);
        this.load((Long)null);
    }

    public void setState(int state) {
        this.state = state;
        this.transitionIndex = 0;
        this.transitionCount = this.ite.automaton.getNumTransitions(state);
        if (this.transitionCount != 0) {
            this.ite.automaton.initTransition(state, this.transition);
            this.ite.automaton.getNextTransition(this.transition);
        } else {
            this.transition.min = -1;
            this.transition.max = -1;
        }
    }

    void load(BytesRef frameIndexData) throws IOException {
        this.floorDataReader.reset(frameIndexData.bytes, frameIndexData.offset, frameIndexData.length);
        this.load(this.ite.fr.readVLongOutput(this.floorDataReader));
    }

    void load(SegmentTermsEnum.OutputAccumulator outputAccumulator) throws IOException {
        outputAccumulator.prepareRead();
        long code = this.ite.fr.readVLongOutput(outputAccumulator);
        outputAccumulator.setFloorData(this.floorDataReader);
        this.load(code);
    }

    void load(Long blockCode) throws IOException {
        boolean allEqual;
        CompressionAlgorithm compressionAlg;
        if (blockCode != null && (blockCode & 1L) != 0L) {
            this.numFollowFloorBlocks = this.floorDataReader.readVInt();
            this.nextFloorLabel = this.floorDataReader.readByte() & 0xFF;
            if (!this.ite.runAutomaton.isAccept(this.state) && this.transitionCount != 0) {
                assert (this.transitionIndex == 0) : "transitionIndex=" + this.transitionIndex;
                while (this.numFollowFloorBlocks != 0 && this.nextFloorLabel <= this.transition.min) {
                    this.fp = this.fpOrig + (this.floorDataReader.readVLong() >>> 1);
                    --this.numFollowFloorBlocks;
                    if (this.numFollowFloorBlocks != 0) {
                        this.nextFloorLabel = this.floorDataReader.readByte() & 0xFF;
                        continue;
                    }
                    this.nextFloorLabel = 256;
                }
            }
        }
        this.ite.in.seek(this.fp);
        int code = this.ite.in.readVInt();
        this.entCount = code >>> 1;
        assert (this.entCount > 0);
        this.isLastInFloor = (code & 1) != 0;
        long codeL = this.ite.in.readVLong();
        this.isLeafBlock = (codeL & 4L) != 0L;
        int numSuffixBytes = (int)(codeL >>> 3);
        if (this.suffixBytes.length < numSuffixBytes) {
            this.suffixBytes = new byte[ArrayUtil.oversize(numSuffixBytes, 1)];
        }
        try {
            compressionAlg = CompressionAlgorithm.byCode((int)codeL & 3);
        }
        catch (IllegalArgumentException e) {
            throw new CorruptIndexException(e.getMessage(), this.ite.in, (Throwable)e);
        }
        compressionAlg.read(this.ite.in, this.suffixBytes, numSuffixBytes);
        this.suffixesReader.reset(this.suffixBytes, 0, numSuffixBytes);
        int numSuffixLengthBytes = this.ite.in.readVInt();
        boolean bl = allEqual = (numSuffixLengthBytes & 1) != 0;
        if (this.suffixLengthBytes.length < (numSuffixLengthBytes >>>= 1)) {
            this.suffixLengthBytes = new byte[ArrayUtil.oversize(numSuffixLengthBytes, 1)];
        }
        if (allEqual) {
            Arrays.fill(this.suffixLengthBytes, 0, numSuffixLengthBytes, this.ite.in.readByte());
        } else {
            this.ite.in.readBytes(this.suffixLengthBytes, 0, numSuffixLengthBytes);
        }
        this.suffixLengthsReader.reset(this.suffixLengthBytes, 0, numSuffixLengthBytes);
        int numBytes = this.ite.in.readVInt();
        if (this.statBytes.length < numBytes) {
            this.statBytes = new byte[ArrayUtil.oversize(numBytes, 1)];
        }
        this.ite.in.readBytes(this.statBytes, 0, numBytes);
        this.statsReader.reset(this.statBytes, 0, numBytes);
        this.statsSingletonRunLength = 0;
        this.metaDataUpto = 0;
        this.termState.termBlockOrd = 0;
        this.nextEnt = 0;
        numBytes = this.ite.in.readVInt();
        if (this.bytes.length < numBytes) {
            this.bytes = new byte[ArrayUtil.oversize(numBytes, 1)];
        }
        this.ite.in.readBytes(this.bytes, 0, numBytes);
        this.bytesReader.reset(this.bytes, 0, numBytes);
        if (!this.isLastInFloor) {
            this.fpEnd = this.ite.in.getFilePointer();
        }
    }

    public boolean next() {
        if (this.isLeafBlock) {
            this.nextLeaf();
            return false;
        }
        return this.nextNonLeaf();
    }

    public void nextLeaf() {
        assert (this.nextEnt != -1 && this.nextEnt < this.entCount) : "nextEnt=" + this.nextEnt + " entCount=" + this.entCount + " fp=" + this.fp;
        ++this.nextEnt;
        this.suffix = this.suffixLengthsReader.readVInt();
        this.startBytePos = this.suffixesReader.getPosition();
        this.suffixesReader.skipBytes(this.suffix);
    }

    public boolean nextNonLeaf() {
        assert (this.nextEnt != -1 && this.nextEnt < this.entCount) : "nextEnt=" + this.nextEnt + " entCount=" + this.entCount + " fp=" + this.fp;
        ++this.nextEnt;
        int code = this.suffixLengthsReader.readVInt();
        this.suffix = code >>> 1;
        this.startBytePos = this.suffixesReader.getPosition();
        this.suffixesReader.skipBytes(this.suffix);
        if ((code & 1) == 0) {
            ++this.termState.termBlockOrd;
            return false;
        }
        this.lastSubFP = this.fp - this.suffixLengthsReader.readVLong();
        return true;
    }

    public int getTermBlockOrd() {
        return this.isLeafBlock ? this.nextEnt : this.termState.termBlockOrd;
    }

    public void decodeMetaData() throws IOException {
        boolean absolute;
        int limit = this.getTermBlockOrd();
        boolean bl = absolute = this.metaDataUpto == 0;
        assert (limit > 0);
        while (this.metaDataUpto < limit) {
            if (this.statsSingletonRunLength > 0) {
                this.termState.docFreq = 1;
                this.termState.totalTermFreq = 1L;
                --this.statsSingletonRunLength;
            } else {
                int token = this.statsReader.readVInt();
                if ((token & 1) == 1) {
                    this.termState.docFreq = 1;
                    this.termState.totalTermFreq = 1L;
                    this.statsSingletonRunLength = token >>> 1;
                } else {
                    this.termState.docFreq = token >>> 1;
                    this.termState.totalTermFreq = this.ite.fr.fieldInfo.getIndexOptions() == IndexOptions.DOCS ? (long)this.termState.docFreq : (long)this.termState.docFreq + this.statsReader.readVLong();
                }
            }
            this.ite.fr.parent.postingsReader.decodeTerm(this.bytesReader, this.ite.fr.fieldInfo, this.termState, absolute);
            ++this.metaDataUpto;
            absolute = false;
        }
        this.termState.termBlockOrd = this.metaDataUpto;
    }
}

