/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui;

import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Sash;

public class ConstrainedSashForm
extends SashForm {
    private Sash sash;
    private Control upPart;
    private Control dnPart;
    private int wDelta;
    private int hDelta;
    private int min1;
    private int min2;
    private Rectangle sr;

    public ConstrainedSashForm(Composite parent, boolean verticalSash) {
        super(parent, verticalSash ? 256 : 512);
        Display.getCurrent().asyncExec(() -> {
            Rectangle r0 = this.getParent().getBounds();
            Rectangle r1 = this.getBounds();
            this.wDelta = r0.width - r1.width;
            this.hDelta = r0.height - r1.height;
            for (Control child : this.getChildren()) {
                if (!(child instanceof Sash)) continue;
                this.sash = (Sash)child;
                this.sash.addListener(13, event -> {
                    Rectangle rect = this.sash.getParent().getClientArea();
                    if (verticalSash) {
                        event.x = event.x < rect.width / 2 ? Math.max(this.min1, event.x) : Math.min(rect.width - this.min2, event.x);
                    } else {
                        int n = event.y = event.y < rect.height / 2 ? Math.max(this.min1, event.y) : Math.min(rect.height - this.min2, event.y);
                    }
                    if (event.detail != 1) {
                        Rectangle r01 = this.sash.getParent().getClientArea();
                        Rectangle r11 = this.upPart.getBounds();
                        Rectangle r2 = this.sash.getBounds();
                        Rectangle r3 = this.dnPart.getBounds();
                        if (verticalSash) {
                            int ltWidth = event.x;
                            int rtWidth = r01.width - (ltWidth + r2.width);
                            this.upPart.setBounds(r11.x, r11.y, ltWidth, r11.height);
                            this.sash.setBounds(ltWidth, r2.y, r2.width, r2.height);
                            this.dnPart.setBounds(ltWidth + r2.width, r3.y, rtWidth, r3.height);
                        } else {
                            int upHeight = event.y;
                            int dnHeight = r01.height - (upHeight + r2.height);
                            this.upPart.setBounds(r11.x, r11.y, r11.width, upHeight);
                            this.sash.setBounds(r2.x, upHeight, r2.width, r2.height);
                            this.dnPart.setBounds(r3.x, upHeight + r2.height, r3.width, dnHeight);
                        }
                    }
                });
                Control[] children = this.getChildren();
                if (children.length <= 1) break;
                this.upPart = children[0];
                this.dnPart = children[1];
                Point p1 = this.upPart.computeSize(-1, -1);
                Point p2 = this.dnPart.computeSize(-1, -1);
                if (verticalSash) {
                    this.min1 = p1.x;
                    this.min2 = p2.x;
                    this.setWeights(new int[]{this.min1, this.min2});
                    break;
                }
                this.min1 = p1.y;
                this.min2 = p2.y;
                this.setWeights(new int[]{this.min1, this.min2});
                break;
            }
        });
        this.addListener(11, event -> {
            if (this.sash == null) {
                return;
            }
            Rectangle rect = this.sash.getParent().getClientArea();
            this.sr = this.sash.getBounds();
            if (verticalSash) {
                this.sr.x = this.sr.x < rect.width / 2 ? Math.max(this.min1, this.sr.x) : Math.min(rect.width - this.min2, this.sr.x);
                this.setWeights(new int[]{this.sr.x, rect.width - this.sr.x});
            } else {
                this.sr.y = this.sr.y < rect.height / 2 ? Math.max(this.min1, this.sr.y) : Math.min(rect.height - this.min2, this.sr.y);
                this.setWeights(new int[]{this.sr.y, rect.height - this.sr.y});
            }
            Rectangle r0 = this.getParent().getBounds();
            Rectangle r1 = this.getBounds();
            if (r0.width - r1.width != this.wDelta || r0.height - r1.height != this.hDelta) {
                this.setBounds(r1.x, r1.y, r0.width - this.wDelta, r0.height - this.hDelta);
            }
        });
    }
}

