/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui;

import java.util.Arrays;
import java.util.ResourceBundle;
import net.sf.okapi.common.ui.ResponsiveTableDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public interface ResponsiveTable {
    public void configureHeader(String[] var1);

    public void addRow(String[] var1);

    public void configureBody();

    public TableItem[] rows();

    public static final class Default
    implements ResponsiveTable {
        private static final String COLON = ":";
        private final Table table;
        private final Menu headerMenu;
        private final Menu bodyMenu;
        private ResourceBundle resourceBundle;

        public Default(Table table, Menu headerMenu, Menu bodyMenu) {
            this.table = table;
            this.headerMenu = headerMenu;
            this.bodyMenu = bodyMenu;
        }

        @Override
        public void configureHeader(String[] columnNames) {
            this.table.setHeaderVisible(true);
            Arrays.stream(columnNames).forEach(n -> {
                TableColumn tc = new TableColumn(this.table, 0);
                tc.setText(n);
            });
            MenuItem mi = new MenuItem(this.headerMenu, 8);
            mi.setText(this.resourceBundle().getString("new"));
            mi.addListener(13, this.menuSelectionListenerWith(mi.getText()));
        }

        private ResourceBundle resourceBundle() {
            if (null == this.resourceBundle) {
                this.resourceBundle = ResourceBundle.getBundle("net.sf.okapi.common.ui.ResponsiveTable");
            }
            return this.resourceBundle;
        }

        @Override
        public void addRow(String[] values) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(values);
        }

        @Override
        public void configureBody() {
            this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            Arrays.stream(this.table.getColumns()).forEach(c -> c.pack());
            this.configureBodyMenu();
            this.configureGeneralListeners();
        }

        private void configureBodyMenu() {
            MenuItem mi = new MenuItem(this.bodyMenu, 8);
            mi.setText(this.resourceBundle().getString("new"));
            mi.addListener(13, this.menuSelectionListenerWith(mi.getText()));
            mi = new MenuItem(this.bodyMenu, 8);
            mi.setText(this.resourceBundle().getString("edit"));
            mi.addListener(13, this.menuSelectionListenerWith(mi.getText()));
            mi = new MenuItem(this.bodyMenu, 8);
            mi.setText(this.resourceBundle().getString("remove"));
            mi.addListener(13, event -> this.table.remove(this.table.getSelectionIndices()));
        }

        private Listener menuSelectionListenerWith(String dialogTitle) {
            return event -> this.handleInteraction(dialogTitle);
        }

        private void handleInteraction(String dialogTitle) {
            String[] inputValues = this.inputValuesFor(dialogTitle);
            String[] outputValues = new ResponsiveTableDialog.Default(new Shell(this.table.getShell(), 67696), dialogTitle, (String[])Arrays.stream(this.table.getColumns()).map(c -> c.getText().concat(COLON)).toArray(String[]::new), inputValues).open();
            this.saveIfNeeded(dialogTitle, outputValues);
        }

        private String[] inputValuesFor(String dialogTitle) {
            String[] inputValues;
            if (this.resourceBundle().getString("new").equals(dialogTitle)) {
                inputValues = new String[]{};
            } else {
                inputValues = new String[this.table.getColumnCount()];
                TableItem ti = this.table.getSelection()[0];
                for (int i = 0; i < inputValues.length; ++i) {
                    inputValues[i] = ti.getText(i);
                }
            }
            return inputValues;
        }

        private void saveIfNeeded(String dialogTitle, String[] outputValues) {
            if (this.resourceBundle().getString("new").equals(dialogTitle)) {
                if (0 < outputValues.length) {
                    this.addRow(outputValues);
                    this.table.select(this.table.getItemCount() - 1);
                }
            } else {
                TableItem ti = this.table.getSelection()[0];
                ti.setText(outputValues);
            }
        }

        private void configureGeneralListeners() {
            this.table.addListener(35, event -> {
                Point p = this.table.getShell().getDisplay().map(null, (Control)this.table, new Point(event.x, event.y));
                Rectangle clientArea = this.table.getClientArea();
                boolean headerArea = clientArea.y <= p.y && p.y < clientArea.y + this.table.getHeaderHeight();
                boolean rowsPresent = 0 < this.table.getItemCount();
                this.table.setMenu(headerArea || !rowsPresent ? this.headerMenu : this.bodyMenu);
            });
            this.table.addListener(8, event -> {
                Point p = new Point(event.x, event.y);
                TableItem ti = this.table.getItem(p);
                if (null != ti) {
                    this.handleInteraction(this.resourceBundle().getString("edit"));
                }
            });
            this.table.addListener(12, event -> {
                this.headerMenu.dispose();
                this.bodyMenu.dispose();
            });
        }

        @Override
        public TableItem[] rows() {
            return this.table.getItems();
        }
    }
}

