/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui.genericeditor;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ParameterDescriptor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiEditorCreationException;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.TextAndBrowsePanel;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.common.ui.filters.InlineCodeFinderPanel;
import net.sf.okapi.common.uidescription.AbstractPart;
import net.sf.okapi.common.uidescription.CheckListPart;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.CodeFinderPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.FolderInputPart;
import net.sf.okapi.common.uidescription.IContainerPart;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.ListSelectionPart;
import net.sf.okapi.common.uidescription.PathInputPart;
import net.sf.okapi.common.uidescription.SeparatorPart;
import net.sf.okapi.common.uidescription.SpinInputPart;
import net.sf.okapi.common.uidescription.TextInputPart;
import net.sf.okapi.common.uidescription.TextLabelPart;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class GenericEditor {
    protected Shell shell;
    protected IParameters params;
    protected Composite mainComposite;
    private boolean result = false;
    private EditorDescription description;
    private Hashtable<String, Control> controls;
    private Hashtable<Control, MasterItem> masters;
    private boolean hasLongField;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean edit(IParameters paramsObject, IEditorDescriptionProvider descProvider, boolean readOnly, IContext context) {
        boolean bRes = false;
        this.shell = null;
        try {
            this.params = paramsObject;
            this.shell = new Shell((Shell)context.getObject("shell"), 65648);
            this.create((Shell)context.getObject("shell"), descProvider, readOnly);
            boolean bl = this.showDialog();
            return bl;
        }
        catch (Exception E) {
            Dialogs.showError(this.shell, E.getLocalizedMessage(), null);
            bRes = false;
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return bRes;
    }

    protected void createComposite(Composite parent, IEditorDescriptionProvider descProv) {
        ParametersDescription pd = this.params.getParametersDescription();
        if (pd == null) {
            throw new OkapiEditorCreationException("This configuration cannot be edited with the generic editor because it does not provide a description of its parameters.");
        }
        this.description = descProv.createEditorDescription(pd);
        if (this.description == null) {
            throw new OkapiEditorCreationException("This configuration cannot be edited with the generic editor because the UI description could not be created.");
        }
        this.controls = new Hashtable();
        this.masters = new Hashtable();
        this.mainComposite = new Composite(parent, 2048);
        this.mainComposite.setLayoutData((Object)new GridData(1808));
        GridLayout layTmp = new GridLayout(2, false);
        this.mainComposite.setLayout((Layout)layTmp);
        this.hasLongField = false;
        for (AbstractPart part : this.description.getDescriptors().values()) {
            TextAndBrowsePanel ctrl;
            GridData gdTmp;
            Composite cmp;
            TextInputPart d;
            if (part instanceof TextInputPart) {
                Text text;
                d = (TextInputPart)part;
                cmp = this.lookupParent(d.getContainer());
                if (d.isWithLabel()) {
                    this.setLabel(cmp, (AbstractPart)d, 0);
                }
                if (d.getHeight() > -1) {
                    text = new Text(cmp, 2624);
                    gdTmp = new GridData(1808);
                    gdTmp.heightHint = d.getHeight();
                } else {
                    text = new Text(cmp, 2048);
                    gdTmp = new GridData(768);
                }
                this.controls.put(d.getName(), (Control)text);
                if (part.isVertical() || !part.isWithLabel()) {
                    gdTmp.horizontalSpan = 2;
                }
                text.setLayoutData((Object)gdTmp);
                text.setEditable(d.getWriteMethod() != null);
                if (d.isPassword()) {
                    text.setEchoChar('*');
                }
            } else if (part instanceof CheckboxPart) {
                d = (CheckboxPart)part;
                cmp = this.lookupParent(d.getContainer());
                if (!part.isVertical()) {
                    new Label(cmp, 0);
                }
                Button button = new Button(cmp, 32);
                button.setToolTipText(d.getShortDescription());
                this.controls.put(d.getName(), (Control)button);
                if (part.isVertical() || !part.isWithLabel()) {
                    gdTmp = new GridData();
                    gdTmp.horizontalSpan = 2;
                    button.setLayoutData((Object)gdTmp);
                }
                button.setText(d.getDisplayName());
                button.setEnabled(d.getWriteMethod() != null);
            } else if (part instanceof PathInputPart) {
                d = (PathInputPart)part;
                cmp = this.lookupParent(d.getContainer());
                if (d.isWithLabel()) {
                    this.setLabel(cmp, (AbstractPart)d, 0);
                }
                ctrl = new TextAndBrowsePanel(cmp, 0, false);
                ctrl.setSaveAs(d.isForSaveAs());
                ctrl.setTitle(d.getBrowseTitle());
                ctrl.setBrowseFilters(d.getFilterNames(), d.getFilterExtensions());
                gdTmp = new GridData(768);
                if (part.isVertical() && !part.isLabelNextToInput() || !part.isWithLabel()) {
                    gdTmp.horizontalSpan = 2;
                }
                ctrl.setLayoutData(gdTmp);
                this.controls.put(d.getName(), (Control)ctrl);
                ctrl.setEditable(d.getWriteMethod() != null);
                this.hasLongField = true;
            } else if (part instanceof FolderInputPart) {
                d = (FolderInputPart)part;
                cmp = this.lookupParent(d.getContainer());
                if (d.isWithLabel()) {
                    this.setLabel(cmp, (AbstractPart)d, 0);
                }
                ctrl = new TextAndBrowsePanel(cmp, 0, true);
                ctrl.setTitle(d.getBrowseTitle());
                gdTmp = new GridData(768);
                if (part.isVertical() && !part.isLabelNextToInput() || !part.isWithLabel()) {
                    gdTmp.horizontalSpan = 2;
                }
                ctrl.setLayoutData(gdTmp);
                this.controls.put(d.getName(), (Control)ctrl);
                ctrl.setEditable(d.getWriteMethod() != null);
                this.hasLongField = true;
            } else if (part instanceof ListSelectionPart) {
                d = (ListSelectionPart)part;
                cmp = this.lookupParent(d.getContainer());
                if (d.getListType() == 1) {
                    if (d.isWithLabel()) {
                        this.setLabel(cmp, (AbstractPart)d, 0);
                    }
                    Combo combo = new Combo(cmp, 2060);
                    this.controls.put(d.getName(), (Control)combo);
                    gdTmp = new GridData(768);
                    if (part.isVertical() || !part.isWithLabel()) {
                        gdTmp.horizontalSpan = 2;
                    }
                    combo.setLayoutData((Object)gdTmp);
                    combo.setEnabled(d.getWriteMethod() != null);
                } else {
                    if (d.isWithLabel()) {
                        this.setLabel(cmp, (AbstractPart)d, 2);
                    }
                    List list = new List(cmp, 2816);
                    this.controls.put(d.getName(), (Control)list);
                    gdTmp = new GridData(1808);
                    if (part.isVertical() || !part.isWithLabel()) {
                        gdTmp.horizontalSpan = 2;
                    }
                    list.setLayoutData((Object)gdTmp);
                    list.setEnabled(d.getWriteMethod() != null);
                }
            } else if (part instanceof CheckListPart) {
                d = (CheckListPart)part;
                cmp = this.lookupParent(d.getContainer());
                if (d.isWithLabel()) {
                    this.setLabel(cmp, (AbstractPart)d, 2);
                }
                Table table = new Table(cmp, 68384);
                this.controls.put(d.getName(), (Control)table);
                gdTmp = new GridData(4, 4, true, true);
                gdTmp.heightHint = d.getHeightHint();
                if (part.isVertical() || !part.isWithLabel()) {
                    gdTmp.horizontalSpan = 2;
                }
                table.setLayoutData((Object)gdTmp);
            } else if (part instanceof CodeFinderPart) {
                d = (CodeFinderPart)part;
                cmp = this.lookupParent(d.getContainer());
                if (!part.isVertical()) {
                    new Label(cmp, 0);
                }
                InlineCodeFinderPanel panel = new InlineCodeFinderPanel(cmp, 0);
                this.controls.put(d.getName(), (Control)panel);
                if (part.isVertical() || !part.isWithLabel()) {
                    gdTmp = new GridData();
                    gdTmp.horizontalSpan = 2;
                    panel.setLayoutData(gdTmp);
                }
                panel.setEnabled(d.getWriteMethod() != null);
            } else if (part instanceof SpinInputPart) {
                d = (SpinInputPart)part;
                cmp = this.lookupParent(d.getContainer());
                if (d.isWithLabel()) {
                    this.setLabel(cmp, (AbstractPart)d, 0);
                }
                Spinner spinner = new Spinner(cmp, 2048);
                spinner.setMinimum(d.getMinimumValue());
                spinner.setMaximum(d.getMaximumValue());
                spinner.setIncrement(1);
                spinner.setPageIncrement(10);
                this.controls.put(d.getName(), (Control)spinner);
                if (part.isVertical() || !part.isWithLabel()) {
                    gdTmp = new GridData();
                    gdTmp.horizontalSpan = 2;
                    spinner.setLayoutData((Object)gdTmp);
                }
                spinner.setEnabled(d.getWriteMethod() != null);
            } else if (part instanceof SeparatorPart) {
                d = (SeparatorPart)part;
                cmp = this.lookupParent(d.getContainer());
                Label separator = new Label(cmp, 2048);
                this.controls.put(d.getName(), (Control)separator);
                gdTmp = new GridData(768);
                gdTmp.heightHint = 1;
                if (part.isVertical() || !part.isWithLabel()) {
                    gdTmp.horizontalSpan = 2;
                }
                separator.setLayoutData((Object)gdTmp);
            } else if (part instanceof TextLabelPart) {
                d = (TextLabelPart)part;
                cmp = this.lookupParent(d.getContainer());
                Label label = new Label(cmp, 0);
                label.setText(d.getDisplayName());
                if (!Util.isEmpty((String)d.getShortDescription())) {
                    label.setToolTipText(d.getShortDescription());
                }
                this.controls.put(d.getName(), (Control)label);
                gdTmp = new GridData(768);
                if (part.isVertical() || !part.isWithLabel()) {
                    gdTmp.horizontalSpan = 2;
                }
                label.setLayoutData((Object)gdTmp);
            }
            if (part.getMasterPart() == null) continue;
            this.addObserver(part);
        }
    }

    private void create(Shell parent, IEditorDescriptionProvider descProv, boolean readOnly) {
        if (parent != null) {
            UIUtil.inheritIcon(this.shell, parent);
        }
        GridLayout layTmp = new GridLayout(1, false);
        layTmp.marginBottom = 0;
        layTmp.verticalSpacing = 0;
        this.shell.setLayout((Layout)layTmp);
        this.createComposite((Composite)this.shell, descProv);
        if (this.description.getCaption() != null) {
            this.shell.setText(this.description.getCaption());
        } else {
            this.shell.setText("Parameters");
        }
        SelectionAdapter okCancelActions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget.getData().equals("h")) {
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    if (!GenericEditor.this.saveData()) {
                        return;
                    }
                    GenericEditor.this.result = true;
                }
                GenericEditor.this.shell.close();
            }
        };
        OKCancelPanel pnlActions = new OKCancelPanel((Composite)this.shell, 0, okCancelActions, false);
        GridData gdTmp = new GridData(768);
        pnlActions.setLayoutData(gdTmp);
        pnlActions.btOK.setEnabled(!readOnly);
        if (!readOnly) {
            this.shell.setDefaultButton(pnlActions.btOK);
        }
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        if (this.hasLongField) {
            Point startSize = this.shell.getMinimumSize();
            if (startSize.x < 600) {
                startSize.x = 600;
            }
            this.shell.setSize(startSize);
        }
        Dialogs.centerWindow(this.shell, parent);
        this.setData();
    }

    private void addObserver(AbstractPart part) {
        AbstractPart masterPart = part.getMasterPart();
        Control masterCtrl = this.controls.get(masterPart.getName());
        if (!(masterCtrl instanceof Button)) {
            throw new OkapiEditorCreationException(String.format("The master UI part for the part '%s' cannot be used as a toggle switch.", part.getName()));
        }
        masterCtrl.addListener(13, (Listener)new CtrlSelectionListener(masterCtrl));
        MasterItem mi = this.masters.get(masterCtrl);
        if (mi == null) {
            mi = new MasterItem();
            this.masters.put(masterCtrl, mi);
        }
        mi.addSlave(part);
    }

    private void setLabel(Composite parent, AbstractPart part, int flag) {
        Label label = new Label(parent, 0);
        Object tmp = part.getDisplayName();
        if (tmp != null) {
            if (!((String)tmp).endsWith(":")) {
                tmp = (String)tmp + ":";
            }
            label.setText((String)tmp);
        }
        label.setToolTipText(part.getShortDescription());
        if (part.isLabelFlushed()) {
            flag |= 0x80;
        }
        GridData gdTmp = new GridData(flag);
        if (part.isVertical() && !part.isLabelNextToInput()) {
            gdTmp.horizontalSpan = 2;
        }
        label.setLayoutData((Object)gdTmp);
    }

    protected void setData() {
        ArrayList<AbstractPart> list = new ArrayList<AbstractPart>();
        for (AbstractPart part : this.description.getDescriptors().values()) {
            TextInputPart d;
            if (part instanceof TextInputPart) {
                d = (TextInputPart)part;
                this.setInputControl((Text)this.controls.get(d.getName()), d);
            } else if (part instanceof CheckboxPart) {
                d = (CheckboxPart)part;
                this.setCheckboxControl((Button)this.controls.get(d.getName()), (CheckboxPart)d);
            } else if (part instanceof PathInputPart) {
                d = (PathInputPart)part;
                this.setPathControl((TextAndBrowsePanel)this.controls.get(d.getName()), (PathInputPart)d);
            } else if (part instanceof FolderInputPart) {
                d = (FolderInputPart)part;
                this.setFolderControl((TextAndBrowsePanel)this.controls.get(d.getName()), (FolderInputPart)d);
            } else if (part instanceof ListSelectionPart) {
                d = (ListSelectionPart)part;
                if (d.getListType() == 1) {
                    this.setComboControl((Combo)this.controls.get(d.getName()), (ListSelectionPart)d);
                } else {
                    this.setListControl((List)this.controls.get(d.getName()), (ListSelectionPart)d);
                }
            } else if (part instanceof CheckListPart) {
                d = (CheckListPart)part;
                this.setCheckListControl((Table)this.controls.get(d.getName()), (CheckListPart)d);
            } else if (part instanceof CodeFinderPart) {
                d = (CodeFinderPart)part;
                this.setCodeFinderControl((InlineCodeFinderPanel)this.controls.get(d.getName()), (CodeFinderPart)d);
            } else if (part instanceof SpinInputPart) {
                d = (SpinInputPart)part;
                this.setSpinnerControl((Spinner)this.controls.get(d.getName()), (SpinInputPart)d);
            }
            if (part.getMasterPart() == null) continue;
            list.add(part);
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            AbstractPart slavePart = (AbstractPart)list.get(i);
            AbstractPart masterPart = slavePart.getMasterPart();
            Button masterCtrl = (Button)this.controls.get(masterPart.getName());
            Control slaveCtrl = this.controls.get(((AbstractPart)list.get(i)).getName());
            if (!masterCtrl.isEnabled()) continue;
            if (slavePart.isEnabledOnSelection()) {
                slaveCtrl.setEnabled(masterCtrl.getSelection());
                continue;
            }
            slaveCtrl.setEnabled(!masterCtrl.getSelection());
        }
    }

    protected boolean saveData() {
        for (String name : this.controls.keySet()) {
            Control ctrl = this.controls.get(name);
            if (!(ctrl instanceof Text ? !this.saveInputControl((Text)ctrl, (TextInputPart)this.description.getDescriptor(name)) : (ctrl instanceof Button ? (ctrl.getStyle() & 0x20) == 32 && !this.saveCheckboxControl((Button)ctrl, (CheckboxPart)this.description.getDescriptor(name)) : (ctrl instanceof TextAndBrowsePanel ? (this.description.getDescriptor(name) instanceof PathInputPart ? !this.saveTextAndBrowseControl((TextAndBrowsePanel)ctrl, (PathInputPart)this.description.getDescriptor(name)) : this.description.getDescriptor(name) instanceof FolderInputPart && !this.saveFolderControl((TextAndBrowsePanel)ctrl, (FolderInputPart)this.description.getDescriptor(name))) : (ctrl instanceof List ? this.description.getDescriptor(name) instanceof ListSelectionPart && !this.saveListControl((List)ctrl, (ListSelectionPart)this.description.getDescriptor(name)) : (ctrl instanceof Table ? this.description.getDescriptor(name) instanceof CheckListPart && !this.saveCheckListControl((Table)ctrl, (CheckListPart)this.description.getDescriptor(name)) : (ctrl instanceof Combo ? this.description.getDescriptor(name) instanceof ListSelectionPart && !this.saveComboControl((Combo)ctrl, (ListSelectionPart)this.description.getDescriptor(name)) : (ctrl instanceof InlineCodeFinderPanel ? this.description.getDescriptor(name) instanceof CodeFinderPart && !this.saveCodeFinderControl((InlineCodeFinderPanel)ctrl, (CodeFinderPart)this.description.getDescriptor(name)) : ctrl instanceof Spinner && this.description.getDescriptor(name) instanceof SpinInputPart && !this.saveSpinnerControl((Spinner)ctrl, (SpinInputPart)this.description.getDescriptor(name)))))))))) continue;
            return false;
        }
        return true;
    }

    private boolean saveInputControl(Text text, TextInputPart desc) {
        block10: {
            try {
                if (!text.isEnabled()) {
                    return true;
                }
                if (!desc.isAllowEmpty() && text.getText().length() == 0) {
                    Dialogs.showError(this.shell, String.format("Empty entry not allowed for '%s'.", desc.getDisplayName()), null);
                    text.setFocus();
                    return false;
                }
                if (desc.getType().equals(String.class)) {
                    desc.getWriteMethod().invoke(desc.getParent(), text.getText());
                    break block10;
                }
                if (desc.getType().equals(Integer.TYPE)) {
                    try {
                        int n = 0;
                        if (text.getText().length() > 0) {
                            n = Integer.valueOf(text.getText());
                        }
                        if (n < desc.getMinimumValue() || n > desc.getMaximumValue()) {
                            Dialogs.showError(this.shell, String.format("The value must be between %d and %d (both included) for '%s'.", desc.getMinimumValue(), desc.getMaximumValue(), desc.getDisplayName()), null);
                            text.setFocus();
                            text.selectAll();
                            return false;
                        }
                        desc.getWriteMethod().invoke(desc.getParent(), n);
                        break block10;
                    }
                    catch (NumberFormatException e) {
                        Dialogs.showError(this.shell, String.format("Invalid integer value for '%s'.\n", desc.getDisplayName()) + e.getMessage(), null);
                        text.setFocus();
                        text.selectAll();
                        return false;
                    }
                }
                throw new OkapiEditorCreationException(String.format("Invalid type for the parameter '%s'.", desc.getName()));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Dialogs.showError(this.shell, e.getMessage(), null);
                return false;
            }
        }
        return true;
    }

    private boolean saveCheckboxControl(Button button, CheckboxPart desc) {
        block6: {
            try {
                if (!button.isEnabled()) {
                    return true;
                }
                if (desc.getType().equals(Boolean.TYPE)) {
                    desc.getWriteMethod().invoke(desc.getParent(), button.getSelection());
                    break block6;
                }
                if (desc.getType().equals(String.class)) {
                    desc.getWriteMethod().invoke(desc.getParent(), button.getSelection() ? "1" : "0");
                    break block6;
                }
                if (desc.getType().equals(Integer.TYPE)) {
                    desc.getWriteMethod().invoke(desc.getParent(), button.getSelection() ? 1 : 0);
                    break block6;
                }
                throw new OkapiEditorCreationException(String.format("Invalid type for the parameter '%s'.", desc.getName()));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Dialogs.showError(this.shell, e.getMessage(), null);
                return false;
            }
        }
        return true;
    }

    private boolean saveTextAndBrowseControl(TextAndBrowsePanel ctrl, PathInputPart desc) {
        block8: {
            try {
                if (!ctrl.isEnabled()) {
                    return true;
                }
                if (desc.getType().equals(String.class) || desc.getType().equals(URI.class)) {
                    if (!desc.isAllowEmpty() && ctrl.getText().length() == 0) {
                        Dialogs.showError(this.shell, String.format("You must specify a path for '%s'.", desc.getDisplayName()), null);
                        ctrl.setFocus();
                        return false;
                    }
                    if (desc.getType().equals(URI.class)) {
                        String tmp = ctrl.getText();
                        URI uri = null;
                        try {
                            uri = Util.toURI((String)tmp);
                        }
                        catch (Throwable e) {
                            Dialogs.showError(this.shell, String.format("You must specify a valid URI '%s'.", desc.getDisplayName()), null);
                            ctrl.setFocus();
                            return false;
                        }
                        desc.getWriteMethod().invoke(desc.getParent(), uri);
                        break block8;
                    }
                    desc.getWriteMethod().invoke(desc.getParent(), ctrl.getText());
                    break block8;
                }
                throw new OkapiEditorCreationException(String.format("Invalid type for the parameter '%s'.", desc.getName()));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Dialogs.showError(this.shell, e.getMessage(), null);
                return false;
            }
        }
        return true;
    }

    private boolean saveFolderControl(TextAndBrowsePanel ctrl, FolderInputPart desc) {
        try {
            if (!ctrl.isEnabled()) {
                return true;
            }
            if (desc.getType().equals(String.class)) {
                if (ctrl.getText().length() == 0) {
                    Dialogs.showError(this.shell, String.format("You must specify a directory for '%s'.", desc.getDisplayName()), null);
                    ctrl.setFocus();
                    return false;
                }
            } else {
                throw new OkapiEditorCreationException(String.format("Invalid type for the parameter '%s'.", desc.getName()));
            }
            desc.getWriteMethod().invoke(desc.getParent(), ctrl.getText());
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
            return false;
        }
        return true;
    }

    private boolean saveCodeFinderControl(InlineCodeFinderPanel ctrl, CodeFinderPart desc) {
        try {
            if (!ctrl.isEnabled()) {
                return true;
            }
            if (!desc.getType().equals(String.class)) {
                throw new OkapiEditorCreationException(String.format("Invalid type for the parameter '%s'.", desc.getName()));
            }
            String tmp = ctrl.getRules();
            desc.getWriteMethod().invoke(desc.getParent(), tmp);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
            return false;
        }
        return true;
    }

    private boolean saveCheckListControl(Table table, CheckListPart part) {
        try {
            if (!table.isEnabled()) {
                return true;
            }
            Map map = part.getEntries();
            int i = 0;
            for (String name : map.keySet()) {
                ParameterDescriptor desc = (ParameterDescriptor)map.get(name);
                TableItem ti = table.getItem(i);
                desc.getWriteMethod().invoke(desc.getParent(), ti.getChecked());
                ++i;
            }
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
            return false;
        }
        return true;
    }

    private boolean saveListControl(List list, ListSelectionPart desc) {
        block7: {
            try {
                if (!list.isEnabled()) {
                    return true;
                }
                int n = list.getSelectionIndex();
                if (n <= -1) break block7;
                if (desc.getType().equals(String.class)) {
                    desc.getWriteMethod().invoke(desc.getParent(), ((String[])list.getData())[n]);
                    break block7;
                }
                if (desc.getType().equals(Integer.TYPE)) {
                    try {
                        int value = Integer.valueOf(((String[])list.getData())[n]);
                        desc.getWriteMethod().invoke(desc.getParent(), value);
                        break block7;
                    }
                    catch (NumberFormatException e) {
                        throw new OkapiEditorCreationException(String.format("Invalid integer value '%s' for the parameter '%s'.", ((String[])list.getData())[n], desc.getName()));
                    }
                }
                throw new OkapiEditorCreationException(String.format("Invalid type for the parameter '%s'.", desc.getName()));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Dialogs.showError(this.shell, e.getMessage(), null);
                return false;
            }
        }
        return true;
    }

    private boolean saveComboControl(Combo combo, ListSelectionPart desc) {
        block7: {
            try {
                if (!combo.isEnabled()) {
                    return true;
                }
                int n = combo.getSelectionIndex();
                if (n <= -1) break block7;
                if (desc.getType().equals(String.class)) {
                    desc.getWriteMethod().invoke(desc.getParent(), ((String[])combo.getData())[n]);
                    break block7;
                }
                if (desc.getType().equals(Integer.TYPE)) {
                    try {
                        int value = Integer.valueOf(((String[])combo.getData())[n]);
                        desc.getWriteMethod().invoke(desc.getParent(), value);
                        break block7;
                    }
                    catch (NumberFormatException e) {
                        throw new OkapiEditorCreationException(String.format("Invalid integer value '%s' for the parameter '%s'.", ((String[])combo.getData())[n], desc.getName()));
                    }
                }
                throw new OkapiEditorCreationException(String.format("Invalid type for the parameter '%s'.", desc.getName()));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Dialogs.showError(this.shell, e.getMessage(), null);
                return false;
            }
        }
        return true;
    }

    private void setInputControl(Text text, TextInputPart desc) {
        try {
            String tmp = "";
            if (desc.getType().equals(String.class)) {
                tmp = (String)desc.getReadMethod().invoke(desc.getParent(), new Object[0]);
            } else if (desc.getType().equals(Integer.TYPE)) {
                tmp = ((Integer)desc.getReadMethod().invoke(desc.getParent(), new Object[0])).toString();
            } else {
                throw new OkapiEditorCreationException(String.format("Invalid type for the parameter '%s'.", desc.getName()));
            }
            if (tmp == null) {
                text.setText("");
            } else {
                text.setText(tmp);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void setCodeFinderControl(InlineCodeFinderPanel panel, CodeFinderPart desc) {
        try {
            String tmp = "";
            if (!desc.getType().equals(String.class)) {
                throw new OkapiEditorCreationException(String.format("Invalid type for the parameter '%s'.", desc.getName()));
            }
            tmp = (String)desc.getReadMethod().invoke(desc.getParent(), new Object[0]);
            if (tmp == null) {
                panel.setRules("");
            } else {
                panel.setRules(tmp);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private boolean saveSpinnerControl(Spinner ctrl, SpinInputPart desc) {
        try {
            if (!ctrl.isEnabled()) {
                return true;
            }
            if (!desc.getType().equals(Integer.TYPE)) {
                throw new OkapiEditorCreationException(String.format("Invalid type for the parameter '%s'.", desc.getName()));
            }
            desc.getWriteMethod().invoke(desc.getParent(), ctrl.getSelection());
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
            return false;
        }
        return true;
    }

    private void setCheckListControl(Table table, CheckListPart part) {
        try {
            Map map = part.getEntries();
            for (String name : map.keySet()) {
                ParameterDescriptor desc = (ParameterDescriptor)map.get(name);
                TableItem ti = new TableItem(table, 0);
                ti.setText(desc.getDisplayName());
                ti.setChecked(((Boolean)desc.getReadMethod().invoke(desc.getParent(), new Object[0])).booleanValue());
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void setListControl(List list, ListSelectionPart desc) {
        try {
            String current;
            String[] labels = desc.getChoicesLabels();
            String[] values = desc.getChoicesValues();
            if (labels == null) {
                labels = values;
            } else if (labels.length != values.length) {
                throw new OkapiEditorCreationException(String.format("The number of values and labels must be the same for the parameter '%s'.", desc.getName()));
            }
            if (desc.getType().equals(String.class)) {
                current = (String)desc.getReadMethod().invoke(desc.getParent(), new Object[0]);
            } else if (desc.getType().equals(Integer.TYPE)) {
                current = String.valueOf(desc.getReadMethod().invoke(desc.getParent(), new Object[0]));
            } else {
                throw new OkapiEditorCreationException(String.format("Invalid type for the parameter '%s'.", desc.getName()));
            }
            list.setData((Object)values);
            if (current == null) {
                current = "";
            }
            int found = -1;
            int n = 0;
            for (String item : values) {
                list.add(labels[n]);
                if (item.equals(current)) {
                    found = n;
                }
                ++n;
            }
            if (found > -1) {
                list.select(found);
                list.showSelection();
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void setComboControl(Combo combo, ListSelectionPart desc) {
        try {
            String current;
            String[] labels = desc.getChoicesLabels();
            String[] values = desc.getChoicesValues();
            if (labels == null) {
                labels = values;
            } else if (labels.length != values.length) {
                throw new OkapiEditorCreationException(String.format("The number of values and labels must be the same for the parameter '%s'.", desc.getName()));
            }
            if (desc.getType().equals(String.class)) {
                current = (String)desc.getReadMethod().invoke(desc.getParent(), new Object[0]);
            } else if (desc.getType().equals(Integer.TYPE)) {
                current = String.valueOf(desc.getReadMethod().invoke(desc.getParent(), new Object[0]));
            } else {
                throw new OkapiEditorCreationException(String.format("Invalid type for the parameter '%s'.", desc.getName()));
            }
            combo.setData((Object)values);
            if (current == null) {
                current = "";
            }
            int found = -1;
            int n = 0;
            for (String item : values) {
                combo.add(labels[n]);
                if (item.equals(current)) {
                    found = n;
                }
                ++n;
            }
            if (found > -1) {
                combo.select(found);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void setCheckboxControl(Button button, CheckboxPart desc) {
        block5: {
            try {
                if (desc.getType().equals(Boolean.TYPE)) {
                    button.setSelection(((Boolean)desc.getReadMethod().invoke(desc.getParent(), new Object[0])).booleanValue());
                    break block5;
                }
                if (desc.getType().equals(Integer.TYPE)) {
                    int n = (Integer)desc.getReadMethod().invoke(desc.getParent(), new Object[0]);
                    button.setSelection(n != 0);
                    break block5;
                }
                if (desc.getType().equals(String.class)) {
                    String tmp = (String)desc.getReadMethod().invoke(desc.getParent(), new Object[0]);
                    button.setSelection(tmp != null && !tmp.equals("0"));
                    break block5;
                }
                throw new OkapiEditorCreationException(String.format("Invalid type for the parameter '%s'.", desc.getName()));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Dialogs.showError(this.shell, e.getMessage(), null);
            }
        }
    }

    private void setPathControl(TextAndBrowsePanel ctrl, PathInputPart desc) {
        block4: {
            try {
                if (desc.getType().equals(String.class)) {
                    String tmp = (String)desc.getReadMethod().invoke(desc.getParent(), new Object[0]);
                    ctrl.setText(tmp == null ? "" : tmp);
                    break block4;
                }
                if (desc.getType().equals(URI.class)) {
                    URI uri = (URI)desc.getReadMethod().invoke(desc.getParent(), new Object[0]);
                    ctrl.setText(uri.toString());
                    break block4;
                }
                throw new OkapiEditorCreationException(String.format("Invalid type for the parameter '%s'.", desc.getName()));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Dialogs.showError(this.shell, e.getMessage(), null);
            }
        }
    }

    private void setSpinnerControl(Spinner spinner, SpinInputPart desc) {
        try {
            if (!desc.getType().equals(Integer.TYPE)) {
                throw new OkapiEditorCreationException(String.format("Invalid type for the parameter '%s'.", desc.getName()));
            }
            int n = (Integer)desc.getReadMethod().invoke(desc.getParent(), new Object[0]);
            spinner.setSelection(n);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void setFolderControl(TextAndBrowsePanel ctrl, FolderInputPart desc) {
        try {
            if (!desc.getType().equals(String.class)) {
                throw new OkapiEditorCreationException(String.format("Invalid type for the parameter '%s'.", desc.getName()));
            }
            String tmp = (String)desc.getReadMethod().invoke(desc.getParent(), new Object[0]);
            ctrl.setText(tmp == null ? "" : tmp);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private Composite lookupParent(IContainerPart desc) {
        if (desc == null) {
            return this.mainComposite;
        }
        return this.mainComposite;
    }

    private boolean showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private class CtrlSelectionListener
    implements Listener {
        private Button masterCtrl;

        public CtrlSelectionListener(Control masterCtrl) {
            this.masterCtrl = (Button)masterCtrl;
        }

        public void handleEvent(Event event) {
            this.propagate((Control)this.masterCtrl, this.masterCtrl.getSelection(), this.masterCtrl.getEnabled());
        }

        private void propagate(Control ctrl, boolean isCallerSelected, boolean isCallerEnabled) {
            Button button = (Button)ctrl;
            MasterItem mi = GenericEditor.this.masters.get(button);
            for (AbstractPart part : mi.slaves) {
                Control slaveCtrl = GenericEditor.this.controls.get(part.getName());
                boolean slaveEnabled = false;
                if (!isCallerEnabled) {
                    slaveCtrl.setEnabled(false);
                } else {
                    slaveEnabled = isCallerSelected ? part.isEnabledOnSelection() : !part.isEnabledOnSelection();
                    slaveCtrl.setEnabled(slaveEnabled);
                }
                if (!GenericEditor.this.masters.containsKey(slaveCtrl)) continue;
                this.propagate(slaveCtrl, ((Button)slaveCtrl).getSelection(), slaveEnabled);
            }
        }
    }

    private static class MasterItem {
        public ArrayList<AbstractPart> slaves = new ArrayList();

        public void addSlave(AbstractPart part) {
            this.slaves.add(part);
        }
    }
}

