/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.TreeSet;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.ResponsiveTable;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.common.ui.filters.ResponsiveTableFontMappingsInput;
import net.sf.okapi.common.ui.filters.ResponsiveTableFontMappingsOutput;
import net.sf.okapi.filters.openxml.Color;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.HighlightColorValues;
import net.sf.okapi.filters.openxml.ParseType;
import net.sf.okapi.filters.openxml.PresetColorValues;
import net.sf.okapi.filters.openxml.WorksheetConfigurations;
import net.sf.okapi.filters.openxml.ui.ResponsiveTableWorksheetConfigurationsInput;
import net.sf.okapi.filters.openxml.ui.ResponsiveTableWorksheetConfigurationsOutput;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

@EditorFor(value=ConditionalParameters.class)
public class Editor
implements IParametersEditor {
    private static final String[] WORD_SYLES = new String[]{"Emphasis", "ExcludeCharacterStyle", "ExcludeParagraphStyle", "Heading1", "Heading2", "Normal", "Title", "Strong", "Subtitle", "tw4winExternal"};
    private Shell shell;
    private IContext context;
    private boolean readOnly = false;
    private boolean result = false;
    private ConditionalParameters params;
    private ResourceBundle resourceBundle;
    private PresetColorValues presetColorValues;
    private PresetColorValues highlightColorValues;
    private IHelp help;
    private Button btnHelp;
    private Button btnOk;
    private Button btnCancel;
    private Button btnTranslateDocumentProperties;
    private Button translatePowerpointDocumentProperties;
    private Button reorderPowerpointDocumentPropertiesButton;
    private Button reorderPowerpointRelationshipsButton;
    private Button translatePowerpointDiagramDataButton;
    private Button reorderPowerpointDiagramDataButton;
    private Button translatePowerpointChartsButton;
    private Button reorderPowerpointChartsButton;
    private Button translateCommentsButton;
    private Button translatePowerpointCommentsButton;
    private Button reorderPowerpointCommentsButton;
    private Button btnCleanAggressively;
    private Button btnTreatTabAsChar;
    private Button btnTreatLineBreakAsChar;
    private ResponsiveTable fontMappingsTable;
    private Button btnTranslateHeadersAndFooters;
    private Button translateWordNumberingLevelText;
    private Button btnTranslateHiddenText;
    private Button btnExcludeGraphicMetadata;
    private Button btnAutomaticallyAcceptRevisions;
    private Button btnIgnoreSoftHyphen;
    private Button btnReplaceNonBreakingHyphen;
    private Button allowWordStyleOptimisation;
    private Button preserveExcelStylesInTargetColumns;
    private Button btnStylesFromDocument;
    private Button btnColorsFromDocument;
    private Button btnTranslateHiddenCells;
    private Button btnTranslateSheetNames;
    private Button translateCellsCopied;
    private Button btnTranslateDiagramData;
    private Button btnTranslateDrawings;
    private Button btnExtractExternalHyperlinks;
    private Button ignoreFontColors;
    private Text fontColorsMinIgnoranceThreshold;
    private Text fontColorsMaxIgnoranceThreshold;
    private List listExcludedWordStyles;
    private List listTranslatableFields;
    private List listExcelColorsToExclude;
    private Text edSubfilter;
    private ResponsiveTable worksheetConfigurationsTable;
    private Button translatePowerpointNotesButton;
    private Button reorderPowerpointNotesButton;
    private Button btnTranslateMasters;
    private Button btnIgnorePlaceholdersInMasters;
    private Button btnIncludedSlideNumbersOnly;
    private List listPowerpointIncludedSlideNumbers;
    private Button rdExcludeStyles;
    private Button rdIncludeStyles;
    private List listWordHightlightColorsToExclude;
    private Button rdExcludeHighlightStyles;
    private Button rdIncludeHighlightStyles;
    private List listWordColorsToExclude;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean edit(IParameters options, boolean readOnly, IContext context) {
        this.context = context;
        this.readOnly = readOnly;
        this.help = (IHelp)context.getObject("help");
        boolean bRes = false;
        this.shell = null;
        this.params = (ConditionalParameters)options;
        this.resourceBundle = ResourceBundle.getBundle("net.sf.okapi.filters.openxml.ui.Editor");
        this.presetColorValues = new PresetColorValues.Default();
        this.highlightColorValues = new HighlightColorValues();
        try {
            this.createContents();
            boolean bl = this.showDialog();
            return bl;
        }
        catch (Exception E) {
            Dialogs.showError(this.shell, E.getLocalizedMessage(), null);
            bRes = false;
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return bRes;
    }

    public IParameters createParameters() {
        return new ConditionalParameters();
    }

    protected void createContents() {
        Shell parent = (Shell)this.context.getObject("shell");
        this.shell = new Shell(parent, 65648);
        this.shell.setText("Office 2007 Filter Parameters");
        if (parent != null) {
            UIUtil.inheritIcon(this.shell, parent);
        }
        GridLayout layTmp = new GridLayout();
        layTmp.marginBottom = 0;
        layTmp.verticalSpacing = 0;
        this.shell.setLayout((Layout)layTmp);
        TabFolder tabFolder = new TabFolder((Composite)this.shell, 0);
        GridData gdTmp = new GridData(1808);
        tabFolder.setLayoutData((Object)gdTmp);
        TabItem tbtmGeneralOptions_1 = new TabItem(tabFolder, 0);
        tbtmGeneralOptions_1.setText("General Options");
        Composite composite = new Composite((Composite)tabFolder, 0);
        tbtmGeneralOptions_1.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(2, false));
        Composite leftOptions = new Composite(composite, 0);
        leftOptions.setLayout((Layout)new GridLayout());
        leftOptions.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.btnTranslateDocumentProperties = new Button(leftOptions, 32);
        this.btnTranslateDocumentProperties.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnTranslateDocumentProperties.setSelection(true);
        this.btnTranslateDocumentProperties.setText(this.resourceBundle.getString("translate-document-properties"));
        this.translateCommentsButton = new Button(leftOptions, 32);
        this.translateCommentsButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.translateCommentsButton.setSelection(true);
        this.translateCommentsButton.setText(this.resourceBundle.getString("translate-comments"));
        this.btnCleanAggressively = new Button(leftOptions, 32);
        this.btnCleanAggressively.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnCleanAggressively.setSelection(true);
        this.btnCleanAggressively.setText("Clean Tags Aggressively");
        this.btnTreatTabAsChar = new Button(leftOptions, 32);
        this.btnTreatTabAsChar.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnTreatTabAsChar.setSelection(false);
        this.btnTreatTabAsChar.setText("Treat Tab as Character");
        this.btnTreatLineBreakAsChar = new Button(leftOptions, 32);
        this.btnTreatLineBreakAsChar.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnTreatLineBreakAsChar.setSelection(false);
        this.btnTreatLineBreakAsChar.setText("Treat Line Break as Character");
        this.btnExtractExternalHyperlinks = new Button(leftOptions, 32);
        this.btnExtractExternalHyperlinks.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.btnExtractExternalHyperlinks.setSelection(false);
        this.btnExtractExternalHyperlinks.setText(this.resourceBundle.getString("extract-external-hyperlinks"));
        Composite rightOptions = new Composite(composite, 0);
        rightOptions.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        rightOptions.setLayout((Layout)new GridLayout());
        Composite wideOptions = new Composite(composite, 0);
        wideOptions.setLayout((Layout)new GridLayout());
        wideOptions.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Label l = new Label(wideOptions, 0);
        l.setText(this.resourceBundle.getString("font-mappings"));
        this.fontMappingsTable = (ResponsiveTable)this.params.fontMappings().writtenTo((FontMappings.Output)new ResponsiveTableFontMappingsOutput(new ResponsiveTable.Default(new Table(wideOptions, 67586), new Menu((Decorations)this.shell, 8), new Menu((Decorations)this.shell, 8))));
        TabItem tbtmWordOptions = new TabItem(tabFolder, 0);
        tbtmWordOptions.setText("Word Options");
        composite = new Composite((Composite)tabFolder, 0);
        tbtmWordOptions.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(2, false));
        leftOptions = new Composite(composite, 0);
        leftOptions.setLayout((Layout)new GridLayout());
        leftOptions.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.btnTranslateHeadersAndFooters = new Button(leftOptions, 32);
        this.btnTranslateHeadersAndFooters.setSelection(true);
        this.btnTranslateHeadersAndFooters.setText("Translate Headers and Footers");
        this.translateWordNumberingLevelText = new Button(leftOptions, 32);
        this.translateWordNumberingLevelText.setSelection(true);
        this.translateWordNumberingLevelText.setText(this.resourceBundle.getString("translate-numbering-level-text"));
        this.btnTranslateHiddenText = new Button(leftOptions, 32);
        this.btnTranslateHiddenText.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.btnTranslateHiddenText.setSelection(true);
        this.btnTranslateHiddenText.setText("Translate Hidden Text");
        this.btnExcludeGraphicMetadata = new Button(leftOptions, 32);
        this.btnExcludeGraphicMetadata.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.btnExcludeGraphicMetadata.setSelection(false);
        this.btnExcludeGraphicMetadata.setText("Exclude Graphical Metadata");
        this.btnAutomaticallyAcceptRevisions = new Button(leftOptions, 32);
        this.btnAutomaticallyAcceptRevisions.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.btnAutomaticallyAcceptRevisions.setSelection(true);
        this.btnAutomaticallyAcceptRevisions.setText("Automatically Accept Revisions");
        this.btnIgnoreSoftHyphen = new Button(leftOptions, 32);
        this.btnIgnoreSoftHyphen.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.btnIgnoreSoftHyphen.setSelection(false);
        this.btnIgnoreSoftHyphen.setText("Ignore Soft Hyphens");
        this.btnReplaceNonBreakingHyphen = new Button(leftOptions, 32);
        this.btnReplaceNonBreakingHyphen.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.btnReplaceNonBreakingHyphen.setSelection(false);
        this.btnReplaceNonBreakingHyphen.setText("Replace Non-Breaking Hyphen with Regular Hyphen");
        this.allowWordStyleOptimisation = new Button(leftOptions, 32);
        this.allowWordStyleOptimisation.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.allowWordStyleOptimisation.setSelection(true);
        this.allowWordStyleOptimisation.setText(this.resourceBundle.getString("allow-style-optimisation"));
        Group g = new Group(leftOptions, 0);
        g.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        g.setLayout((Layout)new GridLayout());
        g.setText(this.resourceBundle.getString("translatable-fields"));
        this.listTranslatableFields = new List((Composite)g, 514);
        GridData gd_listTranslatableFields = new GridData(4, 4, true, true, 1, 1);
        gd_listTranslatableFields.heightHint = 40;
        this.listTranslatableFields.setLayoutData((Object)gd_listTranslatableFields);
        this.listTranslatableFields.setItems(new String[]{"HYPERLINK", "FORMTEXT", "TOC"});
        g = new Group(leftOptions, 0);
        g.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        g.setLayout((Layout)new GridLayout());
        g.setText(this.resourceBundle.getString("ignored-styles"));
        this.ignoreFontColors = new Button((Composite)g, 32);
        this.ignoreFontColors.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.ignoreFontColors.setSelection(false);
        this.ignoreFontColors.setText(this.resourceBundle.getString("ignore-font-colours"));
        Label l2 = new Label((Composite)g, 0);
        l2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        l2.setText(this.resourceBundle.getString("font-colours-minimum-ignorance-threshold"));
        this.fontColorsMinIgnoranceThreshold = new Text((Composite)g, 2048);
        this.fontColorsMinIgnoranceThreshold.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        l2 = new Label((Composite)g, 0);
        l2.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        l2.setText(this.resourceBundle.getString("font-colours-maximum-ignorance-threshold"));
        this.fontColorsMaxIgnoranceThreshold = new Text((Composite)g, 2048);
        this.fontColorsMaxIgnoranceThreshold.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        rightOptions = new Composite(composite, 0);
        rightOptions.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        rightOptions.setLayout((Layout)new GridLayout());
        Group g2 = new Group(rightOptions, 0);
        g2.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        g2.setLayout((Layout)new GridLayout());
        g2.setText(this.resourceBundle.getString("excluded-included-styles"));
        Composite radiosInLine = new Composite((Composite)g2, 0);
        radiosInLine.setLayoutData((Object)new GridData(4, 4, false, false));
        radiosInLine.setLayout((Layout)new GridLayout(2, true));
        this.rdExcludeStyles = new Button(radiosInLine, 16);
        this.rdExcludeStyles.setText(this.resourceBundle.getString("exclude"));
        this.rdIncludeStyles = new Button(radiosInLine, 16);
        this.rdIncludeStyles.setText(this.resourceBundle.getString("include"));
        this.listExcludedWordStyles = new List((Composite)g2, 514);
        GridData gd_listExcludedWordStyles = new GridData(4, 4, true, true, 1, 1);
        gd_listExcludedWordStyles.heightHint = 40;
        this.listExcludedWordStyles.setLayoutData((Object)gd_listExcludedWordStyles);
        this.listExcludedWordStyles.setItems(WORD_SYLES);
        g2 = new Group(rightOptions, 0);
        g2.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        g2.setLayout((Layout)new GridLayout());
        g2.setText(this.resourceBundle.getString("excluded-included-highlight-colours"));
        radiosInLine = new Composite((Composite)g2, 0);
        radiosInLine.setLayoutData((Object)new GridData(4, 4, false, false));
        radiosInLine.setLayout((Layout)new GridLayout(2, true));
        this.rdExcludeHighlightStyles = new Button(radiosInLine, 16);
        this.rdExcludeHighlightStyles.setText(this.resourceBundle.getString("exclude"));
        this.rdIncludeHighlightStyles = new Button(radiosInLine, 16);
        this.rdIncludeHighlightStyles.setText(this.resourceBundle.getString("include"));
        this.listWordHightlightColorsToExclude = new List((Composite)g2, 514);
        GridData gd_listWordHighlightColorsToExclude = new GridData(4, 4, true, true, 1, 1);
        gd_listWordHighlightColorsToExclude.heightHint = 40;
        this.listWordHightlightColorsToExclude.setLayoutData((Object)gd_listWordHighlightColorsToExclude);
        this.listWordHightlightColorsToExclude.setItems(this.highlightColorValues.externalNames().toArray(new String[0]));
        g2 = new Group(rightOptions, 0);
        g2.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        g2.setLayout((Layout)new GridLayout());
        g2.setText(this.resourceBundle.getString("excluded-font-colours"));
        this.listWordColorsToExclude = new List((Composite)g2, 514);
        GridData gd_listWordColorsToExclude = new GridData(4, 4, true, true, 1, 1);
        gd_listWordColorsToExclude.heightHint = 40;
        this.listWordColorsToExclude.setLayoutData((Object)gd_listWordColorsToExclude);
        this.listWordColorsToExclude.setItems(this.presetColorValues.externalNames().toArray(new String[0]));
        TabItem tbtmPowerpointOptions = new TabItem(tabFolder, 0);
        tbtmPowerpointOptions.setText("Powerpoint Options");
        composite = new Composite((Composite)tabFolder, 0);
        tbtmPowerpointOptions.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(2, false));
        leftOptions = new Composite(composite, 0);
        leftOptions.setLayout((Layout)new GridLayout());
        leftOptions.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.translatePowerpointDocumentProperties = new Button(leftOptions, 32);
        this.translatePowerpointDocumentProperties.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.translatePowerpointDocumentProperties.setSelection(true);
        this.translatePowerpointDocumentProperties.setText(this.resourceBundle.getString("translate-document-properties"));
        this.translatePowerpointDiagramDataButton = new Button(leftOptions, 32);
        this.translatePowerpointDiagramDataButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.translatePowerpointDiagramDataButton.setSelection(true);
        this.translatePowerpointDiagramDataButton.setText(this.resourceBundle.getString("translate-diagram-data"));
        this.translatePowerpointChartsButton = new Button(leftOptions, 32);
        this.translatePowerpointChartsButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.translatePowerpointChartsButton.setSelection(true);
        this.translatePowerpointChartsButton.setText(this.resourceBundle.getString("translate-charts"));
        this.translatePowerpointNotesButton = new Button(leftOptions, 32);
        this.translatePowerpointNotesButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.translatePowerpointNotesButton.setSelection(true);
        this.translatePowerpointNotesButton.setText(this.resourceBundle.getString("translate-notes"));
        this.translatePowerpointCommentsButton = new Button(leftOptions, 32);
        this.translatePowerpointCommentsButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.translatePowerpointCommentsButton.setSelection(true);
        this.translatePowerpointCommentsButton.setText(this.resourceBundle.getString("translate-comments"));
        this.btnTranslateMasters = new Button(leftOptions, 32);
        this.btnTranslateMasters.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnTranslateMasters.setSelection(true);
        this.btnTranslateMasters.setText("Translate Masters");
        this.btnIgnorePlaceholdersInMasters = new Button(leftOptions, 32);
        this.btnIgnorePlaceholdersInMasters.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnIgnorePlaceholdersInMasters.setSelection(true);
        this.btnIgnorePlaceholdersInMasters.setText("Ignore Placeholder Text in Masters");
        this.btnIncludedSlideNumbersOnly = new Button(leftOptions, 32);
        this.btnIncludedSlideNumbersOnly.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnIncludedSlideNumbersOnly.setSelection(false);
        this.btnIncludedSlideNumbersOnly.setText("Translate included slide numbers only");
        this.listPowerpointIncludedSlideNumbers = new List(leftOptions, 2562);
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        gridData.heightHint = 40;
        this.listPowerpointIncludedSlideNumbers.setLayoutData((Object)gridData);
        ArrayList<String> slideNumbers = new ArrayList<String>();
        for (int i = 1; i < 100; ++i) {
            slideNumbers.add(String.valueOf(i));
        }
        this.listPowerpointIncludedSlideNumbers.setItems(slideNumbers.toArray(new String[0]));
        rightOptions = new Composite(composite, 0);
        rightOptions.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        rightOptions.setLayout((Layout)new GridLayout());
        this.reorderPowerpointDocumentPropertiesButton = new Button(rightOptions, 32);
        this.reorderPowerpointDocumentPropertiesButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.reorderPowerpointDocumentPropertiesButton.setSelection(false);
        this.reorderPowerpointDocumentPropertiesButton.setText(this.resourceBundle.getString("reorder-document-properties"));
        this.reorderPowerpointDiagramDataButton = new Button(rightOptions, 32);
        this.reorderPowerpointDiagramDataButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.reorderPowerpointDiagramDataButton.setSelection(false);
        this.reorderPowerpointDiagramDataButton.setText(this.resourceBundle.getString("reorder-diagram-data"));
        this.reorderPowerpointChartsButton = new Button(rightOptions, 32);
        this.reorderPowerpointChartsButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.reorderPowerpointChartsButton.setSelection(false);
        this.reorderPowerpointChartsButton.setText(this.resourceBundle.getString("reorder-charts"));
        this.reorderPowerpointNotesButton = new Button(rightOptions, 32);
        this.reorderPowerpointNotesButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.reorderPowerpointNotesButton.setSelection(true);
        this.reorderPowerpointNotesButton.setText(this.resourceBundle.getString("reorder-notes"));
        this.reorderPowerpointCommentsButton = new Button(rightOptions, 32);
        this.reorderPowerpointCommentsButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.reorderPowerpointCommentsButton.setSelection(true);
        this.reorderPowerpointCommentsButton.setText(this.resourceBundle.getString("reorder-comments"));
        this.reorderPowerpointRelationshipsButton = new Button(rightOptions, 32);
        this.reorderPowerpointRelationshipsButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.reorderPowerpointRelationshipsButton.setSelection(false);
        this.reorderPowerpointRelationshipsButton.setText(this.resourceBundle.getString("reorder-relationships"));
        TabItem tbtmExcelOptions = new TabItem(tabFolder, 0);
        tbtmExcelOptions.setText("Excel Options");
        composite = new Composite((Composite)tabFolder, 0);
        tbtmExcelOptions.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(2, false));
        leftOptions = new Composite(composite, 0);
        leftOptions.setLayout((Layout)new GridLayout());
        leftOptions.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.btnTranslateHiddenCells = new Button(leftOptions, 32);
        this.btnTranslateHiddenCells.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnTranslateHiddenCells.setSelection(false);
        this.btnTranslateHiddenCells.setText("Translate Hidden Rows and Columns");
        this.btnTranslateSheetNames = new Button(leftOptions, 32);
        this.btnTranslateSheetNames.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnTranslateSheetNames.setSelection(true);
        this.btnTranslateSheetNames.setText("Translate Sheet Names");
        this.translateCellsCopied = new Button(leftOptions, 32);
        this.translateCellsCopied.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.translateCellsCopied.setSelection(true);
        this.translateCellsCopied.setText(this.resourceBundle.getString("translate-cells-copied"));
        this.btnTranslateDiagramData = new Button(leftOptions, 32);
        this.btnTranslateDiagramData.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnTranslateDiagramData.setSelection(true);
        this.btnTranslateDiagramData.setText("Translate Diagram Data (e.g. Smart Art)");
        this.btnTranslateDrawings = new Button(leftOptions, 32);
        this.btnTranslateDrawings.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnTranslateDrawings.setSelection(true);
        this.btnTranslateDrawings.setText("Translate Drawings (e.g. Text fields)");
        this.preserveExcelStylesInTargetColumns = new Button(leftOptions, 32);
        this.preserveExcelStylesInTargetColumns.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.preserveExcelStylesInTargetColumns.setSelection(false);
        this.preserveExcelStylesInTargetColumns.setText(this.resourceBundle.getString("preserve-styles-in-target-columns"));
        Label lblSubfilter = new Label(leftOptions, 0);
        lblSubfilter.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblSubfilter.setText("Name of subfilter for cell content:");
        this.edSubfilter = new Text(leftOptions, 2048);
        GridData gd_subfilter = new GridData(4, 4, false, false, 1, 1);
        this.edSubfilter.setLayoutData((Object)gd_subfilter);
        Label l3 = new Label(leftOptions, 0);
        l3.setText(this.resourceBundle.getString("worksheet-configurations"));
        this.worksheetConfigurationsTable = (ResponsiveTable)this.params.worksheetConfigurations().writtenTo((WorksheetConfigurations.Output)new ResponsiveTableWorksheetConfigurationsOutput(new ResponsiveTable.Default(new Table(leftOptions, 67586), new Menu((Decorations)this.shell, 8), new Menu((Decorations)this.shell, 8))));
        rightOptions = new Composite(composite, 0);
        rightOptions.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        rightOptions.setLayout((Layout)new GridLayout());
        g2 = new Group(rightOptions, 0);
        g2.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        g2.setLayout((Layout)new GridLayout());
        g2.setText(this.resourceBundle.getString("excluded-font-colours"));
        this.listExcelColorsToExclude = new List((Composite)g2, 514);
        GridData gd_listExcelColorsToExclude = new GridData(4, 4, true, true, 1, 1);
        gd_listExcelColorsToExclude.heightHint = 40;
        this.listExcelColorsToExclude.setLayoutData((Object)gd_listExcelColorsToExclude);
        this.listExcelColorsToExclude.setItems(this.presetColorValues.externalNames().toArray(new String[0]));
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.result = false;
                if (e.widget.getData().equals("h")) {
                    if (Editor.this.help != null) {
                        Editor.this.help.showWiki("OpenXML Filter");
                    }
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    if (!Editor.this.saveData()) {
                        return;
                    }
                    Editor.this.result = true;
                }
                Editor.this.shell.close();
            }
        };
        OKCancelPanel pnlActions = new OKCancelPanel((Composite)this.shell, 0, OKCancelActions, true);
        gdTmp = new GridData(768);
        pnlActions.setLayoutData(gdTmp);
        pnlActions.btOK.setEnabled(!this.readOnly);
        if (!this.readOnly) {
            this.shell.setDefaultButton(pnlActions.btOK);
        }
        this.shell.pack();
        Rectangle Rect = this.shell.getBounds();
        this.shell.setMinimumSize(Rect.width, Rect.height);
        Point startSize = this.shell.getMinimumSize();
        if (startSize.x < 300) {
            startSize.x = 300;
        }
        if (startSize.y < 200) {
            startSize.y = 200;
        }
        this.shell.setSize(new Point(541, 367));
        Dialogs.centerWindow(this.shell, parent);
        this.setData();
    }

    private boolean showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    protected void setData() {
        int ndx;
        String[] sMulti;
        int siz;
        Iterator it;
        this.btnTranslateDocumentProperties.setSelection(this.params.getTranslateDocProperties());
        this.translatePowerpointDocumentProperties.setSelection(this.params.getTranslatePowerpointDocProperties());
        this.reorderPowerpointDocumentPropertiesButton.setSelection(this.params.getReorderPowerpointDocProperties());
        this.reorderPowerpointRelationshipsButton.setSelection(this.params.getReorderPowerpointRelationships());
        this.translatePowerpointDiagramDataButton.setSelection(this.params.getTranslatePowerpointDiagramData());
        this.reorderPowerpointDiagramDataButton.setSelection(this.params.getReorderPowerpointDiagramData());
        this.translatePowerpointChartsButton.setSelection(this.params.getTranslatePowerpointCharts());
        this.reorderPowerpointChartsButton.setSelection(this.params.getReorderPowerpointCharts());
        this.translateCommentsButton.setSelection(this.params.getTranslateComments());
        this.translatePowerpointCommentsButton.setSelection(this.params.getTranslatePowerpointComments());
        this.reorderPowerpointCommentsButton.setSelection(this.params.getReorderPowerpointComments());
        this.btnCleanAggressively.setSelection(this.params.getCleanupAggressively());
        this.btnTreatTabAsChar.setSelection(this.params.getAddTabAsCharacter());
        this.btnTreatLineBreakAsChar.setSelection(this.params.getAddLineSeparatorCharacter());
        this.btnTranslateHeadersAndFooters.setSelection(this.params.getTranslateWordHeadersFooters());
        this.translateWordNumberingLevelText.setSelection(this.params.getTranslateWordNumberingLevelText());
        this.btnTranslateHiddenText.setSelection(this.params.getTranslateWordHidden() || this.params.getTranslatePowerpointHidden() || this.params.getTranslateExcelHidden());
        this.btnExcludeGraphicMetadata.setSelection(this.params.getTranslateWordExcludeGraphicMetaData());
        this.btnAutomaticallyAcceptRevisions.setSelection(this.params.getAutomaticallyAcceptRevisions());
        this.btnExtractExternalHyperlinks.setSelection(this.params.getExtractExternalHyperlinks());
        this.btnIgnoreSoftHyphen.setSelection(this.params.getIgnoreSoftHyphenTag());
        this.btnReplaceNonBreakingHyphen.setSelection(this.params.getReplaceNoBreakHyphenTag());
        this.allowWordStyleOptimisation.setSelection(this.params.getAllowWordStyleOptimisation());
        this.preserveExcelStylesInTargetColumns.setSelection(this.params.getPreserveExcelStylesInTargetColumns());
        this.translatePowerpointNotesButton.setSelection(this.params.getTranslatePowerpointNotes());
        this.reorderPowerpointNotesButton.setSelection(this.params.getReorderPowerpointNotes());
        this.btnTranslateMasters.setSelection(this.params.getTranslatePowerpointMasters());
        this.btnIgnorePlaceholdersInMasters.setSelection(this.params.getIgnorePlaceholdersInPowerpointMasters());
        this.btnTranslateSheetNames.setSelection(this.params.getTranslateExcelSheetNames());
        this.translateCellsCopied.setSelection(this.params.getTranslateExcelCellsCopied());
        this.btnTranslateDiagramData.setSelection(this.params.getTranslateExcelDiagramData());
        this.btnTranslateDrawings.setSelection(this.params.getTranslateExcelDrawings());
        this.ignoreFontColors.setSelection(this.params.getIgnoreWordFontColors());
        this.fontColorsMinIgnoranceThreshold.setText(this.params.getWordFontColorsMinIgnoranceThreshold());
        this.fontColorsMaxIgnoranceThreshold.setText(this.params.getWordFontColorsMaxIgnoranceThreshold());
        this.rdExcludeStyles.setSelection(this.params.getTranslateWordInExcludeStyleMode());
        this.rdIncludeStyles.setSelection(!this.params.getTranslateWordInExcludeStyleMode());
        this.rdExcludeHighlightStyles.setSelection(this.params.getTranslateWordInExcludeHighlightMode());
        this.rdIncludeHighlightStyles.setSelection(!this.params.getTranslateWordInExcludeHighlightMode());
        if (this.params.getTranslateWordInExcludeStyleMode() && this.params.tsExcludeWordStyles != null && !this.params.tsExcludeWordStyles.isEmpty()) {
            it = this.params.tsExcludeWordStyles.iterator();
            siz = this.params.tsExcludeWordStyles.size();
            if (siz > 0) {
                sMulti = new String[siz];
                ndx = 0;
                while (it.hasNext()) {
                    sMulti[ndx++] = (String)it.next();
                }
                this.listExcludedWordStyles.setSelection(sMulti);
            }
        }
        if (this.params.getTranslateWordInExcludeHighlightMode() && this.params.tsWordHighlightColors != null && !this.params.tsWordHighlightColors.isEmpty()) {
            it = this.params.tsWordHighlightColors.iterator();
            siz = this.params.tsWordHighlightColors.size();
            if (siz > 0) {
                sMulti = new String[siz];
                ndx = 0;
                while (it.hasNext()) {
                    String v = (String)it.next();
                    Color.Value cv = this.highlightColorValues.valueFor(v);
                    String name = cv.asExternalName();
                    if (name.isEmpty()) continue;
                    sMulti[ndx++] = name;
                }
                this.listWordHightlightColorsToExclude.setSelection(sMulti);
            }
        }
        if (this.params.getTranslateWordExcludeColors() && this.params.tsWordExcludedColors != null && !this.params.tsWordExcludedColors.isEmpty()) {
            this.setOfficeColors(this.params.tsWordExcludedColors, this.listWordColorsToExclude);
        }
        if (this.params.tsComplexFieldDefinitionsToExtract != null && !this.params.tsComplexFieldDefinitionsToExtract.isEmpty()) {
            it = this.params.tsComplexFieldDefinitionsToExtract.iterator();
            siz = this.params.tsComplexFieldDefinitionsToExtract.size();
            if (siz > 0) {
                sMulti = new String[siz];
                ndx = 0;
                while (it.hasNext()) {
                    sMulti[ndx++] = (String)it.next();
                }
                this.listTranslatableFields.setSelection(sMulti);
            }
        }
        if (this.params.getTranslateExcelExcludeColors() && this.params.tsExcelExcludedColors != null && !this.params.tsExcelExcludedColors.isEmpty()) {
            this.setOfficeColors(this.params.tsExcelExcludedColors, this.listExcelColorsToExclude);
        }
        this.btnTranslateHiddenCells.setSelection(this.params.getTranslateExcelHidden());
        this.edSubfilter.setText(this.params.getSubfilter());
        this.btnIncludedSlideNumbersOnly.setSelection(this.params.getPowerpointIncludedSlideNumbersOnly());
        ArrayList<String> selectedSlideNumbers = new ArrayList<String>();
        for (Integer slideNumber : this.params.tsPowerpointIncludedSlideNumbers) {
            selectedSlideNumbers.add(slideNumber.toString());
        }
        this.listPowerpointIncludedSlideNumbers.setSelection(selectedSlideNumbers.toArray(new String[0]));
    }

    private boolean saveData() {
        String name;
        int i;
        this.params.reset();
        this.params.setTranslateDocProperties(this.btnTranslateDocumentProperties.getSelection());
        this.params.setTranslatePowerpointDocProperties(this.translatePowerpointDocumentProperties.getSelection());
        this.params.setReorderPowerpointDocProperties(this.reorderPowerpointDocumentPropertiesButton.getSelection());
        this.params.setReorderPowerpointRelationships(this.reorderPowerpointRelationshipsButton.getSelection());
        this.params.setTranslatePowerpointDiagramData(this.translatePowerpointDiagramDataButton.getSelection());
        this.params.setReorderPowerpointDiagramData(this.reorderPowerpointDiagramDataButton.getSelection());
        this.params.setTranslatePowerpointCharts(this.translatePowerpointChartsButton.getSelection());
        this.params.setReorderPowerpointCharts(this.reorderPowerpointChartsButton.getSelection());
        this.params.setTranslateComments(this.translateCommentsButton.getSelection());
        this.params.setTranslatePowerpointComments(this.translatePowerpointCommentsButton.getSelection());
        this.params.setReorderPowerpointComments(this.reorderPowerpointCommentsButton.getSelection());
        this.params.setCleanupAggressively(this.btnCleanAggressively.getSelection());
        this.params.setAddTabAsCharacter(this.btnTreatTabAsChar.getSelection());
        this.params.setAddLineSeparatorCharacter(this.btnTreatLineBreakAsChar.getSelection());
        this.params.fontMappings().addFrom((FontMappings.Input)new ResponsiveTableFontMappingsInput(this.fontMappingsTable));
        this.params.setTranslateWordHeadersFooters(this.btnTranslateHeadersAndFooters.getSelection());
        this.params.setTranslateWordNumberingLevelText(this.translateWordNumberingLevelText.getSelection());
        this.params.setTranslateWordHidden(this.btnTranslateHiddenText.getSelection());
        this.params.setTranslateWordExcludeGraphicMetaData(this.btnExcludeGraphicMetadata.getSelection());
        this.params.setTranslatePowerpointHidden(this.btnTranslateHiddenCells.getSelection());
        this.params.setAutomaticallyAcceptRevisions(this.btnAutomaticallyAcceptRevisions.getSelection());
        this.params.setIgnoreSoftHyphenTag(this.btnIgnoreSoftHyphen.getSelection());
        this.params.setReplaceNoBreakHyphenTag(this.btnReplaceNonBreakingHyphen.getSelection());
        this.params.setAllowWordStyleOptimisation(this.allowWordStyleOptimisation.getSelection());
        this.params.setPreserveExcelStylesInTargetColumns(this.preserveExcelStylesInTargetColumns.getSelection());
        this.params.setTranslatePowerpointNotes(this.translatePowerpointNotesButton.getSelection());
        this.params.setReorderPowerpointNotes(this.reorderPowerpointNotesButton.getSelection());
        this.params.setTranslatePowerpointMasters(this.btnTranslateMasters.getSelection());
        this.params.setIgnorePlaceholdersInPowerpointMasters(this.btnIgnorePlaceholdersInMasters.getSelection());
        this.params.setTranslateExcelSheetNames(this.btnTranslateSheetNames.getSelection());
        this.params.setTranslateExcelCellsCopied(this.translateCellsCopied.getSelection());
        this.params.setTranslateExcelDiagramData(this.btnTranslateDiagramData.getSelection());
        this.params.setTranslateExcelDrawings(this.btnTranslateDrawings.getSelection());
        this.params.setExtractExternalHyperlinks(this.btnExtractExternalHyperlinks.getSelection());
        this.params.setIgnoreWordFontColors(this.ignoreFontColors.getSelection());
        if (!this.fontColorsMinIgnoranceThreshold.getText().isEmpty()) {
            this.params.setWordFontColorsMinIgnoranceThreshold(this.fontColorsMinIgnoranceThreshold.getText());
        }
        if (!this.fontColorsMaxIgnoranceThreshold.getText().isEmpty()) {
            this.params.setWordFontColorsMaxIgnoranceThreshold(this.fontColorsMaxIgnoranceThreshold.getText());
        }
        this.params.setTranslateWordInExcludeStyleMode(this.rdExcludeStyles.getSelection());
        this.params.setTranslateWordInExcludeHighlightMode(this.rdExcludeHighlightStyles.getSelection());
        String[] sArray = this.listExcludedWordStyles.getSelection();
        if (this.params.tsExcludeWordStyles == null) {
            this.params.tsExcludeWordStyles = new TreeSet();
        } else {
            this.params.tsExcludeWordStyles.clear();
        }
        int len = sArray.length;
        if (len > 0) {
            for (i = 0; i < len; ++i) {
                this.params.tsExcludeWordStyles.add(sArray[i]);
            }
        }
        sArray = this.listWordHightlightColorsToExclude.getSelection();
        if (this.params.tsWordHighlightColors == null) {
            this.params.tsWordHighlightColors = new TreeSet();
        } else {
            this.params.tsWordHighlightColors.clear();
        }
        len = sArray.length;
        if (len > 0) {
            for (i = 0; i < len; ++i) {
                this.params.tsWordHighlightColors.add(sArray[i]);
            }
        } else {
            this.params.setTranslateWordInExcludeHighlightMode(false);
        }
        sArray = this.listWordColorsToExclude.getSelection();
        if (this.params.tsWordExcludedColors == null) {
            this.params.tsWordExcludedColors = new TreeSet();
        } else {
            this.params.tsWordExcludedColors.clear();
        }
        len = sArray.length;
        if (len > 0) {
            this.params.setTranslateWordExcludeColors(true);
            for (i = 0; i < len; ++i) {
                name = this.presetColorValues.valueFor(sArray[i]).asExternalName();
                if (name.isEmpty()) {
                    this.params.tsWordExcludedColors.add(sArray[i]);
                    continue;
                }
                this.params.tsWordExcludedColors.add(name);
            }
        } else {
            this.params.setTranslateWordExcludeColors(false);
        }
        sArray = this.listTranslatableFields.getSelection();
        if (this.params.tsComplexFieldDefinitionsToExtract == null) {
            this.params.tsComplexFieldDefinitionsToExtract = new TreeSet();
        } else {
            this.params.tsComplexFieldDefinitionsToExtract.clear();
        }
        len = sArray.length;
        if (len > 0) {
            for (i = 0; i < len; ++i) {
                this.params.tsComplexFieldDefinitionsToExtract.add(sArray[i]);
            }
        }
        this.params.setTranslateExcelHidden(this.btnTranslateHiddenCells.getSelection());
        if (!this.edSubfilter.getText().isEmpty()) {
            this.params.setSubfilter(this.edSubfilter.getText());
        }
        this.params.worksheetConfigurations().addFrom((WorksheetConfigurations.Input)new ResponsiveTableWorksheetConfigurationsInput(this.worksheetConfigurationsTable));
        sArray = this.listExcelColorsToExclude.getSelection();
        if (this.params.tsExcelExcludedColors == null) {
            this.params.tsExcelExcludedColors = new TreeSet();
        } else {
            this.params.tsExcelExcludedColors.clear();
        }
        len = sArray.length;
        if (len > 0) {
            this.params.setTranslateExcelExcludeColors(true);
            for (i = 0; i < len; ++i) {
                name = this.presetColorValues.valueFor(sArray[i]).asExternalName();
                if (name.isEmpty()) {
                    this.params.tsExcelExcludedColors.add(sArray[i]);
                    continue;
                }
                this.params.tsExcelExcludedColors.add(name);
            }
        } else {
            this.params.setTranslateExcelExcludeColors(false);
        }
        this.params.setPowerpointIncludedSlideNumbersOnly(this.btnIncludedSlideNumbersOnly.getSelection());
        if (this.params.tsPowerpointIncludedSlideNumbers == null) {
            this.params.tsPowerpointIncludedSlideNumbers = new TreeSet();
        } else {
            this.params.tsPowerpointIncludedSlideNumbers.clear();
        }
        if (this.btnIncludedSlideNumbersOnly.getSelection()) {
            ArrayList<Integer> slideNumbers = new ArrayList<Integer>();
            for (String s : this.listPowerpointIncludedSlideNumbers.getSelection()) {
                slideNumbers.add(Integer.valueOf(s));
            }
            this.params.tsPowerpointIncludedSlideNumbers.addAll(slideNumbers);
        }
        this.params.nFileType = ParseType.MSWORD;
        return true;
    }

    private void setOfficeColors(TreeSet<String> values, List nameableRgbValues) {
        TreeSet<String> tsColors = new TreeSet<String>();
        for (String v : values) {
            Color.Value cv = this.presetColorValues.valueFor(v);
            String name = cv.asExternalName();
            if (name.isEmpty()) {
                nameableRgbValues.add(v);
                tsColors.add(v);
                continue;
            }
            tsColors.add(name);
        }
        int siz = tsColors.size();
        if (siz > 0) {
            String[] sMulti = new String[siz];
            Iterator<String> it = tsColors.iterator();
            int ndx = 0;
            while (it.hasNext()) {
                sMulti[ndx++] = it.next();
            }
            nameableRgbValues.setSelection(sMulti);
        }
    }
}

