/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml.ui;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.okapi.filters.openxml.WorksheetConfiguration;
import org.eclipse.swt.widgets.TableItem;

final class TableItemWorksheetConfiguration
implements WorksheetConfiguration {
    static final String DELIMITER = ",";
    private static final String DELIMITING_EXPRESSION = "\\s*,\\s*";
    private final TableItem tableItem;
    private WorksheetConfiguration worksheetConfiguration;
    private boolean read;

    TableItemWorksheetConfiguration(TableItem tableItem) {
        this.tableItem = tableItem;
    }

    public boolean matches(String worksheetName) {
        if (!this.read) {
            this.fromTableItem();
        }
        return this.worksheetConfiguration.matches(worksheetName);
    }

    public Set<String> sourceColumns() {
        if (!this.read) {
            this.fromTableItem();
        }
        return this.worksheetConfiguration.sourceColumns();
    }

    public Set<String> targetColumns() {
        if (!this.read) {
            this.fromTableItem();
        }
        return this.worksheetConfiguration.targetColumns();
    }

    public Set<Integer> excludedRows() {
        if (!this.read) {
            this.fromTableItem();
        }
        return this.worksheetConfiguration.excludedRows();
    }

    public Set<String> excludedColumns() {
        if (!this.read) {
            this.fromTableItem();
        }
        return this.worksheetConfiguration.excludedColumns();
    }

    public Set<Integer> metadataRows() {
        if (!this.read) {
            this.fromTableItem();
        }
        return this.worksheetConfiguration.metadataRows();
    }

    public Set<String> metadataColumns() {
        if (!this.read) {
            this.fromTableItem();
        }
        return this.worksheetConfiguration.metadataColumns();
    }

    private void fromTableItem() {
        this.worksheetConfiguration = new WorksheetConfiguration.Default(this.tableItem.getText(0), Arrays.stream(this.tableItem.getText(1).split(DELIMITING_EXPRESSION)).filter(s -> !s.isEmpty()).collect(Collectors.toList()), Arrays.stream(this.tableItem.getText(2).split(DELIMITING_EXPRESSION)).filter(s -> !s.isEmpty()).collect(Collectors.toList()), Arrays.stream(this.tableItem.getText(3).split(DELIMITING_EXPRESSION)).filter(s -> !s.isEmpty()).map(s -> Integer.parseUnsignedInt(s)).collect(Collectors.toList()), Arrays.stream(this.tableItem.getText(4).split(DELIMITING_EXPRESSION)).filter(s -> !s.isEmpty()).collect(Collectors.toList()), Arrays.stream(this.tableItem.getText(5).split(DELIMITING_EXPRESSION)).filter(s -> !s.isEmpty()).map(s -> Integer.parseUnsignedInt(s)).collect(Collectors.toList()), Arrays.stream(this.tableItem.getText(6).split(DELIMITING_EXPRESSION)).filter(s -> !s.isEmpty()).collect(Collectors.toList()));
        this.read = true;
    }

    public <T> T writtenTo(WorksheetConfiguration.Output<T> output) {
        if (!this.read) {
            this.fromTableItem();
        }
        return (T)this.worksheetConfiguration.writtenTo(output);
    }
}

