/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.ui.segmentation;

import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.lib.segmentation.Rule;
import net.sf.okapi.lib.ui.segmentation.Res;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RuleDialog {
    private Shell shell;
    private Text edBefore;
    private Text edAfter;
    private Button rdBreak;
    private Button rdNoBreak;
    private Rule result = null;
    private IHelp help;
    private Text edComments;

    public RuleDialog(Shell parent, Rule rule, IHelp helpParam) {
        int indent;
        this.help = helpParam;
        this.shell = new Shell(parent, 65648);
        this.shell.setText(Res.getString("ruleDlg.caption"));
        UIUtil.inheritIcon(this.shell, parent);
        this.shell.setLayout((Layout)new GridLayout());
        Composite cmpTmp = new Composite((Composite)this.shell, 2048);
        cmpTmp.setLayoutData((Object)new GridData(1808));
        GridLayout layTmp = new GridLayout();
        cmpTmp.setLayout((Layout)layTmp);
        Label label = new Label(cmpTmp, 0);
        label.setText(Res.getString("ruleDlg.beforeLabel"));
        this.edBefore = new Text(cmpTmp, 2052);
        GridData gdTmp = new GridData(768);
        this.edBefore.setLayoutData((Object)gdTmp);
        label = new Label(cmpTmp, 0);
        label.setText(Res.getString("ruleDlg.afterLabel"));
        this.edAfter = new Text(cmpTmp, 2052);
        gdTmp = new GridData(768);
        this.edAfter.setLayoutData((Object)gdTmp);
        label = new Label(cmpTmp, 0);
        label.setText(Res.getString("ruleDlg.actionLabel"));
        this.rdBreak = new Button(cmpTmp, 16);
        this.rdBreak.setText(Res.getString("ruleDlg.isBreak"));
        gdTmp = new GridData();
        gdTmp.horizontalIndent = indent = 20;
        this.rdBreak.setLayoutData((Object)gdTmp);
        this.rdNoBreak = new Button(cmpTmp, 16);
        this.rdNoBreak.setText(Res.getString("ruleDlg.notBreak"));
        gdTmp = new GridData();
        gdTmp.horizontalIndent = indent;
        this.rdNoBreak.setLayoutData((Object)gdTmp);
        this.rdBreak.setSelection(rule.isBreak());
        this.rdNoBreak.setSelection(!rule.isBreak());
        label = new Label(cmpTmp, 0);
        label.setText(Res.getString("RuleDialog.comments"));
        this.edComments = new Text(cmpTmp, 2562);
        gdTmp = new GridData(1808);
        gdTmp.heightHint = 60;
        this.edComments.setLayoutData((Object)gdTmp);
        this.edComments.setText(rule.getComment() == null ? "" : rule.getComment());
        SelectionAdapter okCancelActions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuleDialog.this.result = null;
                if (e.widget.getData().equals("h")) {
                    if (RuleDialog.this.help != null) {
                        RuleDialog.this.help.showWiki("Ratel - Edit Rule");
                    }
                    return;
                }
                if (e.widget.getData().equals("o") && !RuleDialog.this.saveData()) {
                    return;
                }
                RuleDialog.this.shell.close();
            }
        };
        OKCancelPanel pnlActions = new OKCancelPanel((Composite)this.shell, 0, okCancelActions, true);
        pnlActions.setLayoutData(new GridData(768));
        this.shell.setDefaultButton(pnlActions.btOK);
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        Point startSize = this.shell.getMinimumSize();
        if (startSize.x < 600) {
            startSize.x = 600;
        }
        this.shell.setSize(startSize);
        Dialogs.centerWindow(this.shell, parent);
        this.edAfter.setText(rule.getAfter());
        this.edBefore.setText(rule.getBefore());
    }

    public Rule showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private boolean saveData() {
        try {
            if (this.edBefore.getText().length() == 0 && this.edAfter.getText().length() == 0) {
                this.edBefore.selectAll();
                this.edBefore.setFocus();
                return false;
            }
            this.result = new Rule(this.edBefore.getText(), this.edAfter.getText(), this.rdBreak.getSelection());
            this.result.setComment(this.edComments.getText());
            return true;
        }
        catch (Exception e) {
            Dialogs.showError(this.shell, e.getLocalizedMessage(), null);
            return false;
        }
    }
}

