/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.ui.segmentation;

import java.util.ArrayList;
import net.sf.okapi.lib.segmentation.Rule;
import net.sf.okapi.lib.ui.segmentation.Res;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

class RulesTableModel {
    Table table;
    ArrayList<Rule> list;

    RulesTableModel() {
    }

    void linkTable(Table newTable) {
        this.table = newTable;
        TableColumn col = new TableColumn(this.table, 0);
        col.setText(Res.getString("ruleTable.type"));
        col = new TableColumn(this.table, 0);
        col.setText(Res.getString("ruleTable.beforeBreak"));
        col = new TableColumn(this.table, 0);
        col.setText(Res.getString("ruleTable.afterBreak"));
    }

    void setLanguageRules(ArrayList<Rule> list) {
        this.list = list;
    }

    void updateTable(int selection) {
        this.table.removeAll();
        if (this.list == null) {
            return;
        }
        for (Rule rule : this.list) {
            TableItem item = new TableItem(this.table, 0);
            item.setChecked(rule.isActive());
            item.setText(0, rule.isBreak() ? Res.getString("ruleTable.break") : Res.getString("ruleTable.noBreak"));
            item.setText(1, rule.getBefore());
            item.setText(2, rule.getAfter());
        }
        if (selection < 0 || selection > this.table.getItemCount() - 1) {
            selection = this.table.getItemCount() - 1;
        }
        if (this.table.getItemCount() > 0) {
            this.table.setSelection(selection);
        }
    }
}

