/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.ui.verification;

import java.util.List;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.lib.verification.Issue;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

class IssuesTableModel {
    Table table;
    List<Issue> list;
    Color[] colors;

    public IssuesTableModel(Display display) {
        this.colors = new Color[]{display.getSystemColor(7), new Color(null, 255, 153, 0), display.getSystemColor(3)};
    }

    protected void finalize() {
        this.dispose();
    }

    public void dispose() {
        if (this.colors != null) {
            this.colors[1].dispose();
            this.colors[1] = null;
        }
    }

    void linkTable(Table newTable, Listener sortListener) {
        this.table = newTable;
        TableColumn col = new TableColumn(this.table, 0);
        col.addListener(13, sortListener);
        col = new TableColumn(this.table, 0);
        col.addListener(13, sortListener);
        col = new TableColumn(this.table, 0);
        col.setText("Text Unit");
        col.addListener(13, sortListener);
        col = new TableColumn(this.table, 0);
        col.setText("Seg");
        col.addListener(13, sortListener);
        col = new TableColumn(this.table, 0);
        col.setText("Description");
        col.addListener(13, sortListener);
    }

    void setIssues(List<Issue> list) {
        this.list = list;
    }

    void updateTable(int selection, int displayType, int issueType) {
        this.table.removeAll();
        if (this.list == null) {
            return;
        }
        block18: for (Issue issue : this.list) {
            switch (displayType) {
                case 1: {
                    if (issue.getEnabled()) break;
                    continue block18;
                }
                case 2: {
                    if (!issue.getEnabled()) break;
                    continue block18;
                }
            }
            if (issueType > 0) {
                IssueType itype = issue.getIssueType();
                if (itype == null) {
                    if (issueType != 13) {
                        continue;
                    }
                } else {
                    switch (itype) {
                        case MISSING_TARGETTU: {
                            if (issueType == 1) break;
                            continue block18;
                        }
                        case MISSING_TARGETSEG: 
                        case EXTRA_TARGETSEG: {
                            if (issueType == 2) break;
                            continue block18;
                        }
                        case EMPTY_TARGETSEG: 
                        case EMPTY_SOURCESEG: {
                            if (issueType == 3) break;
                            continue block18;
                        }
                        case TARGET_SAME_AS_SOURCE: {
                            if (issueType == 4) break;
                            continue block18;
                        }
                        case MISSING_LEADINGWS: 
                        case MISSINGORDIFF_LEADINGWS: 
                        case MISSING_TRAILINGWS: 
                        case MISSINGORDIFF_TRAILINGWS: 
                        case EXTRA_LEADINGWS: 
                        case EXTRAORDIFF_LEADINGWS: 
                        case EXTRA_TRAILINGWS: 
                        case EXTRAORDIFF_TRAILINGWS: {
                            if (issueType == 5) break;
                            continue block18;
                        }
                        case MISSING_CODE: 
                        case EXTRA_CODE: 
                        case SUSPECT_CODE: {
                            if (issueType == 6) break;
                            continue block18;
                        }
                        case UNEXPECTED_PATTERN: {
                            if (issueType == 7) break;
                            continue block18;
                        }
                        case SUSPECT_PATTERN: {
                            if (issueType == 8) break;
                            continue block18;
                        }
                        case SOURCE_LENGTH: 
                        case TARGET_LENGTH: {
                            if (issueType == 9) break;
                            continue block18;
                        }
                        case ALLOWED_CHARACTERS: {
                            if (issueType == 10) break;
                            continue block18;
                        }
                        case TERMINOLOGY: {
                            if (issueType == 11) break;
                            continue block18;
                        }
                        case LANGUAGETOOL_ERROR: {
                            if (issueType == 12) break;
                            continue block18;
                        }
                        default: {
                            continue block18;
                        }
                    }
                }
            }
            TableItem item = new TableItem(this.table, 0);
            item.setChecked(issue.getEnabled());
            item.setForeground(1, this.colors[issue.getDisplaySeverity()]);
            item.setText(1, "\u2588");
            if (issue.getTuName() == null) {
                item.setText(2, issue.getTuId());
            } else {
                item.setText(2, issue.getTuId() + " (" + issue.getTuName() + ")");
            }
            item.setText(3, issue.getSegId() == null ? "" : issue.getSegId());
            item.setText(4, issue.getMessage());
            item.setData((Object)issue);
        }
        if (selection < 0 || selection > this.table.getItemCount() - 1) {
            selection = this.table.getItemCount() - 1;
        }
        if (this.table.getItemCount() > 0) {
            this.table.setSelection(selection);
        }
    }
}

