/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.utilities.merging;

import java.io.File;
import java.net.URI;
import net.sf.okapi.applications.rainbow.packages.IReader;
import net.sf.okapi.applications.rainbow.packages.Manifest;
import net.sf.okapi.applications.rainbow.packages.ManifestItem;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.DefaultFilters;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.lib.merge.merge.ITextUnitMerger;
import net.sf.okapi.lib.merge.merge.Parameters;
import net.sf.okapi.lib.merge.merge.TextUnitMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Merger {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Manifest manifest;
    private IReader reader;
    private FilterConfigurationMapper mapper = new FilterConfigurationMapper();
    private IFilter inpFilter;
    private IFilterWriter outFilter;
    private LocaleId trgLoc;
    private final ITextUnitMerger textUnitMerger;

    public Merger() {
        DefaultFilters.setMappings((IFilterConfigurationMapper)this.mapper, (boolean)false, (boolean)true);
        this.textUnitMerger = new TextUnitMerger();
        Parameters p = new Parameters();
        this.textUnitMerger.setParameters(p);
    }

    public void initialize(Manifest manifest) {
        if (this.reader != null) {
            this.reader.closeDocument();
            this.reader = null;
        }
        this.manifest = manifest;
        this.trgLoc = manifest.getTargetLanguage();
    }

    public void execute(int docId) {
        ManifestItem item = this.manifest.getItem(docId);
        if (!item.selected()) {
            return;
        }
        this.merge(docId, item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void merge(int docId, ManifestItem item) {
        try {
            String fileToMerge = this.manifest.getFileToMergePath(docId);
            if (this.reader == null) {
                this.reader = (IReader)Class.forName(this.manifest.getReaderClass()).newInstance();
            }
            this.logger.info("\nMerging: {}", (Object)fileToMerge);
            String originalFile = this.manifest.getRoot() + File.separator + this.manifest.getOriginalLocation() + File.separator + String.format("%d.ori", docId);
            String paramsFile = this.manifest.getRoot() + File.separator + this.manifest.getOriginalLocation() + File.separator + String.format("%d.fprm", docId);
            this.inpFilter = this.mapper.createFilter(item.getFilterID(), this.inpFilter);
            IParameters params = this.inpFilter.getParameters();
            if (params != null) {
                File file = new File(paramsFile);
                params.load(Util.URItoURL((URI)file.toURI()), false);
            }
            this.reader.openDocument(fileToMerge, this.manifest.getSourceLanguage(), this.manifest.getTargetLanguage());
            File f = new File(originalFile);
            this.inpFilter.open(new RawDocument(f.toURI(), item.getInputEncoding(), this.manifest.getSourceLanguage(), this.trgLoc));
            String outputFile = this.manifest.getFileToGeneratePath(docId);
            Util.createDirectories((String)outputFile);
            this.outFilter = this.inpFilter.createFilterWriter();
            this.outFilter.setOptions(this.trgLoc, item.getOutputEncoding());
            this.outFilter.setOutput(outputFile);
            while (this.inpFilter.hasNext()) {
                Event event = this.inpFilter.next();
                if (event.getEventType() == EventType.TEXT_UNIT) {
                    ITextUnit mergedTu = this.processTextUnit(event.getTextUnit());
                    this.outFilter.handleEvent(new Event(EventType.TEXT_UNIT, (IResource)mergedTu));
                    continue;
                }
                this.outFilter.handleEvent(event);
            }
        }
        catch (Exception e) {
            Throwable e2 = e.getCause();
            this.logger.error("Merging error. {}", (Object)(e2 != null ? e2.getMessage() : e.getMessage()), (Object)e);
        }
        finally {
            if (this.reader != null) {
                this.reader.closeDocument();
                this.reader = null;
            }
            if (this.inpFilter != null) {
                this.inpFilter.close();
                this.inpFilter = null;
            }
            if (this.outFilter != null) {
                this.outFilter.close();
                this.outFilter = null;
            }
        }
    }

    private ITextUnit processTextUnit(ITextUnit tuFromSkel) {
        if (!tuFromSkel.isTranslatable()) {
            return tuFromSkel;
        }
        if (!this.reader.readItem()) {
            this.logger.warn("There are no more items in the package to merge with id=\"{}\".", (Object)tuFromSkel.getId());
            return tuFromSkel;
        }
        this.textUnitMerger.setTargetLocale(this.trgLoc);
        ITextUnit mergedTu = this.textUnitMerger.mergeTargets(tuFromSkel, this.reader.getItem());
        if (this.manifest.updateApprovedFlag()) {
            mergedTu.getTarget(this.trgLoc).setProperty(new Property("approved", "yes"));
        }
        return mergedTu;
    }
}

